/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.cache;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.util.DateUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisService {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public long increment(String key, long delta) {
        if (delta < 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_90002);
        }
        try {
            long id = this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
            if (id == 1L) {
                this.stringRedisTemplate.expire((Object)key, DateUtil.toEndDayMillis(), TimeUnit.MILLISECONDS);
            }
            return id;
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_90001);
        }
    }

    public long incrementMonth(String key, long delta) {
        if (delta < 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_90002);
        }
        try {
            long id = this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
            if (id == 1L) {
                this.stringRedisTemplate.expire((Object)key, DateUtil.toEndMonthMillis(), TimeUnit.MILLISECONDS);
            }
            return id;
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_90001);
        }
    }
}

