/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.esign.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.order.OrderLogService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.esign.domain.ActionEnum;
import com.digiwin.dap.middleware.omc.support.esign.domain.Esign;
import com.digiwin.dap.middleware.omc.support.esign.domain.FinishDoc;
import com.digiwin.dap.middleware.omc.support.esign.domain.FinishDocUrl;
import com.digiwin.dap.middleware.omc.support.esign.domain.SignFlow;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateId;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateValue;
import com.digiwin.dap.middleware.omc.support.esign.domain.Verification;
import com.digiwin.dap.middleware.omc.support.esign.service.EsignService;
import com.digiwin.dap.middleware.omc.support.esign.service.VerifyService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/esign"})
public class EsignController {
    private static final Logger logger = LoggerFactory.getLogger(EsignController.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private EsignService esignService;
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private OrderLogService orderLogService;
    @Autowired
    private OrderQueryService orderQueryService;

    @PostMapping(value={"/template"})
    public Map<String, Integer> getTemplateForms(@RequestBody TemplateId templateId) {
        return this.esignService.getTemplateForms(templateId);
    }

    @PostMapping(value={"/template/data"})
    public TemplateValue buildTemplateDoc(@RequestBody FinishDocUrl body) {
        OrderVO order = this.orderQueryService.findOrderByOrderCode(body.getOrderCode());
        Verification verify = this.verifyService.getVerify(this.iamService.getUserToken(order.getTenantId()));
        return this.esignService.buildTemplateFormValues(order, verify);
    }

    @PostMapping(value={"/sign/flow/data"})
    public SignFlow signFlowsData(@RequestBody FinishDocUrl body) {
        OrderVO order = this.orderQueryService.findOrderByOrderCode(body.getOrderCode());
        Verification verify = this.verifyService.getVerify(this.iamService.getUserToken(order.getTenantId()));
        return this.esignService.buildSignFlow(body.getDocFileKey(), verify, order.getSid().longValue());
    }

    @PostMapping(value={"/callback"})
    public Esign finishSignFlow(@RequestBody FinishDoc body) {
        try {
            this.orderLogService.esignCallbackLog(Long.parseLong(body.getBizNo()), body.toString());
        }
        catch (Exception e) {
            logger.error("\u3010Esign\u3011\u5408\u540c\u7b7e\u7f72\u56de\u8c03\u4fdd\u5b58\u65e5\u5fd7 {}", (Object)e.getMessage());
        }
        if (ActionEnum.SIGN_FLOW_FINISH.name().equals(body.getAction()) && body.getStatus() == 2) {
            body.getFinishDocUrlBeans().forEach(o -> this.esignService.downloadContractFile(o.getDownloadDocUrl(), Long.parseLong(body.getBizNo()), body.getFlowId().toString()));
        }
        return Esign.ok();
    }

    @GetMapping(value={"/upload"})
    public StdData upload(@RequestBody FinishDocUrl body) {
        return StdData.ok((Object)this.esignService.downloadContractFile(body.getDownloadDocUrl(), body.getOrderSid().longValue(), body.getFlowId()));
    }
}

