/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.esign.service.impl;

import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.order.ContractService;
import com.digiwin.dap.middleware.omc.support.esign.domain.SignFlow;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateValue;
import com.digiwin.dap.middleware.omc.support.esign.domain.Verification;
import com.digiwin.dap.middleware.omc.support.esign.service.EsignService;
import com.digiwin.dap.middleware.omc.support.esign.service.VerifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="esignContractService")
public class EsignContractServiceImpl
implements ContractService {
    private static final Logger logger = LoggerFactory.getLogger(EsignContractServiceImpl.class);
    @Autowired
    private EsignService esignService;
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private EnvProperties envProperties;

    @Async
    public void createContractAsync(OrderVO order, String userToken) {
        this.createContract(order, userToken);
    }

    public long createContract(OrderVO order, String userToken) {
        try {
            if (this.envProperties.isEsignOpen()) {
                Verification verify = this.verifyService.getVerify(userToken);
                TemplateValue templateValue = this.esignService.buildTemplateFormValues(order, verify);
                String fileKey = this.esignService.buildTemplateDoc(templateValue);
                SignFlow signFlow = this.esignService.buildSignFlow(fileKey, verify, order.getSid().longValue());
                this.esignService.signFlows(signFlow);
            }
        }
        catch (Exception e) {
            logger.error("\u3010Esign\u3011\u521b\u5efa\u5408\u540c", (Throwable)e);
        }
        return 0L;
    }
}

