/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.esign.service.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Contract;
import com.digiwin.dap.middleware.omc.mapper.ContractMapper;
import com.digiwin.dap.middleware.omc.repository.ContractRepository;
import com.digiwin.dap.middleware.omc.support.esign.domain.ContractEsign;
import com.digiwin.dap.middleware.omc.support.esign.domain.Esign;
import com.digiwin.dap.middleware.omc.support.esign.domain.Meta;
import com.digiwin.dap.middleware.omc.support.esign.domain.SignDoc;
import com.digiwin.dap.middleware.omc.support.esign.domain.SignDocDetail;
import com.digiwin.dap.middleware.omc.support.esign.domain.SignFlow;
import com.digiwin.dap.middleware.omc.support.esign.domain.SignPos;
import com.digiwin.dap.middleware.omc.support.esign.domain.Signer;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateDoc;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateForm;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateFormValue;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateId;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateInfo;
import com.digiwin.dap.middleware.omc.support.esign.domain.TemplateValue;
import com.digiwin.dap.middleware.omc.support.esign.domain.Verification;
import com.digiwin.dap.middleware.omc.support.esign.service.EsignService;
import com.digiwin.dap.middleware.omc.support.tsign.domain.DmcUploadResult;
import com.digiwin.dap.middleware.omc.support.tsign.service.DmcService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EsignServiceImpl
implements EsignService {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private DmcService dmcService;
    @Qualifier(value="esignRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractRepository contractRepository;

    private static List<TemplateFormValue> buildTemplateFormValue(ContractEsign contract, Map<String, Integer> templateForms) {
        BeanWrapperImpl src = new BeanWrapperImpl((Object)contract);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        ArrayList<TemplateFormValue> templateFormValues = new ArrayList<TemplateFormValue>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue;
            if (!templateForms.containsKey(pd.getName()) || (srcValue = src.getPropertyValue(pd.getName())) == null) continue;
            TemplateFormValue templateFormValue = new TemplateFormValue();
            templateFormValue.setFormId((Integer)templateForms.getOrDefault(pd.getName(), null));
            templateFormValue.setFormValue(srcValue.toString());
            templateFormValues.add(templateFormValue);
        }
        return templateFormValues;
    }

    public Map<String, Integer> getTemplateForms() {
        TemplateId templateId = new TemplateId();
        templateId.setTemplateId(this.contractMapper.findById("templateId"));
        return this.getTemplateForms(templateId);
    }

    public Map<String, Integer> getTemplateForms(TemplateId templateId) {
        String result = null;
        try {
            String json = objectMapper.writeValueAsString((Object)templateId);
            HttpEntity request = new HttpEntity((Object)json);
            String url = this.envProperties.getEsignUri() + "/esignpro/rest/template/api/getTemplateInfo";
            result = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            Esign esign = (Esign)JsonUtils.createObjectMapper().readValue(result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (esign != null && esign.getErrCode() == 0L) {
                return ((TemplateInfo)esign.getData()).getTemplate().getTemplateForms().stream().collect(Collectors.toMap(TemplateForm::getFormName, TemplateForm::getFormId));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_20004, new Object[]{templateId.getTemplateId()}, result);
    }

    public String buildTemplateDoc(TemplateValue templateValue) {
        String result = null;
        try {
            HttpEntity request = new HttpEntity((Object)templateValue);
            String url = this.envProperties.getEsignUri() + "/esignpro/rest/template/api/buildTemplateDoc";
            result = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            Esign esign = (Esign)JsonUtils.createObjectMapper().readValue(result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (esign != null && esign.getErrCode() == 0L) {
                return ((TemplateDoc)esign.getData()).getFileKey();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_20005, new Object[]{templateValue.getTemplateId()}, result);
    }

    public void signFlows(SignFlow signFlow) {
        String result = null;
        try {
            HttpEntity request = new HttpEntity((Object)signFlow);
            String url = this.envProperties.getEsignUri() + "/V1/signFlows/create";
            result = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            Esign esign = (Esign)JsonUtils.createObjectMapper().readValue(result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (esign != null && esign.getErrCode() == 0L) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_20006, new Object[]{signFlow.getBizNo()}, result);
    }

    public long downloadContractFile(String url, long orderSid, String flowId) {
        try {
            URI uri = new URI(url);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, null, byte[].class);
            DmcUploadResult dmcUploadResult = this.dmcService.uploadContract(orderSid, (InputStream)new ByteArrayInputStream((byte[])response.getBody()));
            Contract contract = new Contract();
            contract.setOrderSid(Long.valueOf(orderSid));
            contract.setFlowId(flowId);
            contract.setUploadFileId(dmcUploadResult.getFileId());
            contract.setUploadFileUrl(dmcUploadResult.getUrl());
            contract.setCreateDate(LocalDateTime.now());
            contract.setContractArea(this.envProperties.getCountry());
            return ((Contract)this.contractRepository.save((Object)contract)).getSid();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20007, new Object[]{orderSid}, e.getMessage());
        }
    }

    public TemplateValue buildTemplateFormValues(OrderVO order, Verification verify) {
        Map<String, String> metas = this.contractMapper.findByType(Integer.valueOf(2)).stream().collect(Collectors.toMap(Meta::getId, Meta::getValue));
        ContractEsign contractEsign = new ContractEsign();
        contractEsign.setOrderNo(order.getOrderCode());
        contractEsign.setSeller(metas.get("seller"));
        contractEsign.setSellerAddress(metas.get("sellerAddress"));
        contractEsign.setSellerName(metas.get("sellerName"));
        contractEsign.setSellerTelephone(metas.get("sellerTelephone"));
        contractEsign.setAccountName(metas.get("accountName"));
        contractEsign.setBankName(metas.get("bankName"));
        contractEsign.setBankAccount(metas.get("bankAccount"));
        if (verify != null) {
            contractEsign.setBuyer(verify.getAccountTenantName());
            contractEsign.setBuyerAddress(verify.getTenantAddress());
            contractEsign.setBuyerName(verify.getAccountName());
            contractEsign.setBuyerTelephone(verify.getAccountTelephone());
            contractEsign.setBuyMan(verify.getAccountTenantName());
        }
        OrderDetailVO orderDetail = order.getFirstOrderDetail();
        String quantity = orderDetail.getQuantity().toString();
        List items = orderDetail.getItems();
        int size = items.size();
        if (size > 0) {
            contractEsign.setNum1(Integer.valueOf(1));
            contractEsign.setItemName1(((OrderDetailItemVO)items.get(0)).getItemName());
            contractEsign.setQuantity1(quantity);
            contractEsign.setUnit1(((OrderDetailItemVO)items.get(0)).getUnit());
            contractEsign.setPrice1(((OrderDetailItemVO)items.get(0)).getUnitPrice().setScale(2, 6).toString());
            contractEsign.setPayPrice1(((OrderDetailItemVO)items.get(0)).getPayPrice().setScale(2, 6).toString());
            if (size > 1) {
                contractEsign.setNum2(Integer.valueOf(2));
                contractEsign.setItemName2(((OrderDetailItemVO)items.get(1)).getItemName());
                contractEsign.setQuantity2(quantity);
                contractEsign.setUnit2(((OrderDetailItemVO)items.get(1)).getUnit());
                contractEsign.setPrice2(((OrderDetailItemVO)items.get(1)).getUnitPrice().setScale(2, 6).toString());
                contractEsign.setPayPrice2(((OrderDetailItemVO)items.get(1)).getPayPrice().setScale(2, 6).toString());
                if (size > 2) {
                    contractEsign.setNum3(Integer.valueOf(3));
                    contractEsign.setItemName3(((OrderDetailItemVO)items.get(2)).getItemName());
                    contractEsign.setQuantity3(quantity);
                    contractEsign.setUnit3(((OrderDetailItemVO)items.get(2)).getUnit());
                    contractEsign.setPrice3(((OrderDetailItemVO)items.get(2)).getUnitPrice().setScale(2, 6).toString());
                    contractEsign.setPayPrice3(((OrderDetailItemVO)items.get(2)).getPayPrice().setScale(2, 6).toString());
                    if (size > 3) {
                        contractEsign.setNum4(Integer.valueOf(4));
                        contractEsign.setItemName4(((OrderDetailItemVO)items.get(3)).getItemName());
                        contractEsign.setQuantity4(quantity);
                        contractEsign.setUnit4(((OrderDetailItemVO)items.get(3)).getUnit());
                        contractEsign.setPrice4(((OrderDetailItemVO)items.get(3)).getUnitPrice().setScale(2, 6).toString());
                        contractEsign.setPayPrice4(((OrderDetailItemVO)items.get(3)).getPayPrice().setScale(2, 6).toString());
                    }
                }
            }
        }
        TemplateValue templateValue = new TemplateValue();
        templateValue.setTemplateId(this.contractMapper.findById("templateId"));
        templateValue.setTemplateFormValues(EsignServiceImpl.buildTemplateFormValue((ContractEsign)contractEsign, (Map)this.getTemplateForms()));
        return templateValue;
    }

    public SignFlow buildSignFlow(String fileKey, Verification verify, long orderSid) {
        SignFlow signFlow = new SignFlow();
        Map<String, String> metas = this.contractMapper.findByType(Integer.valueOf(3)).stream().collect(Collectors.toMap(Meta::getId, Meta::getValue));
        signFlow.setBizNo(String.valueOf(orderSid));
        signFlow.setCallbackUrl(this.envProperties.getNotifyUri() + "/api/esign/callback");
        signFlow.setComments(metas.get("subject"));
        signFlow.setInitiatorAccountId(metas.get("initiatorAccountId"));
        signFlow.setRedirectUrl(null);
        signFlow.setSignSceneNo(metas.get("signSceneNo"));
        signFlow.setSignValidity(LocalDateTime.now().plusYears(1L));
        signFlow.setSubject(metas.get("subject"));
        SignDoc signDoc = new SignDoc();
        signDoc.setDocFilekey(fileKey);
        signDoc.setDocName(metas.get("subject"));
        signDoc.setDocOrder(Integer.valueOf(1));
        signFlow.setSignDocs(Collections.singletonList(signDoc));
        ArrayList<Signer> signers = new ArrayList<Signer>();
        Signer seller = new Signer();
        seller.setSignOrder(Integer.valueOf(1));
        seller.setAccountType(Integer.valueOf(1));
        seller.setAccountId(metas.get("initiatorAccountId"));
        seller.setAuthorizationOrganizeId(metas.get("initiatorOrganizeId"));
        seller.setAutoSign(Boolean.valueOf(true));
        SignDocDetail sellerDetail = new SignDocDetail();
        sellerDetail.setDocFilekey(fileKey);
        try {
            String sellerSignPosJson = metas.get("sellerSignPos");
            SignPos sellerSignPos = (SignPos)objectMapper.readValue(sellerSignPosJson, SignPos.class);
            sellerDetail.setSignPos(Collections.singletonList(sellerSignPos));
            seller.setSignDocDetails(Collections.singletonList(sellerDetail));
            signers.add(seller);
        }
        catch (Exception sellerSignPosJson) {
            // empty catch block
        }
        if (verify != null && verify.isPassed()) {
            Signer buyer = new Signer();
            buyer.setSignOrder(Integer.valueOf(2));
            buyer.setAccountType(Integer.valueOf(2));
            buyer.setAccountId(verify.getAccountId());
            buyer.setAuthorizationOrganizeId(verify.getAccountTenantId());
            buyer.setAutoSign(Boolean.valueOf(false));
            SignDocDetail buyerDetail = new SignDocDetail();
            buyerDetail.setDocFilekey(fileKey);
            SignPos buyerSignPos = new SignPos();
            buyerSignPos.setSignType(Integer.valueOf(0));
            buyerDetail.setSignPos(Collections.singletonList(buyerSignPos));
            buyer.setSignDocDetails(Collections.singletonList(buyerDetail));
            signers.add(buyer);
        }
        signFlow.setSigners(signers);
        return signFlow;
    }
}

