/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.esign.service.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.support.esign.domain.Verification;
import com.digiwin.dap.middleware.omc.support.esign.service.VerifyService;
import com.digiwin.dap.middleware.omc.support.tsign.domain.ContractUserInfo;
import com.digiwin.dap.middleware.omc.support.tsign.domain.TenantCertification;
import com.digiwin.dap.middleware.omc.support.tsign.domain.UserCertification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class VerifyServiceImpl
implements VerifyService {
    private static final Logger logger = LoggerFactory.getLogger(VerifyServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;

    public Verification getVerify(String userToken) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/authentication/info";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, ContractUserInfo.class, new Object[0]);
            return this.getVerify((ContractUserInfo)response.getBody());
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u3011\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f{}", (Object)url);
            return null;
        }
    }

    private Verification getVerify(ContractUserInfo verify) {
        Verification verification = null;
        if (verify != null) {
            TenantCertification tenant = verify.getTenantCertification();
            UserCertification user = verify.getUserCertification();
            if (user != null || tenant != null) {
                verification = new Verification();
                if (user != null) {
                    if (user.isPassed()) {
                        verification.setAccountId(user.getAccountId());
                    }
                    verification.setAccountName(user.getName());
                    verification.setAccountTelephone(user.getMobile());
                }
                if (tenant != null) {
                    if (tenant.isPassed()) {
                        verification.setAccountTenantId(tenant.getAccountId());
                    }
                    verification.setAccountTenantName(tenant.getName());
                    verification.setTenantAddress(tenant.getAddress());
                }
            }
        }
        return verification;
    }
}

