/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceStateEnum;
import com.digiwin.dap.middleware.omc.domain.CustomAttributeVO;
import com.digiwin.dap.middleware.omc.domain.excel.CloudDeviceExcelVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderDetailService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CloudDeviceImportListener
extends AnalysisEventListener<CloudDeviceExcelVO> {
    Logger logger = LoggerFactory.getLogger(CloudDeviceImportListener.class);
    private final OrderCloudDeviceRepository orderCloudDeviceRepository;
    private final OrderQueryService orderQueryService;
    private final OrderCloudDeviceMapper orderCloudDeviceMapper;
    private final PreOrderDetailService preOrderDetailService;
    private List<CloudDeviceExcelVO> importSuccessResults = new ArrayList();
    private List<CloudDeviceExcelVO> errorResults = new ArrayList();

    public CloudDeviceImportListener(OrderCloudDeviceRepository orderCloudDeviceRepository, OrderQueryService orderQueryService, OrderCloudDeviceMapper orderCloudDeviceMapper, PreOrderDetailService preOrderDetailService) {
        this.orderCloudDeviceRepository = orderCloudDeviceRepository;
        this.orderQueryService = orderQueryService;
        this.orderCloudDeviceMapper = orderCloudDeviceMapper;
        this.preOrderDetailService = preOrderDetailService;
    }

    public void invoke(CloudDeviceExcelVO data, AnalysisContext context) {
        if (!context.readRowHolder().getCellMap().isEmpty()) {
            OrderCloudDevice device = this.orderCloudDeviceRepository.findByCode(data.getCode());
            if (this.validateFailed(data, device)) {
                this.errorResults.add(data);
                return;
            }
            device.setDbName(data.getDbName());
            device.setDbUsername(data.getDbUsername());
            device.setDbPassword(AES.encrypt((String)data.getDbPassword(), (String)KeyConstant.WECHAT_UNION_ID));
            device.setDbUrl(data.getDbUrl());
            device.setState(CloudDeviceStateEnum.COMPLETE.getValue());
            EntityUtils.setModifyFields((BaseEntity)device);
            this.orderCloudDeviceRepository.save((Object)device);
            this.importSuccessResults.add(data);
        }
    }

    private boolean validateFailed(CloudDeviceExcelVO data, OrderCloudDevice device) {
        if (ObjectUtils.isEmpty((Object)data.getDbName())) {
            data.appendError("\u6570\u636e\u5e93\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)data.getDbUsername())) {
            data.appendError("\u6570\u636e\u5e93\u8d26\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)data.getDbPassword())) {
            data.appendError("\u6570\u636e\u5e93\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)data.getDbUrl())) {
            data.appendError("\u6570\u636e\u5e93url\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (device == null) {
            data.appendError("\u8d44\u6e90\u7f16\u53f7\u9519\u8bef");
        } else {
            if (CloudDeviceStateEnum.EXPIRED.getValue().equals(device.getState())) {
                data.appendError("\u4e91\u8d44\u6e90\u5df2\u5230\u671f\u505c\u7528\uff0c\u4e0d\u53ef\u53d8\u66f4");
            }
            if (!this.isRDS(device)) {
                data.appendError("\u8d44\u6e90\u5546\u54c1\u975e\u6570\u636e\u5e93\uff0c\u4e0d\u53ef\u53d8\u66f4");
            }
        }
        return StringUtils.hasLength((String)data.getError());
    }

    private boolean isRDS(OrderCloudDevice device) {
        Long strategySid = 0L;
        try {
            List preOrderDetails = this.preOrderDetailService.getPreOrderDetails(device.getOrderSid());
            if (CollectionUtils.isEmpty((Collection)preOrderDetails)) {
                OrderVO orderVO = this.orderQueryService.getOrderBySid(device.getOrderSid().longValue());
                strategySid = orderVO.getFirstOrderDetail().getStrategySid();
            } else {
                strategySid = preOrderDetails.stream().filter(o -> Boolean.TRUE.equals(o.getMainStrategy())).findAny().orElse(new PreOrderDetailVO()).getStrategySid();
            }
            String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValues(strategySid.longValue());
            if (StringUtils.hasLength((String)customAttributeStr)) {
                List customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(customAttributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                for (CustomAttributeVO attribute : customAttributeVOS) {
                    if (!"kind".equalsIgnoreCase(attribute.getId()) || !"RDS".equalsIgnoreCase(attribute.getValue())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<CloudDeviceExcelVO> getImportSuccessResults() {
        return this.importSuccessResults;
    }

    public void setImportSuccessResults(List<CloudDeviceExcelVO> importSuccessResults) {
        this.importSuccessResults = importSuccessResults;
    }

    public List<CloudDeviceExcelVO> getErrorResults() {
        return this.errorResults;
    }

    public void setErrorResults(List<CloudDeviceExcelVO> errorResults) {
        this.errorResults = errorResults;
    }
}

