/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.ImportExcelResultVO;
import com.digiwin.dap.middleware.omc.domain.excel.CloudDeviceExcelVO;
import com.digiwin.dap.middleware.omc.domain.excel.CloudDeviceExcelVO2;
import com.digiwin.dap.middleware.omc.domain.excel.PreOrderExcel;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormContentVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.IntellyRelationResultVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderDetailService;
import com.digiwin.dap.middleware.omc.support.excel.CloudDeviceImportListener;
import com.digiwin.dap.middleware.omc.support.excel.ExcelService;
import com.digiwin.dap.middleware.omc.support.remote.DmcSdkService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExcelServiceImpl
implements ExcelService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private PreOrderDetailService preOrderDetailService;
    @Autowired
    private IamService iamService;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;
    @Autowired
    private DMC dmcClient;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private DmcSdkService dmcSdkService;

    public List<List<String>> getHeadList(List<CustomFormContentVO> customFormContentVOs) {
        ArrayList<String> headTitle0 = new ArrayList<String>();
        ArrayList<String> headTitle1 = new ArrayList<String>();
        ArrayList<String> headTitle2 = new ArrayList<String>();
        ArrayList<String> headTitle3 = new ArrayList<String>();
        ArrayList<String> headTitle4 = new ArrayList<String>();
        ArrayList<String> headTitle5 = new ArrayList<String>();
        ArrayList<String> headTitle6 = new ArrayList<String>();
        ArrayList<String> headTitle7 = new ArrayList<String>();
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
            headTitle0.add("\u79df\u6236\u540d\u7a31");
            headTitle1.add("\u79df\u6237id");
            headTitle2.add("\u8cfc\u7269\u8eca\u55ae\u865f");
            headTitle3.add("\u8a02\u55ae\u865f");
            headTitle4.add("\u8a02\u55ae\u65e5\u671f");
            headTitle5.add("\u7522\u54c1\u540d\u7a31");
            headTitle6.add("\u65b9\u6848\u540d\u7a31");
            headTitle7.add("\u6578\u91cf");
        } else {
            headTitle0.add("\u79df\u6237\u540d\u79f0");
            headTitle1.add("\u79df\u6237id");
            headTitle2.add("\u8d2d\u7269\u8f66\u5355\u53f7");
            headTitle3.add("\u8ba2\u5355\u53f7");
            headTitle4.add("\u8ba2\u5355\u65e5\u671f");
            headTitle5.add("\u4ea7\u54c1\u540d\u79f0");
            headTitle6.add("\u65b9\u6848\u540d\u79f0");
            headTitle7.add("\u6570\u91cf");
        }
        ArrayList<List<String>> qualityNameAll = new ArrayList<List<String>>();
        qualityNameAll.add(headTitle0);
        qualityNameAll.add(headTitle1);
        qualityNameAll.add(headTitle2);
        qualityNameAll.add(headTitle3);
        qualityNameAll.add(headTitle4);
        qualityNameAll.add(headTitle5);
        qualityNameAll.add(headTitle6);
        qualityNameAll.add(headTitle7);
        customFormContentVOs.forEach(o -> {
            ArrayList<String> qualityNames = new ArrayList<String>();
            qualityNames.add(o.getTitle());
            qualityNameAll.add(qualityNames);
        });
        return qualityNameAll;
    }

    public List<List<Object>> getWeekList(List<CustomFormOrderVO> customFormOrderList) {
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>();
        customFormOrderList.forEach(o -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(o.getTenantName());
            list.add(o.getTenantId());
            list.add(o.getCartCode());
            list.add(o.getOrderCode());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            list.add(o.getCreateDate() == null ? null : df.format(o.getCreateDate()));
            list.add(o.getGoodsName());
            list.add(o.getStrategyName());
            list.add(o.getQuantity());
            List customFormContentVOS = o.getCustomFormContentVO();
            customFormContentVOS.forEach(j -> list.add(j.getValue()));
            lists.add(list);
        });
        return lists;
    }

    public void exportPreOrders(String orderBy, PreOrderDTO preOrderDTO, HttpServletResponse response) throws Exception {
        List preOrders = this.preOrderMapper.getExportPreOrder(orderBy, preOrderDTO);
        ArrayList preOrderExcels = new ArrayList();
        Map<Long, List<PreOrderDetailVO>> detailMap = this.preOrderDetailService.batchGetPreOrderDetails(preOrders.stream().map(PreOrderVO::getSid).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(PreOrderDetailVO::getOrderSid));
        preOrders.forEach(o -> {
            o.setDetails((List)detailMap.get(o.getSid()));
            preOrderExcels.add(PreOrderExcel.generate((PreOrderVO)o));
        });
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? this.getClass().getResourceAsStream("/static/templates/ManualAuth_export_template_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/ManualAuth_export_template_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = URLEncoder.encode(String.format("ManualAuth_%s.xlsx", localTime), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PreOrderExcel.class).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(preOrderExcels);
    }

    public ShareInfo exportCloudDevice(CloudDeviceConditionVO condition) throws Exception {
        condition.boxConditions();
        List orderCloudDeviceVOS = this.orderCloudDeviceMapper.getDeviceClouds(condition, condition.getPageNum().intValue(), condition.getPageSize().intValue(), condition.getOrderBy());
        this.orderCloudDeviceService.populateCustomAttributes(orderCloudDeviceVOS);
        this.populateExportFields(orderCloudDeviceVOS);
        orderCloudDeviceVOS.sort(Comparator.comparing(OrderCloudDeviceVO::getTenantId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(OrderCloudDeviceVO::getCloud, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(OrderCloudDeviceVO::getApplicantDate, Comparator.nullsLast(Comparator.reverseOrder())));
        List excelVOs = orderCloudDeviceVOS.stream().map(CloudDeviceExcelVO2::generate).collect(Collectors.toList());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = URLEncoder.encode(String.format("CloudDevice_%s.xlsx", localTime), "UTF-8");
        File file = Files.createTempFile(fileName, "xlsx", new FileAttribute[0]).toFile();
        InputStream inputStream = new DefaultResourceLoader().getResource("classpath:/static/templates/cloud_device_export_template.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(excelVOs, writeSheet);
        excelWriter.finish();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileName);
        fileInfo.setExtension("xlsx");
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] bytes = new byte[input.available()];
            int read = input.read(bytes);
            if (read <= 0) {
                logger.error("nothing to read");
            }
            ShareInfo shareInfo = this.dmcSdkService.getShare(bytes, fileInfo);
            return shareInfo;
        }
    }

    private void populateExportFields(List<OrderCloudDeviceVO> orderCloudDeviceVOS) {
        List tenantIds = orderCloudDeviceVOS.stream().map(OrderCloudDeviceVO::getTenantId).distinct().collect(Collectors.toList());
        List relations = this.iamService.getIntellyRelation(Collections.singletonList("ISV"), tenantIds);
        List tenantSimples = this.iamService.getTenantSimples(tenantIds);
        Map<String, List<IntellyRelationResultVO>> relationMap = relations.stream().collect(Collectors.groupingBy(IntellyRelationResultVO::getId));
        Map tenantMap = tenantSimples.stream().collect(Collectors.toMap(CommonVO::getId, Function.identity(), (existing, replacement) -> existing));
        for (OrderCloudDeviceVO device : orderCloudDeviceVOS) {
            CommonVO tenant;
            String tenantId = device.getTenantId();
            List<IntellyRelationResultVO> relationList = relationMap.get(tenantId);
            if (!CollectionUtils.isEmpty(relationList)) {
                device.setGroupId(relationList.get(0).getGroupId());
                device.setGroupName(relationList.get(0).getGroupName());
                device.setFormId(relationList.stream().map(IntellyRelationResultVO::getFormId).collect(Collectors.joining(",")));
                device.setFormName(relationList.stream().map(IntellyRelationResultVO::getFormName).collect(Collectors.joining(",")));
            }
            if ((tenant = (CommonVO)tenantMap.get(tenantId)) == null) continue;
            device.setTestTenant(tenant.getTestTenant());
        }
    }

    public ImportExcelResultVO importCloudDevice(String fileId) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(this.dmcClient.download(fileId));
            CloudDeviceImportListener listener = new CloudDeviceImportListener(this.orderCloudDeviceRepository, this.orderQueryService, this.orderCloudDeviceMapper, this.preOrderDetailService);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)fis, CloudDeviceExcelVO.class, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(1))).doRead();
            List importSuccessList = listener.getImportSuccessResults();
            List errorList = listener.getErrorResults();
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setSuccessCount(Integer.valueOf(importSuccessList.size()));
            importExcelResultVO.setErrorCount(Integer.valueOf(errorList.size()));
            if (!errorList.isEmpty()) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = String.format("error_%s.xlsx", localTime);
                File file = Files.createTempFile(fileName, "xlsx", new FileAttribute[0]).toFile();
                InputStream inputStream = new DefaultResourceLoader().getResource("classpath:/static/templates/cloud_device_export.xlsx").getInputStream();
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                excelWriter.write(errorList, writeSheet);
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] bytes = new byte[((InputStream)input).available()];
                    int read = ((InputStream)input).read(bytes);
                    if (read <= 0) {
                        logger.error("nothing to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcSdkService.getShareFileId(bytes, fileInfo));
                    importExcelResultVO.setErrorFileName(fileName);
                }
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }
}

