/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.SourceIdEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderInitializeStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderDetailAuthorizationEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.OrderInitUpdate;
import com.digiwin.dap.middleware.omc.domain.changelog.ModifiedInfoDTO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.remote.CacAuth;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.ProductTypeVO;
import com.digiwin.dap.middleware.omc.domain.remote.TenantAuthNoticeInfoVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderRelateCodeVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderReportVO;
import com.digiwin.dap.middleware.omc.domain.request.GoodsAuthDO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderDetailMapper;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.LmcService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger logger = LoggerFactory.getLogger(AuthServiceImpl.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private IamService iamService;
    @Autowired
    private CacService cacService;
    @Autowired
    private MailService mailService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private PreOrderDetailMapper preOrderDetailMapper;
    @Autowired
    private LmcService lmcService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ProducerService producerService;

    public ResponseResult addAuthorizationDefault(OrderVO orderVO) {
        String userToken = this.iamService.getUserToken(orderVO.getTenantId());
        AppAuthContextHolder.getContext().setAuthoredUser(this.iamService.getUserInfo(userToken));
        return this.authorization(orderVO, userToken);
    }

    public ResponseResult addAuthorization(OrderVO orderVO) {
        return this.authorization(orderVO, UserUtils.getToken());
    }

    public ResponseResult authorization(OrderVO orderVO, String userToken) {
        try {
            if (ObjectUtils.isEmpty((Object)userToken)) {
                userToken = this.iamService.getUserToken(orderVO.getTenantId());
                AppAuthContextHolder.getContext().setAuthoredUser(this.iamService.getUserInfo(userToken));
            }
            if (null == orderVO.getAuthorizationDate()) {
                orderVO.setAuthorizationDate(LocalDateTime.now());
            }
            return this.addAuthorization(orderVO, userToken);
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u5931\u8d25", (Throwable)e);
            return new ResponseResult(false, "\u6388\u6743\u5931\u8d25");
        }
    }

    public ResponseResult authorization(PreOrderVO preOrderVO, String userToken) {
        PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
        if (PreOrderDetailAuthorizationEnum.VOIDED.getValue().equals(dtl.getAuthorization())) {
            return new ResponseResult(false, "\u5df2\u4f5c\u5e9f");
        }
        if (null == dtl.getEffectiveDateTime()) {
            dtl.setEffectiveDateTime(LocalDateTime.now());
        }
        return this.addAuthorization(preOrderVO, userToken);
    }

    private ResponseResult addAuthorization(PreOrderVO preOrderVO, String userToken) {
        PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
        if (PreOrderDetailAuthorizationEnum.OPENED.getValue().equals(dtl.getAuthorization())) {
            return new ResponseResult(true, "\u5df2\u7ecf\u6388\u6743");
        }
        AuthorizationVO authorizationVO = null;
        if (GoodsCategoryEnum.isApp((String)dtl.getCategoryId())) {
            authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(preOrderVO.getTenantId(), dtl.getGoodsCode());
        }
        ResponseResult responseResult = this.iamService.purchaseApp(preOrderVO, userToken);
        AuthorizationVO oldAuthVO = null;
        if (GoodsCategoryEnum.isApp((String)dtl.getCategoryId())) {
            oldAuthVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(preOrderVO.getTenantId(), dtl.getGoodsCode());
        }
        if (responseResult.isSuccess()) {
            responseResult = this.cacService.authorization(preOrderVO);
        }
        if (responseResult.isSuccess()) {
            boolean sendEmail;
            boolean bl = sendEmail = PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue().equals(preOrderVO.getOrderType()) && Boolean.TRUE.equals(preOrderVO.getSendEmail());
            if (sendEmail) {
                this.mailService.sendGoodsToEnableEmail(preOrderVO);
            }
            this.preOrderDetailMapper.updateOrderAuthorization(preOrderVO.getSid());
            if (GoodsCategoryEnum.isApp((String)dtl.getCategoryId())) {
                this.appAuthChangeLogs(preOrderVO, oldAuthVO);
            }
        } else {
            this.mailService.sendEmailAuthFail(preOrderVO, responseResult.getMessage());
        }
        responseResult.setAuthInfo(authorizationVO);
        return responseResult;
    }

    private ResponseResult addAuthorization(OrderVO orderVO, String userToken) {
        if (null != orderVO.getAuthorization() && orderVO.getAuthorization().booleanValue()) {
            return new ResponseResult(true, "\u5df2\u7ecf\u6388\u6743");
        }
        AuthorizationVO authorizationVO = null;
        if (GoodsCategoryEnum.isApp((String)orderVO.getFirstOrderDetail().getCategoryId())) {
            authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(orderVO.getTenantId(), orderVO.getFirstOrderDetail().getGoodsCode());
        }
        ResponseResult responseResult = this.iamService.purchaseApp(orderVO, userToken);
        boolean shouldAuthUser = authorizationVO == null && OrderSourceEnum.DigiwinCloud.name().equals(orderVO.getOrderSource()) && OrderTypeEnum.APP_NEW.getValue() == orderVO.getOrderType().intValue() && GoodsCategoryEnum.isApp((String)orderVO.getCategoryId());
        orderVO.setShouldAuthUser(Boolean.valueOf(shouldAuthUser));
        logger.info("\u51c6\u5907\u6388\u6743\uff0c\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)orderVO));
        if (responseResult.isSuccess()) {
            responseResult = this.cacService.authorization(orderVO);
        }
        responseResult.setAuthInfo(authorizationVO);
        if (responseResult.isSuccess()) {
            this.orderUpdateMapper.updateOrderAuthorization(orderVO.getSid().longValue());
            this.updateExpiredDateTime(orderVO);
        } else {
            this.mailService.sendEmailAuthFail(orderVO.getSid().longValue(), responseResult.getMessage());
        }
        return responseResult;
    }

    public ResponseResult initGoods(OrderVO orderVO, AuthorizationVO oldAuthInfo) {
        try {
            if (orderVO.getInitialize() != null && orderVO.getInitialize() == 1) {
                return ResponseResult.ok((String)"\u5df2\u7ecf\u521d\u59cb\u5316");
            }
            if (ObjectUtil.isEmpty((Object)UserUtils.getToken())) {
                AppAuthContextHolder.getContext().setAuthoredUser(this.iamService.getUserInfo(this.iamService.getUserToken(orderVO.getTenantId())));
            }
            return this.initializeGoods(orderVO, oldAuthInfo);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            return ResponseResult.fail((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public ResponseResult initGoods(PreOrderVO orderVO, AuthorizationVO oldAuthInfo) {
        try {
            return this.initializeGoods(orderVO, oldAuthInfo);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            return ResponseResult.fail((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public ResponseResult initGoods(GoodsAuthDO goodsAuthDO, AuthorizationVO oldAuthInfo) {
        try {
            Goods goods = this.goodsMapper.findGoodsByCode(goodsAuthDO.getAppId());
            if (goods == null) {
                return ResponseResult.fail((String)String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", goodsAuthDO.getAppId()));
            }
            if (goods.getNeedInit().booleanValue()) {
                if (GoodsCategoryEnum.needInit((String)goods.getCategoryId())) {
                    AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(goodsAuthDO.getTenantId(), goodsAuthDO.getAppId());
                    if (oldAuthInfo == null) {
                        oldAuthInfo = goodsAuthDO.getValidateOldAuth() != false ? goodsAuthDO.getOldAuthInfo() : authorizationVO;
                    }
                    if (this.isInitialize(Boolean.valueOf(false), null, oldAuthInfo)) {
                        String totalUsage = null != authorizationVO ? String.valueOf(authorizationVO.getTotalUsage()) : goodsAuthDO.getUserNumber();
                        String totalUserCount = null != authorizationVO ? String.valueOf(authorizationVO.getTotalUserCount()) : goodsAuthDO.getUserNumber();
                        String remainingUsage = null != authorizationVO ? String.valueOf(authorizationVO.getRemainingUsage()) : goodsAuthDO.getUserNumber();
                        TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO = new TenantAuthNoticeInfoVO(0L, null, OrderInitUpdate.OrderType.API, goodsAuthDO.getTenantId(), goodsAuthDO.getTenantName(), goodsAuthDO.getTenantSid(), goodsAuthDO.getCustomerServiceCode(), goodsAuthDO.getPotentialCustomerId(), goodsAuthDO.getAppId(), Long.valueOf(goods.getId()), goodsAuthDO.getStrategyCode(), oldAuthInfo.getExpiredTime(), goodsAuthDO.getEffectiveDateTime(), goodsAuthDO.getExpiredDateTime(), "", totalUserCount, totalUsage, remainingUsage, goodsAuthDO.getSourceId());
                        return this.appRenew(tenantAuthNoticeInfoVO);
                    }
                }
            } else if (!GoodsCategoryEnum.isService((String)goods.getCategoryId())) {
                logger.info(String.format("\u5e94\u7528[%s]\u4e0d\u9700\u521d\u59cb\u5316", goodsAuthDO.getAppId()));
                return ResponseResult.ok((String)String.format("\u5e94\u7528[%s]\u4e0d\u9700\u521d\u59cb\u5316", goodsAuthDO.getAppId()));
            }
            this.cacService.setGoodsStrategy(goods, goodsAuthDO.getStrategyCode(), goodsAuthDO.getUserNumber(), goodsAuthDO.getEffectiveDateTime(), goodsAuthDO.getExpiredDateTime(), null);
            CacAuth cacAuth = new CacAuth();
            cacAuth.getAuthorizations().add(goods);
            cacAuth.setTenantSid(goodsAuthDO.getTenantSid());
            cacAuth.setTenantId(goodsAuthDO.getTenantId());
            cacAuth.setTenantName(goodsAuthDO.getTenantName());
            cacAuth.setUserIds(goodsAuthDO.getUserIds());
            cacAuth.setUserNames(goodsAuthDO.getUserNames());
            cacAuth.setPotentialCustomerId(goodsAuthDO.getPotentialCustomerId());
            cacAuth.setCustomerServiceCode(goodsAuthDO.getCustomerServiceCode());
            cacAuth.setSourceId(goodsAuthDO.getSourceId());
            AuthorizationResultVO authorizationResultVO = this.cacService.queryAuthorizationByTenantAndApp(goodsAuthDO.getTenantId(), goods.getCode());
            goods.setEffectiveTime(authorizationResultVO.getEffectiveTime());
            goods.setExpiredTime(authorizationResultVO.getExpiredTime());
            return this.appNew(0L, OrderInitUpdate.OrderType.API, goodsAuthDO.getTenantSid(), goodsAuthDO.getTenantId(), goods.getCode(), goods.getCategoryId(), goods.getBackUri(), cacAuth);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            return ResponseResult.fail((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public void renewNotice(OrderVO orderVO) {
        try {
            AuthorizationVO authorizationVO;
            OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
            if ((GoodsCategoryEnum.APP.name().equalsIgnoreCase(orderDetailVO.getCategoryId()) || GoodsCategoryEnum.PLATFORM.name().equals(orderDetailVO.getCategoryId())) && null != (authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(orderVO.getTenantId(), orderDetailVO.getGoodsCode())) && (1 == authorizationVO.getInitialize() || 3 == authorizationVO.getInitialize())) {
                logger.info("\u3010\u7eed\u7ea6\u901a\u77e5\u3011:\u79df\u6237{}\u5df2\u7ecf\u521d\u59cb\u5316\u5e94\u7528{}", (Object)orderVO.getTenantId(), (Object)orderDetailVO.getGoodsCode());
                String totalUsage = String.valueOf(authorizationVO.getTotalUsage());
                String totalUserCount = String.valueOf(authorizationVO.getTotalUserCount());
                String remainingUsage = String.valueOf(authorizationVO.getRemainingUsage());
                TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO = new TenantAuthNoticeInfoVO(orderVO.getSid().longValue(), orderVO.getOrderCode(), OrderInitUpdate.OrderType.ORDER, orderVO.getTenantId(), orderVO.getTenantName(), orderVO.getTenantSid(), orderVO.getCustomerId(), orderVO.getPotentialCustomerId(), orderDetailVO.getGoodsCode(), orderDetailVO.getGoodsSid(), orderDetailVO.getStrategyCode(), authorizationVO.getExpiredTime(), orderVO.getAuthorizationDate(), authorizationVO.getExpiredTime(), "", totalUserCount, totalUsage, remainingUsage, SourceIdEnum.OrderPayment.name());
                this.appRenew(tenantAuthNoticeInfoVO);
            }
        }
        catch (Exception e) {
            logger.error("\u6392\u7a0b\u542f\u7528\u901a\u77e5\u5931\u8d25");
        }
    }

    public ResponseResult authAndNoticeAndPlatform(GoodsAuthDO goodsAuthDO) {
        logger.info("1.API\u6ce8\u518c\u5e94\u7528{}\u6388\u6743\u5f00\u59cb\uff0c\u6388\u6743\u4fe1\u606f:{}", (Object)goodsAuthDO.getAppId(), (Object)JsonUtils.writeValue((Object)goodsAuthDO));
        ResponseResult responseResult = new ResponseResult(true);
        if (goodsAuthDO.getAction() != 2 && (responseResult = this.iamService.purchaseApp(goodsAuthDO.getAppId(), this.iamService.getUserToken(goodsAuthDO.getTenantId()))).isSuccess()) {
            responseResult = this.cacService.purchaseAuth(goodsAuthDO);
        }
        if (null != responseResult && Boolean.TRUE.equals(responseResult.isSuccess()) && 1 != goodsAuthDO.getAction()) {
            responseResult = this.initGoods(goodsAuthDO, responseResult.getAuthInfo());
        }
        return responseResult;
    }

    private ResponseResult initializeGoods(OrderVO orderVO, AuthorizationVO oldAuthInfo) {
        OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
        Goods goods = this.goodsMapper.findGoodsBySid(orderVO.getFirstOrderDetail().getGoodsSid().longValue());
        if (goods == null) {
            return ResponseResult.fail((String)String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", orderVO.getFirstOrderDetail().getGoodsCode()));
        }
        LocalDateTime expiredDateTime = null;
        if (goods.getNeedInit().booleanValue()) {
            if (GoodsCategoryEnum.needInit((String)orderVO.getCategoryId())) {
                AuthorizationVO authInfo = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(orderVO.getTenantId(), orderDetailVO.getGoodsCode());
                LocalDateTime localDateTime = expiredDateTime = null == authInfo ? null : authInfo.getExpiredTime();
                if (oldAuthInfo == null) {
                    oldAuthInfo = authInfo;
                }
                if (this.isInitialize(orderVO.getRetryInit(), orderVO.getOrderCode(), oldAuthInfo)) {
                    String totalUsage = String.valueOf(authInfo.getTotalUsage());
                    String totalUserCount = String.valueOf(authInfo.getTotalUserCount());
                    String remainingUsage = String.valueOf(authInfo.getRemainingUsage());
                    String strategyCode = ObjectUtils.isEmpty((Object)orderDetailVO.getStrategySid()) || 0L == orderDetailVO.getStrategySid() ? orderDetailVO.getStrategyCode() : String.valueOf(orderDetailVO.getStrategySid());
                    TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO = new TenantAuthNoticeInfoVO(orderVO.getSid().longValue(), orderVO.getOrderCode(), OrderInitUpdate.OrderType.ORDER, orderVO.getTenantId(), orderVO.getTenantName(), orderVO.getTenantSid(), orderVO.getCustomerId(), orderVO.getPotentialCustomerId(), orderDetailVO.getGoodsCode(), orderDetailVO.getGoodsSid(), strategyCode, oldAuthInfo.getExpiredTime(), orderVO.getAuthorizationDate(), authInfo.getExpiredTime(), "", totalUserCount, totalUsage, remainingUsage, SourceIdEnum.OrderPayment.name());
                    if (Boolean.TRUE.equals(orderVO.getRetryInit())) {
                        tenantAuthNoticeInfoVO.setInitialize(orderVO.getInitialize());
                    }
                    return this.appRenew(tenantAuthNoticeInfoVO);
                }
            }
        } else if (!GoodsCategoryEnum.isService((String)goods.getCategoryId())) {
            return ResponseResult.fail((String)String.format("\u5e94\u7528[%s]\u4e0d\u9700\u521d\u59cb\u5316", orderDetailVO.getGoodsCode()));
        }
        goods.setExpiredTime(expiredDateTime);
        this.cacService.setGoodsStrategy(orderVO, goods);
        CacAuth cacAuth = new CacAuth();
        cacAuth.getAuthorizations().add(goods);
        cacAuth.setOrderCode(orderVO.getOrderCode());
        cacAuth.setTenantSid(orderVO.getTenantSid());
        cacAuth.setTenantId(orderVO.getTenantId());
        cacAuth.setTenantName(orderVO.getTenantName());
        cacAuth.setCustomerServiceCode(orderVO.getCustomerId());
        cacAuth.setUserId(orderVO.getUserId());
        cacAuth.setUserName(orderVO.getUserName());
        cacAuth.setSourceId(SourceIdEnum.OrderPayment.name());
        cacAuth.setCreateDate(orderVO.getCreateDate());
        cacAuth.setPayPrice(null == orderVO.getBnpl() ? orderVO.getPayPrice() : orderVO.getPayPrice().multiply(BigDecimal.valueOf(orderVO.getBnpl().getTotalCount().intValue())));
        cacAuth.setCredentialFileId(orderVO.getCredentialFileId());
        cacAuth.setOrderStatus(orderVO.getOrderStatus());
        cacAuth.setPurchaseUserId(orderVO.getUserId());
        cacAuth.setPurchaseUserName(orderVO.getUserName());
        cacAuth.setOrderSource(orderVO.getOrderSource());
        cacAuth.setBpnl(Boolean.valueOf(null != orderVO.getBnpl()));
        cacAuth.setCloudDevices(orderVO.getCloudDevices());
        cacAuth.setComment(orderVO.getComment());
        return this.appNew(orderVO.getSid().longValue(), OrderInitUpdate.OrderType.ORDER, orderVO.getTenantSid(), orderVO.getTenantId(), goods.getCode(), goods.getCategoryId(), goods.getBackUri(), cacAuth);
    }

    private ResponseResult initializeGoods(PreOrderVO preOrderVO, AuthorizationVO oldAuthInfo) {
        ResponseResult checkStrategyResult;
        PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
        String sourceId = PreOrderTypeEnum.APP_CHANGES.getValue().equals(preOrderVO.getOrderType()) ? SourceIdEnum.ApplicationChanges.name() : (PreOrderSourceEnum.SaaSShipmentAuthorization.name().equals(preOrderVO.getOrderSource()) ? SourceIdEnum.SaasShipmentAuthorization.name() : SourceIdEnum.ManualAuthorization.name());
        Goods goods = this.goodsMapper.findGoodsBySid(preOrderVO.getFirstOrderDetail().getGoodsSid().longValue());
        if (goods == null) {
            return ResponseResult.fail((String)String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", preOrderVO.getFirstOrderDetail().getGoodsCode()));
        }
        if (goods.getNeedInit().booleanValue()) {
            if (GoodsCategoryEnum.needInit((String)goods.getCategoryId())) {
                AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(preOrderVO.getTenantId(), dtl.getGoodsCode());
                if (oldAuthInfo == null) {
                    oldAuthInfo = authorizationVO;
                }
                if (this.isInitialize(preOrderVO.getRetryInit(), preOrderVO.getOrderCode(), oldAuthInfo)) {
                    dtl.setGoodsSid(Long.valueOf(goods.getId()));
                    String totalUsage = String.valueOf(authorizationVO.getTotalUsage());
                    String totalUserCount = String.valueOf(authorizationVO.getTotalUserCount());
                    String remainingUsage = String.valueOf(authorizationVO.getRemainingUsage());
                    TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO = new TenantAuthNoticeInfoVO(preOrderVO.getSid().longValue(), preOrderVO.getOrderCode(), OrderInitUpdate.OrderType.PRE_ORDER, preOrderVO.getTenantId(), preOrderVO.getTenantName(), preOrderVO.getTenantSid(), preOrderVO.getCustomerId(), preOrderVO.getPotentialCustomerId(), dtl.getGoodsCode(), dtl.getGoodsSid(), dtl.getStrategyCode(), oldAuthInfo.getExpiredTime(), dtl.getEffectiveDateTime(), dtl.getExpiredDateTime(), preOrderVO.getRemark(), totalUserCount, totalUsage, remainingUsage, sourceId);
                    if (Boolean.TRUE.equals(preOrderVO.getRetryInit())) {
                        List orders = this.preOrderDetailMapper.getPreOrderDetails(preOrderVO.getSid());
                        Optional<Integer> initializeState = orders.stream().map(PreOrderDetailVO::getInitialize).findFirst();
                        if (initializeState.isPresent()) {
                            tenantAuthNoticeInfoVO.setInitialize(initializeState.get());
                        } else {
                            logger.error("\u83b7\u53d6\u4eba\u5de5\u6388\u6743[{}]\u7684\u521d\u59cb\u5316\u72b6\u6001\u5931\u8d25", (Object)preOrderVO.getOrderCode());
                        }
                    }
                    return this.appRenew(tenantAuthNoticeInfoVO);
                }
                if (null != oldAuthInfo && ObjectUtils.isEmpty((Object)dtl.getStrategyCode())) {
                    dtl.setStrategyCode(oldAuthInfo.getLastStrategyId());
                }
            }
        } else if (!GoodsCategoryEnum.isService((String)goods.getCategoryId())) {
            return ResponseResult.fail((String)String.format("\u5e94\u7528[%s]\u4e0d\u9700\u521d\u59cb\u5316", dtl.getGoodsCode()));
        }
        if (!(checkStrategyResult = this.cacService.setGoodsStrategy(preOrderVO, goods)).isSuccess()) {
            return checkStrategyResult;
        }
        CacAuth cacAuth = new CacAuth();
        cacAuth.getAuthorizations().add(goods);
        cacAuth.setOrderCode(preOrderVO.getOrderCode());
        cacAuth.setTenantSid(preOrderVO.getTenantSid());
        cacAuth.setTenantId(preOrderVO.getTenantId());
        cacAuth.setTenantName(preOrderVO.getTenantName());
        cacAuth.setCreateDate(preOrderVO.getCreateDate());
        cacAuth.setCustomerServiceCode(preOrderVO.getCustomerId());
        cacAuth.setPotentialCustomerId(preOrderVO.getPotentialCustomerId());
        cacAuth.setRemark(preOrderVO.getRemark());
        cacAuth.setSourceId(sourceId);
        cacAuth.setUserId(UserUtils.getUserId());
        cacAuth.setUserName(UserUtils.getUserName());
        cacAuth.setCloudDevices(preOrderVO.getCloudDevices());
        return this.appNew(preOrderVO.getSid().longValue(), OrderInitUpdate.OrderType.PRE_ORDER, preOrderVO.getTenantSid(), preOrderVO.getTenantId(), goods.getCode(), goods.getCategoryId(), goods.getBackUri(), cacAuth);
    }

    private void appAuthChangeLogs(PreOrderVO preOrderVO, AuthorizationVO oldAuthVO) {
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        ModifiedInfoDTO dto = new ModifiedInfoDTO();
        dto.setActionId("update");
        if (authoredUser != null) {
            dto.setEditUserId(authoredUser.getUserId());
            dto.setEditUserName(authoredUser.getUserName());
        } else {
            dto.setEditUserId(preOrderVO.getCreateById());
            dto.setEditUserName(preOrderVO.getCreateById());
        }
        ArrayList logFieldList = new ArrayList();
        String fieldName = "fieldName";
        String displayName = "displayName";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(fieldName, "remainingUsage");
        map.put(displayName, "\u5269\u4f59\u6b21\u6570");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "totalUsage");
        map.put(displayName, "\u603b\u4f7f\u7528\u6570\u91cf");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "expiredTime");
        map.put(displayName, "\u5230\u671f\u65f6\u95f4");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "effectiveTime");
        map.put(displayName, "\u6388\u6743\u5f00\u901a\u65e5");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "enabledModules");
        map.put(displayName, "\u53d8\u66f4\u6a21\u7ec4");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "enabledModules.expiredTime");
        map.put(displayName, "\u6388\u6743\u5230\u671f\u65f6\u95f4");
        logFieldList.add(map);
        dto.setLogFieldList(logFieldList);
        ArrayList<HashMap<String, String>> primaryKeyList = new ArrayList<HashMap<String, String>>();
        map = new HashMap();
        map.put("path", "");
        map.put("keyName", "purchaseId");
        primaryKeyList.add(map);
        map = new HashMap();
        map.put("path", "enabledModules");
        map.put("keyName", "id");
        map.put("showField", "name");
        primaryKeyList.add(map);
        dto.setPrimaryKeyList(primaryKeyList);
        dto.setRemark(StrUtils.isEmpty((String)preOrderVO.getMemo()) ? PreOrderTypeEnum.getName((Integer)preOrderVO.getOrderType()) : preOrderVO.getMemo());
        dto.setSource("CAC");
        dto.setTableName("purchase");
        AuthorizationVO authVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(preOrderVO.getTenantId(), preOrderVO.getFirstOrderDetail().getGoodsCode());
        if (authVO != null) {
            authVO.setEffectiveTime(preOrderVO.getFirstOrderDetail().getEffectiveDateTime());
            dto.setPrimaryKey(authVO.getPurchaseId());
            dto.setModifyJson((Map)objectMapper.convertValue((Object)authVO, Map.class));
            dto.setOriginJson(oldAuthVO != null ? (Map)objectMapper.convertValue((Object)oldAuthVO, Map.class) : new HashMap());
            this.lmcService.dataComparison(dto, UserUtils.getToken(), preOrderVO.getTenantId());
        }
    }

    private void updateExpiredDateTime(OrderVO orderVO) {
        Goods goods = this.goodsMapper.findGoodsBySid(orderVO.getFirstOrderDetail().getGoodsSid().longValue());
        if (null == goods) {
            logger.error("\u505c\u7528\u670d\u52a1\u6216\u8005\u8bfe\u7a0b\u7684\u8fc7\u671f\u65f6\u95f4\u5931\u8d25\uff0c\u5546\u54c1[{}]\u4e0d\u5b58\u5728", (Object)orderVO.getFirstOrderDetail().getGoodsSid());
            return;
        }
        if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(goods.getCategoryId()) && Boolean.FALSE.equals(goods.getMaintainServiceStatus())) {
            this.cacService.updateExpiredDateTime(new ProductTypeVO(orderVO.getTenantId(), orderVO.getOrderCode(), orderVO.getRemark()));
        }
    }

    private boolean isInitialize(Boolean retryInit, String orderCode, AuthorizationVO authInfo) {
        if (authInfo != null && authInfo.getInitialize() != null && (authInfo.getInitialize() == 1 || authInfo.getInitialize() == 3)) {
            if (Boolean.TRUE.equals(retryInit)) {
                PreOrderRelateCodeVO relateCodeVO = new PreOrderRelateCodeVO();
                relateCodeVO.setTenantId(authInfo.getTenantId());
                relateCodeVO.setAppId(authInfo.getCode());
                List authRecords = this.cacService.queryCacRecordCode(relateCodeVO);
                if (!CollectionUtils.isEmpty((Collection)authRecords)) {
                    List sortedAuthRecords = authRecords.stream().sorted(Comparator.comparing(PreOrderReportVO::getCreateDate)).collect(Collectors.toList());
                    if (StringUtils.hasText((String)orderCode) && orderCode.equals(((PreOrderReportVO)sortedAuthRecords.get(0)).getOrderCode())) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private ResponseResult appNew(long sid, OrderInitUpdate.OrderType type, Long tenantSid, String tenantId, String goodsCode, String categoryId, String backUri, CacAuth cacAuth) {
        Map tenantSimplesMap = this.iamService.getTenantSimplesMap(Collections.singletonList(cacAuth.getTenantId()));
        CommonVO tenantInfo = tenantSimplesMap.getOrDefault(cacAuth.getTenantId(), new CommonVO());
        cacAuth.setTeamId(tenantInfo.getTeamId());
        cacAuth.setCostDeptId(tenantInfo.getCostDeptId());
        cacAuth.setCostDeptName(tenantInfo.getCostDeptName());
        cacAuth.setCostEmpId(tenantInfo.getCostEmpId());
        cacAuth.setCostEmpName(tenantInfo.getCostEmpName());
        cacAuth.setComeFrom(tenantInfo.getComeFrom());
        if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(categoryId)) {
            this.doSendNotice(sid, SysNoticeEnum.SERVICE_NEW.name(), type, tenantSid, tenantId, goodsCode, backUri, (Object)cacAuth);
        } else {
            this.doSendNotice(sid, SysNoticeEnum.APP_NEW.name(), type, tenantSid, tenantId, goodsCode, null, (Object)cacAuth);
        }
        return ResponseResult.ok((String)"\u5df2\u7ecf\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c");
    }

    private ResponseResult appRenew(TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO) {
        if (tenantAuthNoticeInfoVO.getOldExpiredTime() == null) {
            return ResponseResult.fail((String)String.format("\u79df\u6237%s\u4e0b\u7684\u5e94\u7528%s\u6388\u6743\u4e0d\u5b58\u5728", tenantAuthNoticeInfoVO.getTenantId(), tenantAuthNoticeInfoVO.getGoodsCode()));
        }
        AuthorizationResultVO authorizationResultVO = this.cacService.queryAuthorizationByTenantAndApp(tenantAuthNoticeInfoVO.getTenantId(), tenantAuthNoticeInfoVO.getGoodsCode());
        tenantAuthNoticeInfoVO.setEnabledModules(authorizationResultVO.getEnabledModules());
        tenantAuthNoticeInfoVO.setExpiredTime(authorizationResultVO.getExpiredTime());
        tenantAuthNoticeInfoVO.setTotalCount(String.valueOf(authorizationResultVO.getTotalUserCount()));
        tenantAuthNoticeInfoVO.setTotalUsage(String.valueOf(authorizationResultVO.getTotalUsage()));
        if (tenantAuthNoticeInfoVO.getOldExpiredTime().isBefore(LocalDateTime.now())) {
            Goods goods = this.goodsMapper.findGoodsBySid(tenantAuthNoticeInfoVO.getGoodsSid().longValue());
            if (goods == null) {
                return ResponseResult.fail((String)String.format("\u5546\u54c1%s\u4e0d\u5b58\u5728", tenantAuthNoticeInfoVO.getGoodsSid()));
            }
            this.appAddPurchase(tenantAuthNoticeInfoVO);
            this.sendAppRenew(tenantAuthNoticeInfoVO);
            return ResponseResult.ok((String)"\u5df2\u7ecf\u7eed\u671f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c");
        }
        this.appAddPurchase(tenantAuthNoticeInfoVO);
        if (OrderInitializeStatusEnum.RENEW_FAILED.getValue().equals(tenantAuthNoticeInfoVO.getInitialize())) {
            this.sendAppRenew(tenantAuthNoticeInfoVO);
            return ResponseResult.ok((String)"\u5df2\u7ecf\u7eed\u671f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c");
        }
        return ResponseResult.ok((String)"\u5c1a\u672a\u8fc7\u671f\uff0c\u4e0d\u7528\u7eed\u671f");
    }

    private void appAddPurchase(TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO) {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("tenantSid", tenantAuthNoticeInfoVO.getTenantSid());
        mapParams.put("tenantId", tenantAuthNoticeInfoVO.getTenantId());
        mapParams.put("tenantName", tenantAuthNoticeInfoVO.getTenantName());
        mapParams.put("customerId", tenantAuthNoticeInfoVO.getCustomerId());
        mapParams.put("potentialCustomerId", tenantAuthNoticeInfoVO.getPotentialCustomerId());
        mapParams.put("appId", tenantAuthNoticeInfoVO.getGoodsCode());
        mapParams.put("goodsSid", tenantAuthNoticeInfoVO.getGoodsSid());
        mapParams.put("orderCode", tenantAuthNoticeInfoVO.getOrderCode());
        mapParams.put("effectiveTime", tenantAuthNoticeInfoVO.getAuthorDate());
        mapParams.put("expiredTime", tenantAuthNoticeInfoVO.getExpiredTime());
        mapParams.put("remark", tenantAuthNoticeInfoVO.getRemark());
        mapParams.put("totalCount", tenantAuthNoticeInfoVO.getTotalCount());
        mapParams.put("totalUsage", tenantAuthNoticeInfoVO.getTotalUsage());
        mapParams.put("remainingUsage", tenantAuthNoticeInfoVO.getRemainingUsage());
        mapParams.put("sourceId", tenantAuthNoticeInfoVO.getSourceId());
        mapParams.put("enabledModules", tenantAuthNoticeInfoVO.getEnabledModules());
        GoodsStrategy strategy = this.goodsMapper.findStrategyByCode(tenantAuthNoticeInfoVO.getStrategyCode());
        if (null == strategy) {
            try {
                strategy = this.goodsMapper.findStrategyBySid(Long.parseLong(tenantAuthNoticeInfoVO.getStrategyCode()));
            }
            catch (Exception ex) {
                logger.error("\u9500\u552e\u65b9\u6848{}\u4e0d\u5b58\u5728", (Object)tenantAuthNoticeInfoVO.getStrategyCode());
            }
            logger.error("\u9500\u552e\u65b9\u6848{}\u4e0d\u5b58\u5728", (Object)tenantAuthNoticeInfoVO.getStrategyCode());
        }
        if (null != strategy) {
            mapParams.put("sellingStrategy", strategy.showJson());
        }
        this.doSendNotice(tenantAuthNoticeInfoVO.getSid(), SysNoticeEnum.APP_ADD_PURCHASE.name(), tenantAuthNoticeInfoVO.getType(), tenantAuthNoticeInfoVO.getTenantSid(), tenantAuthNoticeInfoVO.getTenantId(), tenantAuthNoticeInfoVO.getGoodsCode(), null, mapParams);
    }

    private void sendAppRenew(TenantAuthNoticeInfoVO tenantAuthNoticeInfoVO) {
        HashMap mapData = new HashMap();
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("tenantSid", Collections.singletonList(tenantAuthNoticeInfoVO.getTenantSid()));
        mapParams.put("appId", tenantAuthNoticeInfoVO.getGoodsCode());
        mapParams.put("effectiveTime", tenantAuthNoticeInfoVO.getAuthorDate());
        mapParams.put("expiredTime", tenantAuthNoticeInfoVO.getExpiredTime());
        mapParams.put("totalUsage", tenantAuthNoticeInfoVO.getTotalUsage());
        mapParams.put("totalCount", tenantAuthNoticeInfoVO.getTotalCount());
        mapParams.put("remark", tenantAuthNoticeInfoVO.getRemark());
        HashMap<String, Object> tenantMap = new HashMap<String, Object>();
        tenantMap.put("tenantSid", tenantAuthNoticeInfoVO.getTenantSid());
        tenantMap.put("tenantId", tenantAuthNoticeInfoVO.getTenantId());
        tenantMap.put("customerServiceCode", tenantAuthNoticeInfoVO.getCustomerId());
        tenantMap.put("customerId", tenantAuthNoticeInfoVO.getCustomerId());
        tenantMap.put("potentialCustomerId", tenantAuthNoticeInfoVO.getPotentialCustomerId());
        tenantMap.put("tenantName", tenantAuthNoticeInfoVO.getTenantName());
        mapParams.put("tenants", Collections.singletonList(tenantMap));
        mapParams.put("sourceId", tenantAuthNoticeInfoVO.getSourceId());
        mapParams.put("enabledModules", tenantAuthNoticeInfoVO.getEnabledModules());
        mapData.put("params", mapParams);
        this.doSendNotice(tenantAuthNoticeInfoVO.getSid(), SysNoticeEnum.APP_RENEW.name(), tenantAuthNoticeInfoVO.getType(), tenantAuthNoticeInfoVO.getTenantSid(), tenantAuthNoticeInfoVO.getTenantId(), tenantAuthNoticeInfoVO.getGoodsCode(), null, mapData);
    }

    private void doSendNotice(long sid, String opType, OrderInitUpdate.OrderType type, Long tenantSid, String tenantId, String goodsCode, String backUri, Object data) {
        MessageBody messageBody = new MessageBody();
        messageBody.setOpType(opType);
        messageBody.setData(data);
        messageBody.setTenantSid(tenantSid);
        messageBody.setTenantId(tenantId);
        messageBody.setSysId(goodsCode);
        OrderInitUpdate.OrderInfo noticeData = new OrderInitUpdate.OrderInfo();
        noticeData.setSid(Long.valueOf(sid));
        noticeData.setGoodsCode(goodsCode);
        noticeData.setTenantId(tenantId);
        noticeData.setType(type);
        messageBody.setNoticeUri(this.envProperties.getOmcUri() + SysNoticeEnum.APP_CALLBACK.path());
        messageBody.setNoticeData((Object)noticeData);
        messageBody.setBackUri(backUri);
        this.producerService.sys(messageBody);
    }
}

