/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.support.remote.BossiamService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BossiamServiceImpl
implements BossiamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BossiamServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    private static final String GET_BOSS_TENANTS = "/api/boss/v1/tenants?pageNum={pageNum}&pageSize={pageSize}&params={params}";
    private static final String GET_BOSS_TENANTS_SIMPLE = "/api/boss/v1/tenants/simples";

    public List<TenantVO> getBossTenants(Map<String, Object> paramsMap) {
        HashMap<String, Object> uriVariablesMap = new HashMap<String, Object>();
        uriVariablesMap.put("pageNum", 1);
        uriVariablesMap.put("pageSize", 999999);
        try {
            uriVariablesMap.put("params", JsonUtils.createObjectMapper().writeValueAsString(paramsMap));
        }
        catch (JsonProcessingException e) {
            throw new BusinessException("BOSS\u67e5\u8be2\u79df\u6237paramsMap\u8f6c\u5316String\u5931\u8d25", (Throwable)e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getBossiamUri() + GET_BOSS_TENANTS;
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, uriVariablesMap);
            return Optional.ofNullable(responseEntity.getBody()).map(PageSerializable::getList).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010BOSS\u8c03\u7528\u3011\u67e5\u8be2\u79df\u6237\u5931\u8d25", (String)url, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u3010BOSS\u8c03\u7528\u3011\u67e5\u8be2\u79df\u6237\u5931\u8d25");
        }
    }

    public List<TenantVO> getBossTenantsSimple(List<String> tenantIds) {
        if (CollectionUtils.isEmpty(tenantIds)) {
            return new ArrayList<TenantVO>();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity requestEntity = new HttpEntity(tenantIds, (MultiValueMap)headers);
        String url = this.envProperties.getBossiamUri() + GET_BOSS_TENANTS_SIMPLE;
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010BOSS\u8c03\u7528\u3011\u67e5\u8be2\u79df\u6237\u5931\u8d25", (String)url, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
            return new ArrayList<TenantVO>();
        }
    }
}

