/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.omc.constant.enums.AuthCategory;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsPaymentEnum;
import com.digiwin.dap.middleware.omc.constant.enums.SourceIdEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderAuthTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.domain.AuthDataVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.remote.CacAuth;
import com.digiwin.dap.middleware.omc.domain.remote.CancelAuth;
import com.digiwin.dap.middleware.omc.domain.remote.EditParamVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.IamApp;
import com.digiwin.dap.middleware.omc.domain.remote.ProductTypeVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderRelateCodeVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderReportVO;
import com.digiwin.dap.middleware.omc.domain.request.GoodsAuthDO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.AuthorizationModuleVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.LmcService;
import com.digiwin.dap.middleware.omc.support.tsign.domain.ChangeLogVO;
import com.digiwin.dap.middleware.omc.util.ErrorMessageExtractor;
import com.digiwin.dap.middleware.omc.util.HttpUtil;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class CacServiceImpl
implements CacService {
    private static final Logger logger = LoggerFactory.getLogger(CacServiceImpl.class);
    private static final String AUTHORIZATIONS = "/api/cac/v3/authorizations";
    private static final String ADD_USER_COUNT = "/api/cac/v4/authorizations/update";
    private static final String AUTHORIZATIONS_V4 = "/api/cac/v4/authorizations";
    private static final String AUTHORIZATIONS_EXPIRE = "/api/cac/v4/authorizations/tenants/goods/module/expire";
    private static final String AUTHORIZATIONS_V4_CALCULATE = "/api/cac/v4/authorizations/calculate";
    private static final String AUTHORIZATIONS_GOODS_EXPIRE = "/api/cac/v4/authorizations/tenants/goods/expire";
    private static final String SYNC_RECORD = "/api/cac/v4/record/sync";
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate2;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private LmcService lmcService;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;

    public ResponseResult authorization(OrderVO order) {
        if (3 == order.getOrderType()) {
            return this.addUserCountAuth(order);
        }
        if (order.isAccessoryFlag()) {
            return this.purchaseAuthAccessory(order);
        }
        return this.purchaseAuth(order);
    }

    private ResponseResult purchaseAuthAccessory(OrderVO order) {
        ResponseResult responseResult = new ResponseResult();
        Goods goods = this.goodsMapper.findGoodsBySid(order.getFirstOrderDetail().getGoodsSid().longValue());
        if (null == goods) {
            responseResult.setMessage(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", order.getFirstOrderDetail().getGoodsSid()));
            return responseResult;
        }
        CacAuth cacAuth = this.buildCacBody(order, goods);
        logger.info("\u51c6\u5907cac\u6388\u6743\uff0c\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)cacAuth));
        String uri = this.envProperties.getCacUri() + AUTHORIZATIONS;
        return this.authorization(uri, (Object)cacAuth);
    }

    public ResponseResult authorization(PreOrderVO preOrderVO) {
        if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(preOrderVO.getOrderType())) {
            return this.authorizationsUpdate(preOrderVO);
        }
        return this.purchaseAuth(preOrderVO);
    }

    public void setGoodsStrategy(OrderVO order, Goods goods) {
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(order.getFirstOrderDetail().getStrategySid().longValue());
        if (null != order.getGoods()) {
            strategy.setEnabledModules(order.getGoods().getSellingStrategy().getEnabledModules());
            goods.setSellingStrategy(strategy);
        } else {
            goods.setSellingStrategy(strategy.showJson());
            this.setApiGoodsModules(goods, strategy);
        }
        goods.setTotalUsage(strategy.getUseCount());
        goods.setTotalCount(null == order.getUserNumber() || order.getUserNumber() == 0 ? strategy.getUsersNumber() : order.getUserNumber());
        goods.setRemainingUsage(goods.getTotalUsage());
        goods.setOrderNumber(order.getFirstOrderDetail().getQuantity());
        Integer tenancyPeriod = strategy.getTenancyPeriod();
        goods.setDeviceTenancyPeriod(tenancyPeriod);
        if (order.getBnpl() != null) {
            Integer totalCount = order.getBnpl().getTotalCount();
            goods.setOrderNumber(Integer.valueOf(goods.getOrderNumber() * totalCount));
            goods.setDeviceTenancyPeriod(Integer.valueOf(tenancyPeriod * totalCount));
        }
        goods.setEffectiveTime(order.getAuthorizationDate());
        goods.setTransferUnused(strategy.getTransferUnused());
    }

    private void setApiGoodsModules(Goods goods, GoodsStrategy strategy) {
        if (GoodsCategoryEnum.API.name().equalsIgnoreCase(goods.getCategoryId())) {
            String modulesStr = this.goodsMapper.findGoodsModules(goods.getCode());
            goods.setSellingStrategy(strategy.setApiGoodsModules(modulesStr));
        }
    }

    private CacAuth buildPackCacBody(OrderVO order, Goods goods) {
        CacAuth cacAuth = new CacAuth();
        GoodsStrategy strategy = new GoodsStrategy();
        goods.setSellingStrategy(strategy);
        strategy.setId(Long.valueOf(0L));
        strategy.setEnabledModules(new ArrayList());
        goods.setItemId(goods.getCode());
        goods.setTotalUsage(strategy.getUseCount());
        goods.setTotalCount(null == order.getUserNumber() || order.getUserNumber() == 0 ? strategy.getUsersNumber() : order.getUserNumber());
        goods.setRemainingUsage(goods.getTotalUsage());
        goods.setOrderNumber(order.getFirstOrderDetail().getQuantity());
        goods.setEffectiveTime(order.getAuthorizationDate());
        goods.setExpiredTime(order.getExpireTime());
        goods.setPaymentType(Integer.valueOf(1));
        goods.setBufferPeriod(Boolean.FALSE);
        goods.setCategory(Integer.valueOf(AuthCategory.BossManualAuthorization.ordinal()));
        goods.setSourceId("OrderPayment");
        goods.setSourceCode(order.getOrderCode());
        goods.setResourceCategory(order.getFirstOrderDetail().getResourceCategory());
        goods.setMainCode(order.getAccessoryOf());
        cacAuth.getAuthorizations().add(goods);
        cacAuth.setOrderCode(order.getOrderCode());
        cacAuth.setTenantId(order.getTenantId());
        cacAuth.setTenantName(order.getTenantName());
        if (Boolean.TRUE.equals(order.getShouldAuthUser())) {
            cacAuth.setUserId(order.getUserId());
        }
        cacAuth.setBatchCode(order.getBatchCode());
        return cacAuth;
    }

    public ResponseResult setGoodsStrategy(PreOrderVO order, Goods goods) {
        PreOrderDetailVO dtl = order.getFirstOrderDetail();
        return this.setGoodsStrategy(goods, dtl.getStrategyCode(), null == dtl.getTotalUsageBound() ? "0" : String.valueOf(dtl.getTotalUsageBound()), dtl.getEffectiveDateTime(), dtl.getExpiredDateTime(), dtl.getModules(), PreOrderAuthTypeEnum.BOSS);
    }

    public ResponseResult setGoodsStrategy(Goods goods, String strategyCode, String userNumber, LocalDateTime effectiveDataTime, LocalDateTime expireDateTime, List<AuthorizationModuleVO> modules) {
        return this.setGoodsStrategy(goods, strategyCode, userNumber, effectiveDataTime, expireDateTime, modules, PreOrderAuthTypeEnum.OTHER);
    }

    public ResponseResult setGoodsStrategy(Goods goods, String strategyCode, String userNumber, LocalDateTime effectiveDataTime, LocalDateTime expireDateTime, List<AuthorizationModuleVO> modules, PreOrderAuthTypeEnum authType) {
        GoodsStrategy strategy = this.goodsMapper.findStrategyByCode(strategyCode);
        if (strategy == null) {
            try {
                strategy = this.goodsMapper.findStrategyBySid(Long.parseLong(strategyCode));
            }
            catch (Exception ex) {
                logger.error("\u9500\u552e\u65b9\u6848{}\u4e0d\u5b58\u5728", (Object)strategyCode);
                return new ResponseResult(Boolean.FALSE.booleanValue(), String.format("\u9500\u552e\u65b9\u6848\u4e0d\u5b58\u5728strategyCode=[%s]", strategyCode));
            }
            if (strategy == null) {
                logger.error("\u9500\u552e\u65b9\u6848{}\u4e0d\u5b58\u5728", (Object)strategyCode);
                return new ResponseResult(Boolean.FALSE.booleanValue(), String.format("\u9500\u552e\u65b9\u6848\u4e0d\u5b58\u5728strategyCode=[%s]", strategyCode));
            }
        }
        if (null == strategy.getEnabledModules()) {
            goods.setSellingStrategy(strategy.showJson());
        } else {
            goods.setSellingStrategy(strategy);
        }
        if (null != modules) {
            strategy.setEnabledModules(modules);
        }
        this.setApiGoodsModules(goods, strategy);
        goods.setOrderSource(OrderSourceEnum.BossManualAuthorization.name());
        if (PreOrderAuthTypeEnum.BOSS.equals((Object)authType)) {
            goods.setTotalUsage(Integer.valueOf(StrUtils.isEmpty((String)userNumber) ? 0 : Integer.parseInt(userNumber)));
            goods.setTotalCount(Integer.valueOf(StrUtils.isEmpty((String)userNumber) ? 0 : Integer.parseInt(userNumber)));
        } else {
            goods.setTotalUsage(Integer.valueOf(StrUtils.isEmpty((String)userNumber) || "0".equals(userNumber) ? strategy.getUseCount() : Integer.parseInt(userNumber)));
            goods.setTotalCount(Integer.valueOf(StrUtils.isEmpty((String)userNumber) || "0".equals(userNumber) ? strategy.getUsersNumber() : Integer.parseInt(userNumber)));
        }
        goods.setRemainingUsage(goods.getTotalUsage());
        goods.setOrderNumber(Integer.valueOf(1));
        if (null != effectiveDataTime && null != expireDateTime) {
            goods.setEffectiveTime(effectiveDataTime);
            goods.setExpiredTime(expireDateTime);
        }
        goods.setTransferUnused(strategy.getTransferUnused());
        return new ResponseResult(true);
    }

    public AuthorizationVO getAuthorizationVoByTenantIdAndGoodCode(String tenantId, String appId) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + appId;
        try {
            return (AuthorizationVO)this.restTemplate.getForObject(uri, AuthorizationVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)String.format("\u83b7\u53d6\u79df\u6236%s\u5e94\u7528%s\u6388\u6743\u5f02\u5e38", tenantId, appId), (String)uri, null, (Exception)e), (Throwable)e);
            return null;
        }
    }

    private ResponseResult addUserCountAuth(OrderVO order) {
        HashMap<String, Object> cacAuth = new HashMap<String, Object>();
        cacAuth.put("paymentType", "1");
        cacAuth.put("tenantId", order.getTenantId());
        cacAuth.put("productCode", order.getGoodsCode());
        if (null == order.getUserNumber() || null == order.getOriginUserNumber()) {
            return new ResponseResult(false, "userNumber\u6216\u8005originUserNumber\u4e0d\u80fd\u4e3anull!");
        }
        cacAuth.put("totalUsage", order.getUserNumber() + order.getOriginUserNumber());
        cacAuth.put("memo", String.format("\u8ba2\u5355[%s]\u6388\u6743\u52a0\u8d2d", order.getOrderCode()));
        cacAuth.put("bufferPeriod", Boolean.FALSE);
        String uri = this.envProperties.getCacUri() + ADD_USER_COUNT;
        return this.authorization(uri, cacAuth);
    }

    private ResponseResult authorizationsUpdate(PreOrderVO preOrderVO) {
        ResponseResult responseResult = new ResponseResult();
        PreOrderDetailVO orderDetailVO = preOrderVO.getFirstOrderDetail();
        EditParamVO editParamVO = new EditParamVO();
        editParamVO.setTenantId(preOrderVO.getTenantId());
        editParamVO.setTenantName(preOrderVO.getTenantName());
        editParamVO.setProductCode(orderDetailVO.getGoodsCode());
        Goods goods = this.goodsMapper.findGoodsBySid(orderDetailVO.getGoodsSid().longValue());
        if (null == goods) {
            responseResult.setMessage(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", orderDetailVO.getGoodsSid()));
            return responseResult;
        }
        editParamVO.setPaymentType(goods.getPaymentType().intValue());
        editParamVO.setTotalUsage(orderDetailVO.getTotalUsageBound());
        editParamVO.setRemainingUsage(orderDetailVO.getRemainUsageBound());
        editParamVO.setMonthlyUsage(orderDetailVO.getMonthlyUsage());
        editParamVO.setEffectiveTime(orderDetailVO.getEffectiveDateTime());
        editParamVO.setExpiredTime(orderDetailVO.getExpiredDateTime());
        if (Boolean.TRUE.equals(preOrderVO.getSendEmail())) {
            editParamVO.setCurrentTenant(preOrderVO.getNoticeTenant());
            if (StrUtils.isNotEmpty((String)preOrderVO.getEmails())) {
                String[] emailsArr = preOrderVO.getEmails().replaceAll("\uff1b", ";").split(";");
                editParamVO.setEmails(Arrays.asList(emailsArr));
            }
        }
        editParamVO.setMemo(preOrderVO.getComment());
        editParamVO.setModules(orderDetailVO.getModules());
        editParamVO.setBufferPeriod(Boolean.FALSE);
        editParamVO.setSourceId(SourceIdEnum.ApplicationChanges.name());
        editParamVO.setSourceCode(preOrderVO.getOrderCode());
        editParamVO.setCustomAttributes(preOrderVO.getFirstOrderDetail().getCustomattributes());
        editParamVO.setMemo(preOrderVO.getRemark());
        editParamVO.setExpireNotice(preOrderVO.getExpireNotice());
        editParamVO.setBatchCode(preOrderVO.getBatchCode());
        String uri = this.envProperties.getCacUri() + ADD_USER_COUNT;
        return this.authorization(uri, (Object)editParamVO);
    }

    private ResponseResult purchaseAuth(OrderVO order) {
        ResponseResult responseResult = new ResponseResult();
        Goods goods = this.goodsMapper.findGoodsBySid(order.getFirstOrderDetail().getGoodsSid().longValue());
        if (null == goods) {
            responseResult.setMessage(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", order.getFirstOrderDetail().getGoodsSid()));
            return responseResult;
        }
        CacAuth cacAuth = order.isPackOrder() ? this.buildPackCacBody(order, goods) : this.buildCacBody(order, goods);
        logger.info("\u51c6\u5907cac\u6388\u6743\uff0c\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)cacAuth));
        String uri = this.envProperties.getCacUri() + AUTHORIZATIONS;
        return this.authorization(uri, (Object)cacAuth);
    }

    private CacAuth buildCacBody(OrderVO order, Goods goods) {
        CacAuth cacAuth = new CacAuth();
        if (!GoodsCategoryEnum.isApp((String)goods.getCategoryId())) {
            goods.setId(order.getOrderCode());
        }
        this.setGoodsStrategy(order, goods);
        goods.setBufferPeriod(Boolean.FALSE);
        goods.setCategory(Integer.valueOf(AuthCategory.OverlayTenancyPeriod.ordinal()));
        goods.setSourceId("OrderPayment");
        goods.setSourceCode(order.getOrderCode());
        goods.setResourceCategory(order.getFirstOrderDetail().getResourceCategory());
        goods.setMainCode(order.getAccessoryOf());
        cacAuth.getAuthorizations().add(goods);
        cacAuth.setOrderCode(order.getOrderCode());
        cacAuth.setTenantId(order.getTenantId());
        cacAuth.setTenantName(order.getTenantName());
        if (Boolean.TRUE.equals(order.getShouldAuthUser())) {
            cacAuth.setUserId(order.getUserId());
        }
        cacAuth.setBatchCode(order.getBatchCode());
        this.setCloudDeviceRenewExpireTime(order, goods);
        return cacAuth;
    }

    private void setCloudDeviceRenewExpireTime(OrderVO order, Goods goods) {
        try {
            String deviceCode;
            if (GoodsCategoryEnum.isDevice((String)goods.getCategoryId()) && OrderTypeEnum.APP_RENEW.getValue() == order.getOrderType().intValue() && StringUtils.hasLength((String)(deviceCode = order.getFirstOrderDetail().getDeviceCode()))) {
                List deviceCodes = Arrays.stream(deviceCode.split(String.valueOf(';'))).collect(Collectors.toList());
                List devices = this.orderCloudDeviceRepository.findByCodeIn(deviceCodes);
                LocalDateTime expireTime = devices.stream().collect(Collectors.groupingBy(OrderCloudDevice::getCode)).values().stream().map(group -> group.stream().filter(a -> Boolean.TRUE.equals(a.isDisabled())).map(OrderCloudDevice::getExpireDate).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null)).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
                LocalDateTime effectiveTime = expireTime != null && expireTime.isBefore(LocalDateTime.now()) ? LocalDateTime.now() : expireTime;
                logger.info("\u8bbe\u5907\u5f00\u59cb\u65f6\u95f4\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)effectiveTime);
                goods.setEffectiveTime(effectiveTime);
            }
        }
        catch (Exception e) {
            logger.error("\u7ec4\u5408\u5546\u54c1\u7eed\u7ea6\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4\u5931\u8d25", (Throwable)e);
        }
    }

    private ResponseResult purchaseAuth(PreOrderVO preOrderVO) {
        ResponseResult responseResult = new ResponseResult();
        CacAuth cacAuth = new CacAuth();
        PreOrderDetailVO detail = preOrderVO.getFirstOrderDetail();
        Goods goods = this.goodsMapper.findGoodsBySid(detail.getGoodsSid().longValue());
        if (null == goods) {
            responseResult.setMessage(String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", detail.getGoodsSid()));
            return responseResult;
        }
        if (!GoodsCategoryEnum.isApp((String)goods.getCategoryId())) {
            goods.setId(preOrderVO.getOrderCode());
        }
        goods.setBufferPeriod(Boolean.FALSE);
        goods.setCategory(Integer.valueOf(this.decideCategory(preOrderVO)));
        goods.setSourceId(PreOrderSourceEnum.SaaSShipmentAuthorization.name().equals(preOrderVO.getOrderSource()) ? "SaasShipmentAuthorization" : "ManualAuthorization");
        goods.setSourceCode(preOrderVO.getOrderCode());
        goods.setCustomattributes(detail.getCustomattributesStr());
        goods.setMemo(preOrderVO.getRemark());
        goods.setExpireNotice(preOrderVO.getExpireNotice());
        if (!GoodsCategoryEnum.BUNDLE.name().equalsIgnoreCase(goods.getCategoryId())) {
            goods.setBundleCode(detail.getBundleCode());
            goods.setBundleName(detail.getBundleName());
        }
        if (!(responseResult = this.setGoodsStrategy(preOrderVO, goods)).isSuccess()) {
            return responseResult;
        }
        cacAuth.setUserId(preOrderVO.getUserId());
        cacAuth.getAuthorizations().add(goods);
        cacAuth.setOrderCode(preOrderVO.getOrderCode());
        cacAuth.setTenantId(preOrderVO.getTenantId());
        cacAuth.setTenantName(preOrderVO.getTenantName());
        this.processBorrow(preOrderVO, goods);
        cacAuth.setBatchCode(preOrderVO.getBatchCode());
        logger.info("\u51c6\u5907cac\u6388\u6743\uff0c\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)cacAuth));
        String uri = this.envProperties.getCacUri() + AUTHORIZATIONS;
        return this.authorization(uri, (Object)cacAuth);
    }

    private int decideCategory(PreOrderVO preOrderVO) {
        String orderSource = preOrderVO.getOrderSource();
        if (PreOrderSourceEnum.PlatformAuto.name().equals(orderSource)) {
            return AuthCategory.PlatformAuto.ordinal();
        }
        if (PreOrderSourceEnum.Accessory.name().equals(orderSource)) {
            return AuthCategory.Accessory.ordinal();
        }
        return AuthCategory.BossManualAuthorization.ordinal();
    }

    private void processBorrow(PreOrderVO dto, Goods goods) {
        Object enabledModules;
        if (!ShipmentScenarioEnum.BORROWING.getValue().equals(dto.getShipmentScenario())) {
            return;
        }
        PreOrderDetailVO detail = dto.getFirstOrderDetail();
        if (!ObjectUtils.isEmpty((Object)detail.getOldExpiredDateTime())) {
            LocalDateTime expireTime = detail.getExpiredDateTime().isAfter(detail.getOldExpiredDateTime()) ? detail.getExpiredDateTime() : detail.getOldExpiredDateTime();
            goods.setExpiredTime(expireTime);
        }
        if ((enabledModules = goods.getSellingStrategy().getEnabledModules()) instanceof List) {
            for (Object enabledModule : (List)enabledModules) {
                AuthorizationModuleVO enabledModule1;
                if (!(enabledModule instanceof AuthorizationModuleVO) || ObjectUtils.isEmpty((Object)(enabledModule1 = (AuthorizationModuleVO)enabledModule).getOldExpiredTime())) continue;
                LocalDateTime expireTime = enabledModule1.getExpiredTime().isAfter(enabledModule1.getOldExpiredTime()) ? enabledModule1.getExpiredTime() : enabledModule1.getOldExpiredTime();
                enabledModule1.setExpiredTime(expireTime);
            }
        }
    }

    public ResponseResult purchaseAuth(GoodsAuthDO goodsAuthDO) {
        ResponseResult responseResult = new ResponseResult(true);
        try {
            Goods goods;
            CacAuth cacAuth = new CacAuth(goodsAuthDO);
            if (0 == goodsAuthDO.getAction()) {
                goods = this.goodsMapper.findGoodsByCode(goodsAuthDO.getAppId());
                Assert.notNull((Object)goods, (String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
                goods.setVersion("1.0.0.0");
                goods.setItemId(goodsAuthDO.getAppId());
                goods.setGoodsAliasId(goodsAuthDO.getGoodsAliasId());
                goods.setSourceId(goodsAuthDO.getSourceId());
                goods.setSourceCode(goodsAuthDO.getSourceCode());
                goods.setMemo(goodsAuthDO.getMemo());
                goods.setCategory(goodsAuthDO.getCategory());
                goods.setBundleCode(goodsAuthDO.getBundleCode());
                goods.setBundleName(goodsAuthDO.getBundleName());
                responseResult = this.setGoodsStrategy(goods, goodsAuthDO.getStrategyCode(), goodsAuthDO.getUserNumber(), goodsAuthDO.getEffectiveDateTime(), goodsAuthDO.getExpiredDateTime(), goodsAuthDO.getModules());
                if (null == goods.getEffectiveTime() || null == goods.getExpiredTime()) {
                    if (Boolean.TRUE.equals(goodsAuthDO.getUpdateTenantAuth())) {
                        goods.setCategory(Integer.valueOf(1));
                    } else {
                        goods.setCategory(Integer.valueOf(0));
                    }
                }
                cacAuth.getAuthorizations().add(goods);
                if (goods.getNeedInit().booleanValue() && GoodsCategoryEnum.needInit((String)goods.getCategoryId())) {
                    AuthorizationVO authInfo = this.getAuthorizationVoByTenantIdAndGoodCode(goodsAuthDO.getTenantId(), goodsAuthDO.getAppId());
                    responseResult.setAuthInfo(authInfo);
                }
            } else {
                goods = new Goods();
                goods.setCode(goodsAuthDO.getAppId());
                goods.setSourceId(goodsAuthDO.getSourceId());
                goods.setSourceCode(goodsAuthDO.getSourceCode());
                goods.setMemo(goodsAuthDO.getMemo());
                goods.setCategory(goodsAuthDO.getCategory());
                cacAuth.getAuthorizations().add(goods);
            }
            cacAuth.setBatchCode(goodsAuthDO.getBatchCode());
            if (!responseResult.isSuccess()) {
                return responseResult;
            }
            String uri = this.envProperties.getCacUri() + AUTHORIZATIONS;
            String json = null;
            try {
                json = objectMapper.writeValueAsString((Object)cacAuth);
            }
            catch (JsonProcessingException e) {
                logger.error("object\u8f6cjson\u5931\u8d25", (Throwable)e);
            }
            logger.info("\u5f00\u59cbCAC\u6388\u6743 {}", (Object)json);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                responseResult.setSuccess(true);
                responseResult.setMessage("cac\u6388\u6743\u6210\u529f");
            } else {
                responseResult.setSuccess(false);
                responseResult.setMessage("cac\u6388\u6743\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("cac\u6388\u6743\u5931\u8d25", (Throwable)e);
            responseResult.setSuccess(false);
            responseResult.setMessage("cac\u6388\u6743\u5931\u8d25:" + ErrorMessageExtractor.extractMessage((String)e.getMessage()));
        }
        return responseResult;
    }

    public ResponseResult obsoleteTenantAuth(List<PreOrderDetailVO> obsoleteAuthInfo) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/obsolete/appauth";
        try {
            HttpEntity request = HttpUtil.getHttpEntity(obsoleteAuthInfo);
            ResponseResult result = (ResponseResult)this.restTemplate.postForObject(uri, (Object)request, ResponseResult.class, new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new BusinessException("\u4f5c\u5e9fSaas\u51fa\u8d27\u6388\u6743\u5931\u8d25", (Throwable)e);
        }
    }

    public ResponseResult updateInitializeState(String tenantId, String goodsCode, Integer initialize) {
        ResponseResult responseResult = new ResponseResult(false, "CAC\u66f4\u65b0\u521d\u59cb\u5316\u72b6\u6001\u5931\u8d25");
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenant/goods/initialize/update";
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("code", goodsCode);
        requestBody.put("initialize", initialize);
        HttpEntity request = HttpUtil.getHttpEntity(requestBody);
        try {
            this.restTemplate.postForObject(uri, (Object)request, StdData.class, new Object[0]);
        }
        catch (Exception exception) {
            logger.error("\u66f4\u65b0\u521d\u59cb\u5316\u72b6\u6001\u5931\u8d25", (Throwable)exception);
        }
        return responseResult;
    }

    public ResponseResult authorization(CacAuth cacAuth) {
        ResponseResult responseResult = new ResponseResult(false, "CAC\u6388\u6743\u5931\u8d25");
        HttpEntity request = HttpUtil.getHttpEntity((Object)cacAuth);
        String uri = this.envProperties.getCacUri() + AUTHORIZATIONS;
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                responseResult.setSuccess(true);
                responseResult.setMessage("\u6388\u6743\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC\u6388\u6743\u8bf7\u6c42\u5931\u8d25", (String)uri, (Object)request.getBody(), (Exception)e), (Throwable)e);
        }
        return responseResult;
    }

    private ResponseResult authorization(String uri, Object cacAuth) {
        ResponseResult responseResult = new ResponseResult(false, "CAC\u6388\u6743\u5931\u8d25");
        HttpEntity request = HttpUtil.getHttpEntity((Object)cacAuth);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                responseResult.setSuccess(true);
                responseResult.setMessage("\u6388\u6743\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC\u6388\u6743\u8bf7\u6c42\u5931\u8d25", (String)uri, (Object)request.getBody(), (Exception)e), (Throwable)e);
        }
        return responseResult;
    }

    public StdData batchAuth(List<Long> orderSids, AuthDataVO authDataVO, String userToken) {
        ArrayList authorizations = new ArrayList();
        ArrayList iamApps = new ArrayList();
        orderSids.forEach(orderSid -> {
            OrderVO order = this.orderQueryService.getOrderBySid(orderSid.longValue());
            Goods goods = this.goodsMapper.findGoodsBySid(order.getFirstOrderDetail().getGoodsSid().longValue());
            if (goods.getEquip().booleanValue() || GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(goods.getCategoryId())) {
                return;
            }
            if (!GoodsCategoryEnum.APP.name().equalsIgnoreCase(goods.getCategoryId())) {
                goods.setId(order.getOrderCode());
            } else {
                iamApps.add(new IamApp(goods.getCode()));
            }
            this.setGoodsStrategy0(order, goods);
            goods.setCategory(Integer.valueOf(2));
            goods.setSourceId("AuthorizationCodeOpen");
            goods.setSourceCode(authDataVO.getCode());
            goods.setEffectiveTime(authDataVO.getBeginDate());
            goods.setExpiredTime(authDataVO.getEndDate());
            goods.setBufferPeriod(Boolean.FALSE);
            authorizations.add(goods);
        });
        StdData stdData = this.iamService.purchaseApp(iamApps, userToken);
        if (!stdData.getSuccess().booleanValue()) {
            return stdData;
        }
        ArrayList changeLogVOS = new ArrayList();
        List oldAuthApps = this.queryAllAuthorization(UserUtils.getAuthoredUser().getTenantId());
        authorizations.forEach(auth -> {
            if (GoodsCategoryEnum.APP.name().equalsIgnoreCase(auth.getCategoryId())) {
                ChangeLogVO changeLogVO = new ChangeLogVO();
                changeLogVO.setSource("CAC");
                changeLogVO.setActionId("update");
                changeLogVO.setEditUserId(UserUtils.getUserId());
                changeLogVO.setEditUserName(UserUtils.getUserName());
                changeLogVO.setEditTime(LocalDateTime.now());
                changeLogVO.setRemark(String.format("\u6388\u6743\u7801\u5f00\u901a[%s]", authDataVO.getCode()));
                for (AuthorizationResultVO app : oldAuthApps) {
                    if (!auth.getCode().equals(app.getCode())) continue;
                    ArrayList changeInfoList = new ArrayList();
                    changeLogVO.setPrimaryKey(app.getPurchaseId());
                    HashMap<String, Object> changeFieldMap = new HashMap<String, Object>();
                    changeFieldMap.put("key", "totalUsage");
                    changeFieldMap.put("displayName", "\u603b\u4f7f\u7528\u6570\u91cf");
                    if (GoodsPaymentEnum.PersonMonth.ordinal() == auth.getPaymentType().intValue()) {
                        if (app.getExpiredTime().isBefore(LocalDateTime.now())) {
                            changeFieldMap.put("modifyValue", auth.getTotalCount());
                            changeInfoList.add(changeFieldMap);
                        } else {
                            changeFieldMap.put("modifyValue", app.getTotalUserCount() + auth.getTotalCount());
                            changeInfoList.add(changeFieldMap);
                        }
                        changeFieldMap.put("originValue", app.getTotalUserCount());
                    } else if (GoodsPaymentEnum.Count.ordinal() == auth.getPaymentType().intValue() || GoodsPaymentEnum.CountByMonth.ordinal() == auth.getPaymentType().intValue()) {
                        changeFieldMap.put("originValue", app.getTotalUsage());
                        changeFieldMap.put("modifyValue", app.getTotalUsage() + auth.getOrderNumber() * auth.getTotalUsage());
                        changeInfoList.add(changeFieldMap);
                    }
                    if (auth.getExpiredTime().isAfter(app.getExpiredTime())) {
                        changeFieldMap = new HashMap();
                        changeFieldMap.put("key", "expiredTime");
                        changeFieldMap.put("displayName", "\u5230\u671f\u65f6\u95f4");
                        changeFieldMap.put("originValue", app.getExpiredTime());
                        changeFieldMap.put("modifyValue", auth.getExpiredTime());
                        changeInfoList.add(changeFieldMap);
                    }
                    changeLogVO.setChangeInfoList(changeInfoList);
                    break;
                }
                if (!changeLogVO.getChangeInfoList().isEmpty()) {
                    changeLogVOS.add(changeLogVO);
                }
            }
        });
        String uri = this.envProperties.getCacUri() + AUTHORIZATIONS_V4;
        HttpEntity request = HttpUtil.getHttpEntity(authorizations, (String)userToken);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                changeLogVOS.forEach(log -> this.lmcService.saveAuthChangeLogByDealer(log));
                return StdData.ok().build();
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC\u6279\u91cf\u6388\u6743\u8bf7\u6c42\u5931\u8d25", (String)uri, (Object)request.getBody(), (Exception)e));
        }
        return StdData.of((int)500, (String)String.format("\u6388\u6743\u7801[%s]\u5f00\u901a\u6388\u6743\u5931\u8d25", authDataVO.getCode()));
    }

    public void cancelAuth(String deviceCode, List<CancelAuth> authGoods, String userToken) {
        if (authGoods.isEmpty()) {
            return;
        }
        String uri = this.envProperties.getCacUri() + AUTHORIZATIONS_V4;
        try {
            List oldAuthApps = this.queryAllAuthorization(UserUtils.getAuthoredUser().getTenantId());
            ArrayList changeLogVOS = new ArrayList();
            authGoods.forEach(auth -> {
                if (GoodsCategoryEnum.APP.name().equalsIgnoreCase(auth.getCategoryId())) {
                    ChangeLogVO changeLogVO = new ChangeLogVO();
                    changeLogVO.setSource("CAC");
                    changeLogVO.setActionId("update");
                    changeLogVO.setEditUserId(UserUtils.getUserId());
                    changeLogVO.setEditUserName(UserUtils.getUserName());
                    changeLogVO.setEditTime(LocalDateTime.now());
                    changeLogVO.setRemark(String.format("\u8bbe\u5907\u6388\u6743\u7801\u6ce8\u9500[%s]", deviceCode));
                    for (AuthorizationResultVO app : oldAuthApps) {
                        if (!auth.getGoodsCode().equals(app.getCode())) continue;
                        ArrayList changeInfoList = new ArrayList();
                        changeLogVO.setPrimaryKey(app.getPurchaseId());
                        HashMap<String, Object> changeFieldMap = new HashMap<String, Object>();
                        changeFieldMap.put("key", "totalUsage");
                        changeFieldMap.put("displayName", "\u603b\u4f7f\u7528\u6570\u91cf");
                        changeFieldMap.put("originValue", app.getTotalUserCount());
                        changeFieldMap.put("modifyValue", app.getTotalUserCount() - auth.getTotalCount());
                        changeInfoList.add(changeFieldMap);
                        changeLogVO.setChangeInfoList(changeInfoList);
                        break;
                    }
                    if (!changeLogVO.getChangeInfoList().isEmpty()) {
                        changeLogVOS.add(changeLogVO);
                    }
                }
            });
            HttpEntity request = HttpUtil.getHttpEntity(authGoods, (String)userToken);
            this.restTemplate.exchange(uri, HttpMethod.DELETE, request, StdData.class, new Object[0]);
            changeLogVOS.forEach(log -> this.lmcService.saveAuthChangeLogByDealer(log));
        }
        catch (HttpStatusCodeException e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, uri, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.BUSINESS, e.getMessage());
        }
    }

    private void setGoodsStrategy0(OrderVO order, Goods goods) {
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(order.getFirstOrderDetail().getStrategySid().longValue());
        goods.setSellingStrategy(strategy.showJson());
        goods.setOrderNumber(order.getFirstOrderDetail().getQuantity());
        goods.setTotalUsage(strategy.getUseCount());
        goods.setTotalCount(Integer.valueOf(strategy.getUsersNumber() * goods.getOrderNumber()));
    }

    public List<AuthorizationResultVO> queryAuthorization() {
        try {
            ArrayList<AuthorizationResultVO> authorizationResultVOList = new ArrayList<AuthorizationResultVO>();
            if (StrUtils.isNotEmpty((String)this.envProperties.getCacUri())) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/category/app/exclude/policy?pageNum=1&pageSize=0";
                ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[0]);
                Map entityBody = (Map)responseEntity.getBody();
                if (entityBody != null) {
                    String object = objectMapper.writeValueAsString(entityBody.get("list"));
                    List authorizationResultVOS = (List)objectMapper.readValue(object, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    authorizationResultVOList.addAll(authorizationResultVOS);
                }
            } else {
                logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            return authorizationResultVOList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<AuthorizationResultVO>();
        }
    }

    public List<AuthorizationResultVO> queryAllAuthorization(String tenantId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        try {
            List<AuthorizationResultVO> authorizationResultVOList = new ArrayList<AuthorizationResultVO>();
            if (StrUtils.isNotEmpty((String)this.envProperties.getCacUri())) {
                String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId;
                AuthorizationResultVO[] authorizationResultVOS = (AuthorizationResultVO[])this.restTemplate.getForObject(url, AuthorizationResultVO[].class, new Object[0]);
                if (authorizationResultVOS != null && authorizationResultVOS.length > 0) {
                    authorizationResultVOList = Arrays.asList(authorizationResultVOS);
                }
            } else {
                logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            return authorizationResultVOList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<AuthorizationResultVO>();
        }
    }

    public List<AuthorizationResultVO> queryAllAuthorization(List<String> tenantIds, List<String> appIds) {
        try {
            List<Object> authorizationResultVOList = new ArrayList<AuthorizationResultVO>();
            if (!tenantIds.isEmpty()) {
                if (StrUtils.isNotEmpty((String)this.envProperties.getCacUri())) {
                    HashMap<String, Object> requestBody = new HashMap<String, Object>();
                    requestBody.put("tenantIds", tenantIds);
                    requestBody.put("appIds", appIds);
                    requestBody.put("showDetail", true);
                    HttpEntity request = HttpUtil.getHttpEntity(requestBody);
                    String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenant/app/willexpired";
                    StdData result = (StdData)this.restTemplate2.postForObject(url, (Object)request, StdData.class, new Object[0]);
                    if (result != null && result.getData() != null) {
                        authorizationResultVOList = Arrays.asList((Object[])JsonUtils.readValue((String)JsonUtils.writeValue((Object)result.getData()), AuthorizationResultVO[].class));
                    }
                } else {
                    logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
                }
            }
            return authorizationResultVOList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<AuthorizationResultVO>();
        }
    }

    public ResponseResult updateGoodsAndModuleExpiredDateTime(ProductTypeVO productType) {
        ResponseResult responseResult = new ResponseResult(false, "\u505c\u7528\u5e94\u7528\u8fc7\u671f\u65f6\u95f4\u5931\u8d25");
        HttpEntity request = HttpUtil.getHttpEntity((Object)productType);
        String url = this.envProperties.getCacUri() + AUTHORIZATIONS_EXPIRE;
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                responseResult.setSuccess(true);
                responseResult.setMessage("\u505c\u7528\u5e94\u7528\u8fc7\u671f\u65f6\u95f4\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC\u66f4\u65b0\u5e94\u7528\u548c\u6a21\u7ec4\u7684\u8fc7\u671f\u65f6\u95f4\u4e3a\u5f53\u524d\u65f6\u95f4\u5931\u8d25", (String)url, (Object)request.getBody(), (Exception)e));
        }
        return responseResult;
    }

    public Object calculateExpiredDateTime(Long orderSid) {
        try {
            if (StrUtils.isNotEmpty((String)this.envProperties.getCacUri())) {
                HashMap resultMap;
                String uri = String.format("%s%s", this.envProperties.getCacUri(), AUTHORIZATIONS_V4_CALCULATE);
                OrderVO order = this.orderQueryService.getOrderBySid(orderSid.longValue());
                Goods goods = this.goodsMapper.findGoodsBySid(order.getFirstOrderDetail().getGoodsSid().longValue());
                if (goods.getEquip().booleanValue() || GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(goods.getCategoryId())) {
                    return null;
                }
                if (!GoodsCategoryEnum.APP.name().equalsIgnoreCase(goods.getCategoryId())) {
                    goods.setId(order.getOrderCode());
                }
                this.setGoodsStrategy0(order, goods);
                HttpEntity request = HttpUtil.getHttpEntity((Object)goods, (String)this.iamService.getUserToken(order.getTenantId()));
                StdData result = (StdData)this.restTemplate2.postForObject(uri, (Object)request, StdData.class, new Object[0]);
                if (null != result && 200 == result.getCode() && null != result.getData() && null != (resultMap = (HashMap)result.getData()) && resultMap.containsKey("expiredDateTime")) {
                    return resultMap.get("expiredDateTime");
                }
            } else {
                logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception ex) {
            logger.error("CAC\u8ba1\u7b97\u8fc7\u671f\u65f6\u95f4\u51fa\u9519", (Throwable)ex);
        }
        return null;
    }

    public ResponseResult updateExpiredDateTime(ProductTypeVO productType) {
        ResponseResult responseResult = new ResponseResult(false, "\u505c\u7528\u670d\u52a1\u6216\u8005\u8bfe\u7a0b\u7684\u8fc7\u671f\u65f6\u95f4\u5931\u8d25");
        HttpEntity request = HttpUtil.getHttpEntity((Object)productType);
        String url = this.envProperties.getCacUri() + AUTHORIZATIONS_GOODS_EXPIRE;
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                responseResult.setSuccess(true);
                responseResult.setMessage("\u505c\u7528\u670d\u52a1\u6216\u8005\u8bfe\u7a0b\u7684\u8fc7\u671f\u65f6\u95f4\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC\u66f4\u65b0\u670d\u52a1\u8bfe\u7a0b\u8fc7\u671f\u65f6\u95f4\u4e3a\u5f53\u524d\u65f6\u95f4\u5931\u8d25", (String)url, (Object)request.getBody(), (Exception)e), (Throwable)e);
        }
        return responseResult;
    }

    public void syncRecord(PreOrderVO preOrderVO) {
        HttpEntity request = HttpUtil.getHttpEntity((Object)preOrderVO);
        String url = this.envProperties.getCacUri() + SYNC_RECORD;
        try {
            this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC \u540c\u6b65record\u5931\u8d25", (String)url, (Object)request.getBody(), (Exception)e));
        }
    }

    public List<PreOrderReportVO> queryCacRecordCode(PreOrderRelateCodeVO preOrderVO) {
        HttpEntity request = HttpUtil.getHttpEntity((Object)preOrderVO);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/record/relate/code";
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(new ArrayList());
    }

    public AuthorizationResultVO queryAuthorizationByTenantAndApp(String tenantId, String appId) {
        try {
            String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + appId;
            return (AuthorizationResultVO)this.restTemplate.getForObject(url, AuthorizationResultVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new AuthorizationResultVO();
        }
    }
}

