/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.ImportExcelResultVO;
import com.digiwin.dap.middleware.omc.domain.excel.BatchAuthErrorExcel;
import com.digiwin.dap.middleware.omc.domain.excel.BatchAuthExcel;
import com.digiwin.dap.middleware.omc.support.remote.DmcSdkService;
import com.digiwin.dap.middleware.omc.support.remote.impl.BatchAuthExcelListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class DmcSdkServiceImpl
implements DmcSdkService {
    @Autowired
    private DMC dmcClient;
    @Autowired
    private EnvProperties envProperties;

    public List<BatchAuthExcel> getAuthData(String fileId) {
        byte[] bytes;
        try {
            bytes = this.dmcClient.download(fileId);
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
        }
        ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
        BatchAuthExcelListener listener = new BatchAuthExcelListener();
        ExcelReader excelReader = EasyExcel.read((InputStream)fis, BatchAuthExcel.class, (ReadListener)listener).build();
        ReadSheet readSheet = EasyExcel.readSheet((Integer)0).build();
        excelReader.read(new ReadSheet[]{readSheet});
        List batchAuthExcels = listener.getData();
        excelReader.finish();
        try {
            ((InputStream)fis).close();
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
        return batchAuthExcels;
    }

    public void uploadFileAndShare(List<BatchAuthErrorExcel> batchAuthErrorExcels, ImportExcelResultVO importExcelResultVO) {
        if (batchAuthErrorExcels.isEmpty()) {
            return;
        }
        try {
            File file = this.excelWriter(batchAuthErrorExcels);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(file.getName());
            fileInfo.setDisplayName(file.getName());
            fileInfo.setExtension("xlsx");
            fileInfo.setTenantId("99990000");
            String dmcFileId = this.dmcClient.upload(file, fileInfo).getId();
            String shareFileId = this.dmcClient.share(dmcFileId).getUrl();
            importExcelResultVO.setErrorFileUri(shareFileId);
            importExcelResultVO.setErrorFileName(file.getName());
            file.delete();
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff01");
        }
    }

    private File excelWriter(List<BatchAuthErrorExcel> excelErrorUserInfos) throws Exception {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = "authError" + localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/auth_import_template_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/auth_import_template_error_TW.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(excelErrorUserInfos, writeSheet);
        excelWriter.finish();
        return file;
    }

    public String getShareFileId(byte[] bytes, FileInfo fileInfo) {
        try {
            FileInfo file = this.dmcClient.upload(bytes, fileInfo);
            ShareInfo share = this.dmcClient.share(file.getId());
            return share.getUrl();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ShareInfo getShare(byte[] bytes, FileInfo fileInfo) {
        try {
            FileInfo file = this.dmcClient.upload(bytes, fileInfo);
            return this.dmcClient.share(file.getId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

