/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.dwpay.DwPay;
import com.digiwin.dap.middleware.dwpay.model.AlterType;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.dwpay.model.TradeResult;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.pay.dwpay.TradePayReq;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DwPayServiceImpl
implements DwPayService {
    private static final Logger logger = LoggerFactory.getLogger(DwPayServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private DwPay dwPayClient;

    public TradeInfo queryPayInfo(String outTradeNo) {
        try {
            TradeInfo tradeQuery = this.dwPayClient.query("ecdm", outTradeNo, UserUtils.getToken());
            logger.info("\u67e5\u8be2\u4ea4\u6613\u8bb0\u5f55\u7ed3\u679c:{}", (Object)JsonUtils.objToJson((Object)tradeQuery));
            return tradeQuery;
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u4ea4\u6613\u8bb0\u5f55\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public StdData<String> tradePay(String tradeCode, BigDecimal totalAmount, String backUrl, Boolean app) {
        TradePayReq tradePayReq = new TradePayReq();
        tradePayReq.setOutTradeNo(tradeCode);
        tradePayReq.setTotalAmount(totalAmount);
        tradePayReq.setReturnUrl(backUrl);
        tradePayReq.setApp(app);
        tradePayReq.setNotifyUrl(this.envProperties.getOmcUri() + "/api/omc/v2/pay/callback");
        return this.doPay((Object)tradePayReq);
    }

    public StdData<String> queryPeriodPay(String orderCode, String subject, BigDecimal periodAmt, Integer totalPeriods, BigDecimal totalAmount, String backUrl) {
        TradePayReq tradePayReq = new TradePayReq(subject, orderCode);
        tradePayReq.setPeriodAmount(periodAmt);
        tradePayReq.setPeriodTimes(totalPeriods);
        tradePayReq.setTotalAmount(totalAmount);
        tradePayReq.setNotifyUrl(this.envProperties.getOmcUri() + "/api/omc/v2/installment/callback");
        tradePayReq.setReturnUrl(backUrl);
        logger.info("\u67e5\u8be2\u59d4\u6258\u5355\u652f\u4ed8\u94fe\u63a5,\u8bf7\u6c42json:{}", (Object)JsonUtils.objToJson((Object)tradePayReq));
        return this.doPay((Object)tradePayReq);
    }

    private StdData<String> doPay(Object object) {
        TradeResult tradeResult = this.dwPayClient.pay(object, UserUtils.getToken());
        StdData data = StdData.ok().build();
        data.setCode(Integer.valueOf(tradeResult.getCode()));
        data.setSuccess(Boolean.valueOf(tradeResult.isSuccess()));
        data.setMessage(tradeResult.getMessage());
        data.setData(tradeResult.getData());
        return data;
    }

    public StdData<?> stopPay(String outTradeNo, String periodNo) {
        try {
            TradeResult alterStatus = this.dwPayClient.alterStatus("ecdm", outTradeNo, AlterType.terminate, UserUtils.getToken());
            StdData data = StdData.ok().build();
            data.setCode(Integer.valueOf(alterStatus.getCode()));
            data.setSuccess(Boolean.valueOf(alterStatus.isSuccess()));
            data.setMessage(alterStatus.getMessage());
            data.setData(alterStatus.getData());
            return data;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return StdData.of((int)500, (String)"\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8bf7\u6c42\u5931\u8d25");
        }
    }
}

