/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.MultipleItem;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.support.remote.GoodsService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GoodsServiceImpl
implements GoodsService {
    private static final String RECEIVEGOUPON = "/api/gmc/v2/coupon";
    private static final String GOODS_SAVE = "/api/cloudgoods/add/with/strategy";
    private static final Logger logger = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private GoodsMapper goodsMapper;

    public Long receiveCoupon(long couponRuleSid) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, Long> requestContent = new HashMap<String, Long>(1);
            requestContent.put("couponRuleSid", couponRuleSid);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + RECEIVEGOUPON;
            Map map = (Map)this.restTemplate.postForObject(url, (Object)request, Map.class, new Object[0]);
            if (null != map) {
                return map.getOrDefault("myCouponSid", null);
            }
        }
        catch (Exception e) {
            logger.error("\u9886\u53d6\u6211\u7684\u5238\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public void saveGoods(Goods goods) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)goods, (MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + GOODS_SAVE;
            this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            throw new BusinessException("\u521b\u5efa\u5546\u54c1\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean usedForCertifiedTest(long goodsSid) {
        Goods goods = this.goodsMapper.findGoodsBySid(goodsSid);
        return Boolean.TRUE.equals(goods.getCertifyTest());
    }

    @Transactional(rollbackFor={Exception.class})
    public void checkAndCreateStrategy(String strategyCode, GoodsStrategy goodsStrategy) {
        GoodsStrategy existedStragery = this.goodsMapper.findStrategyByCode(strategyCode);
        if (null == existedStragery) {
            try {
                existedStragery = this.goodsMapper.findStrategyBySid(Long.parseLong(strategyCode));
            }
            catch (Exception ex) {
                logger.error("\u9500\u552e\u65b9\u6848\u4e0d\u5b58\u5728{}", (Object)strategyCode);
            }
            if (null == existedStragery) {
                if (null == goodsStrategy) {
                    throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848\u4e0d\u5b58\u5728strategyCode=[%s]", strategyCode));
                }
                existedStragery = goodsStrategy;
                existedStragery.setCreateTime(LocalDateTime.now());
                existedStragery.setCreateUser(UserUtils.getUserId());
                existedStragery.setId(Long.valueOf(SnowFlake.getInstance().newId()));
                existedStragery.setEnabledModulesStr(null == goodsStrategy.getEnabledModules() ? "[]" : JsonUtils.objToJson((Object)goodsStrategy.getEnabledModules()));
                existedStragery.setCustomAttributesStr(null == goodsStrategy.getCustomAttributes() ? "[]" : JsonUtils.objToJson((Object)goodsStrategy.getCustomAttributes()));
                this.goodsMapper.createStrategy(existedStragery);
                MultipleItem multipleItem = new MultipleItem();
                multipleItem.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
                multipleItem.setSellingStrategySid(existedStragery.getId());
                multipleItem.setItemCode(existedStragery.getGoodsCode());
                multipleItem.setItemName(existedStragery.getGoodsCode());
                multipleItem.setApportionType("VARIABLECOST");
                multipleItem.setQuantity(Integer.valueOf(1));
                multipleItem.setUnit("\u5355\u4f4d");
                multipleItem.setUnitPrice(BigDecimal.ZERO);
                multipleItem.setOriginalPrice(BigDecimal.ZERO);
                multipleItem.setContractPrice(BigDecimal.ZERO);
                multipleItem.setStandardPrice(BigDecimal.ZERO);
                multipleItem.setPreset(Boolean.valueOf(false));
                this.goodsMapper.createMultipleItem(multipleItem);
            }
        }
    }
}

