/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.EncryptUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.PreOrderTenantAppVO;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.remote.IamApp;
import com.digiwin.dap.middleware.omc.domain.remote.IsvInfo;
import com.digiwin.dap.middleware.omc.domain.remote.TenantContactInfoVO;
import com.digiwin.dap.middleware.omc.domain.remote.UserContactsVO;
import com.digiwin.dap.middleware.omc.domain.request.IntellyRelationResultVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.util.HttpUtil;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    private static final Logger logger = LoggerFactory.getLogger(IamServiceImpl.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    private static final String PURCHASE_APP = "/api/iam/v2/tenant/application/purchase";
    private static final String PURCHASE_APP_LIST = "/api/iam/v2/tenant/application/purchase/list";
    private static final String TENANT_SIMPLE = "/api/iam/v2/tenant/simple";
    private static final String TENANT_SIMPLES = "/api/iam/v2/tenant/simples";
    private static final String TENANT_CONTACT_INFO = "/api/iam/v2/tenant/contactinfo/";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate2;
    @Autowired
    private DapHttpService dapHttpService;

    public AuthoredUser getUserInfo(String userToken) {
        return this.dapHttpService.getUserInfo(userToken);
    }

    public TenantVO getTenantSimple(String tenantId, long userSid) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, Object> requestContent = new HashMap<String, Object>(1);
            requestContent.put("id", tenantId);
            requestContent.put("sid", userSid);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + TENANT_SIMPLE;
            return (TenantVO)this.restTemplate2.postForObject(url, (Object)request, TenantVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u79df\u6237\u662f\u5426\u662f\u6d4b\u8bd5\u79df\u6237\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public List<CommonVO> getTenantSimples(List<String> tenantIds) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(tenantIds.get(0)));
            HttpEntity request = new HttpEntity(tenantIds, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + TENANT_SIMPLES;
            String result = (String)this.restTemplate2.postForObject(url, (Object)request, String.class, new Object[0]);
            return (List)objectMapper.readValue(result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u8c03\u7528\u3011\u83b7\u53d6\u79df\u6237SID \u9519\u8bef", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Map<String, CommonVO> getTenantSimplesMap(List<String> tenantIds) {
        return this.getTenantSimples(tenantIds).stream().collect(Collectors.toMap(CommonVO::getId, Function.identity(), (k1, k2) -> k1));
    }

    public TenantContactInfoVO getTenantContactInfoVO(String tenantId) {
        Assert.notNull((Object)tenantId, (String)"tenantId is null");
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(tenantId));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            String url = this.envProperties.getIamUri() + TENANT_CONTACT_INFO + tenantId;
            ResponseEntity tenantContactInfoVO = this.restTemplate.exchange(url, HttpMethod.GET, entity, TenantContactInfoVO.class, new Object[0]);
            if (null != tenantContactInfoVO.getBody()) {
                return (TenantContactInfoVO)tenantContactInfoVO.getBody();
            }
            throw new BusinessException("\u83b7\u53d6\u79df\u6237\u7684\u8054\u7cfb\u4eba\u4fe1\u606f\u4e3a\u7a7a");
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6TenantContactInfoVO\u5f02\u5e38", (Throwable)e);
        }
    }

    public String getUserToken(String tenantId) {
        return this.dapHttpService.getUserToken(tenantId);
    }

    public ResponseResult purchaseApp(OrderVO order, String userToken) {
        ResponseResult responseResult = new ResponseResult();
        OrderDetailVO orderDetailVO = order.getFirstOrderDetail();
        if (GoodsCategoryEnum.isApp((String)orderDetailVO.getCategoryId())) {
            responseResult = this.purchaseApp(orderDetailVO.getGoodsCode(), userToken);
        } else {
            responseResult.setSuccess(true);
        }
        return responseResult;
    }

    public ResponseResult purchaseApp(PreOrderVO preOrderVO, String userToken) {
        ResponseResult responseResult = new ResponseResult();
        PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
        if (GoodsCategoryEnum.isApp((String)dtl.getCategoryId())) {
            responseResult = this.purchaseApp(dtl.getGoodsCode(), userToken);
        } else {
            responseResult.setSuccess(true);
        }
        return responseResult;
    }

    public ResponseResult purchaseApp(String goodsCode, String userToken) {
        String errorMessage = CharSequenceUtil.format((CharSequence)"[{}]\u6dfb\u52a0\u6743\u9650\u5931\u8d25", (Object[])new Object[]{goodsCode});
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
            errorMessage = CharSequenceUtil.format((CharSequence)"[{}]\u6dfb\u52a0\u6b0a\u9650\u5931\u6557", (Object[])new Object[]{goodsCode});
        }
        ResponseResult responseResult = new ResponseResult(false, errorMessage);
        String uri = this.envProperties.getIamUri() + PURCHASE_APP;
        HttpEntity request = HttpUtil.getHttpEntity((Object)new IamApp(goodsCode), (String)userToken);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                responseResult.setSuccess(true);
                responseResult.setMessage(String.format("[%s]\u6dfb\u52a0\u6743\u9650\u6210\u529f", goodsCode));
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"IAM\u6dfb\u52a0\u6743\u9650\u8bf7\u6c42\u5931\u8d25", (String)uri, (Object)request.getBody(), (Exception)e), (Throwable)e);
        }
        return responseResult;
    }

    public StdData<?> purchaseApp(List<IamApp> iamApps, String userToken) {
        HttpEntity request = HttpUtil.getHttpEntity(iamApps, (String)userToken);
        String uri = this.envProperties.getIamUri() + PURCHASE_APP_LIST;
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return StdData.ok().build();
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u6dfb\u52a0\u79df\u6237\u5e94\u7528\u5173\u7cfb\u5931\u8d25", (String)uri, (Object)request.getBody(), (Exception)e));
        }
        String collect = iamApps.stream().map(IamApp::getIdFirst).collect(Collectors.joining(","));
        return StdData.of((int)500, (String)String.format("\u6dfb\u52a0\u79df\u6237\u5e94\u7528[%s]\u5173\u7cfb\u5931\u8d25", collect));
    }

    public Map<String, Object> getRowPermission(String userToken) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> requestContent = new HashMap<String, String>(3);
            requestContent.put("sysId", "boss");
            requestContent.put("moduleId", "boss-goods");
            requestContent.put("actionId", "boss-goods-management");
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/permission/data/row";
            ResponseEntity responseEntity = this.restTemplate2.postForEntity(url, (Object)request, Map.class, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public void setAsscRolePermission(long tenantSid, String appId, String backUri) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, Object> requestContent = new HashMap<String, Object>(3);
            requestContent.put("tenantSid", tenantSid);
            requestContent.put("appId", appId);
            requestContent.put("backUri", backUri);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/app/initialize/role/permission";
            this.restTemplate.postForEntity(url, (Object)request, Map.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u552e\u540e\u4e91\u89d2\u8272\u53ca\u529f\u80fd\u6743\u9650\u5931\u8d25", (Throwable)e);
        }
    }

    public UserContactsVO getUserContactsById(String account) {
        String url = String.format("%s/api/iam/v2/user/userid/contacts?account={account}", this.envProperties.getIamUri());
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("account", account);
            ResponseEntity responseEntity = this.restTemplate.getForEntity(url, StdData.class, params);
            StdData stdData = (StdData)responseEntity.getBody();
            if (stdData != null && stdData.getSuccess().booleanValue() && stdData.getData() != null) {
                Map map = (Map)stdData.getData();
                return new UserContactsVO((String)map.get("id"), (String)map.get("telephone"), (String)map.get("email"));
            }
        }
        catch (Exception e) {
            logger.error("IAM\u8bf7\u6c42\u67e5\u8be2\u7528\u6237id\u3001\u624b\u673a\u53f7\u3001\u90ae\u7bb1\u5931\u8d25[account={}]", (Object)account, (Object)e);
        }
        return new UserContactsVO();
    }

    public List<CommonVO> getMultiTestTenants(long tenantSid) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = String.format("%s/api/boss/v1/multi/tenants/%s/subtenants?test=true", this.envProperties.getBossiamUri(), tenantSid);
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, request, StdData.class, new Object[0]);
            StdData resultBody = (StdData)result.getBody();
            if (resultBody != null && resultBody.getSuccess().booleanValue()) {
                List subTenants = (List)resultBody.getData();
                return subTenants;
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d4b\u8bd5\u79df\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public List<PreOrderTenantAppVO> getTenantSecretKey(long tenantSid, List<String> sourceAppIds) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, Object> requestContent = new HashMap<String, Object>(2);
            requestContent.put("tenantSid", tenantSid);
            requestContent.put("appIds", sourceAppIds);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = String.format("%s/api/iam/v2/tenant/query/secretkey", this.envProperties.getIamUri());
            PreOrderTenantAppVO[] result = (PreOrderTenantAppVO[])this.restTemplate2.postForObject(url, (Object)request, PreOrderTenantAppVO[].class, new Object[0]);
            if (result != null && result.length > 0) {
                return Arrays.asList(result);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u6388\u6743\u7801\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public List<String> getTestTenantIds() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = String.format("%s/api/iam/v2/tenant/test/ids", this.envProperties.getIamUri());
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(result).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u6388\u6743\u7801\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public List<CommonVO> getTestTenantInfos() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = String.format("%s/api/iam/v2/tenant/test/infos", this.envProperties.getIamUri());
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(result).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d4b\u8bd5\u79df\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return new ArrayList<CommonVO>();
        }
    }

    public IsvInfo getISVSharePercentage(String servicerId) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> requestContent = new HashMap<String, String>(2);
            requestContent.put("id", servicerId);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = String.format("http://localhost:22611/api/iam/v2/servicer/id", new Object[0]);
            ResponseEntity result = this.restTemplate2.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (null != result && null != result.getBody() && null != ((StdData)result.getBody()).getData()) {
                try {
                    IsvInfo decryptResult = (IsvInfo)EncryptUtils.decrypt((String)this.envProperties.getAppSecret(), (String)JsonUtils.objToJson((Object)((StdData)result.getBody()).getData()), IsvInfo.class);
                    return decryptResult;
                }
                catch (Exception exception) {
                    logger.error("\u89e3\u5bc6\u52a0\u5bc6\u6570\u636e\u5931\u8d25:{}", (Object)JsonUtils.objToJson((Object)result.getBody()), (Object)exception);
                    return (IsvInfo)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)((StdData)result.getBody()).getData()), IsvInfo.class);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u6388\u6743\u7801\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return new IsvInfo();
    }

    public List<IntellyRelationResultVO> getIntellyRelation(List<String> formGroupIds, List<String> tenantIds) {
        if (CollectionUtils.isEmpty(tenantIds)) {
            return new ArrayList<IntellyRelationResultVO>();
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("tenantIds", tenantIds);
            requestBody.put("formGroupIds", formGroupIds);
            requestBody.put("pageSize", 99999);
            requestBody.put("type", "tenant");
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/intelly/relation/search";
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).map(PageSerializable::getList).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u5f62\u6001\u5931\u8d25: formGroupIds={}, tenantIds={}", new Object[]{formGroupIds, tenantIds, e});
            return Collections.emptyList();
        }
    }
}

