/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.lmc.internal.model.entity.ChangeInfo;
import com.digiwin.dap.middleware.lmc.request.SaveOpLog;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.changelog.ModifiedInfoDTO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.LmcService;
import com.digiwin.dap.middleware.omc.support.tsign.domain.ChangeLogVO;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LmcServiceImpl
implements LmcService {
    private static final Logger logger = LoggerFactory.getLogger(LmcServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private IamService iamService;
    private static final String DIGIWINCLOUD_USERNAME = "digiwincloud";
    private static final String DIGIWINCLOUD_PASSWORD_HASH = "0605k3by2cDZt0feVzZhEOTnUZ+iEpYSt6I8Np/TURc=";
    private static final String DIGIWINCLOUD_BUCKET_NAME = "digiwincloud";
    private static final String CHANGE_LOGS = "/api/lmc/v1/buckets/%s/changelogs";
    private static final String CHANGE_LOGS_RESULT = "/api/lmc/v1/buckets/%s/changelogs/result";

    public void dataComparison(ModifiedInfoDTO dto, String userToken, String tenantId) {
        this.dataComparison(dto, userToken, tenantId, "digiwincloud");
    }

    public void dataComparison(ModifiedInfoDTO dto, String userToken, String tenantId, String bucket) {
        Object logRequest = null;
        String url = "";
        try {
            if (StrUtils.isEmpty((String)userToken) && StrUtils.isEmpty((String)tenantId)) {
                return;
            }
            if (StrUtils.isEmpty((String)userToken)) {
                userToken = this.iamService.getUserToken(tenantId);
            }
            if (StrUtils.isEmpty((String)userToken)) {
                return;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json;charset=UTF-8");
            headers.add("digi-middleware-auth-user", userToken);
            logRequest = new HttpEntity((Object)dto, (MultiValueMap)headers);
            url = this.envProperties.getLmcUri() + String.format(CHANGE_LOGS, bucket);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, logRequest, Object.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (String)url, (Object)(logRequest == null ? logRequest : logRequest.getBody()), (Exception)e), (Throwable)e);
        }
    }

    public void saveAuthChangeLogByDealer(ChangeLogVO changeLogVO) {
        HttpEntity logRequest = null;
        String url = "";
        if (StrUtils.isEmpty((String)this.envProperties.getLmcUri())) {
            logger.error("\u3010LMC\u3011 \u8fde\u63a5\u5730\u5740\u4e3a\u7a7a");
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add("digi-middleware-auth-user", UserUtils.getToken());
        logRequest = new HttpEntity((Object)changeLogVO, (MultiValueMap)headers);
        url = this.envProperties.getLmcUri() + String.format(CHANGE_LOGS_RESULT, "digiwincloud");
        this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]);
    }

    public void logObsoletePreOrder(List<PreOrderDetailVO> authGoodsList) {
        SaveOpLog log = new SaveOpLog();
        log.setAppId("digiwincloud");
        log.setModuleId("boss-void-authorize");
        log.setActId("action_voidAuthorize");
        log.setEditPlace("\u8d44\u7ba1\u8c03\u7528\u63a5\u53e3");
        log.setEditUserId(UserUtils.getUserId());
        log.setEditUserName(UserUtils.getUserName());
        log.setOperationType("update");
        log.setActionId("tenant.voidAuthorize");
        log.setPrimaryKey(UserUtils.getUserId());
        log.setPrimaryName(UserUtils.getUserName());
        log.setTenantId(UserUtils.getTenantId());
        log.setTenantName(UserUtils.getTenantName());
        ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>();
        log.setChangeInfoList(changeInfos);
        for (PreOrderDetailVO item : authGoodsList) {
            ChangeInfo info = new ChangeInfo();
            info.setKey("voidAuthorize");
            info.setDisplayName("\u4f5c\u5e9f");
            info.setType("void");
            info.setModifyValue(item.getPreOrderCode());
            changeInfos.add(info);
        }
        HttpEntity logRequest = null;
        String url = "";
        if (StrUtils.isEmpty((String)this.envProperties.getLmcUri())) {
            logger.error("\u3010LMC\u3011 \u8fde\u63a5\u5730\u5740\u4e3a\u7a7a");
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add("digi-middleware-auth-user", UserUtils.getToken());
        logRequest = new HttpEntity((Object)log, (MultiValueMap)headers);
        url = this.envProperties.getLmcUri() + String.format(CHANGE_LOGS_RESULT, "digiwincloud");
        this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]);
    }
}

