/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsPaymentEnum;
import com.digiwin.dap.middleware.omc.constant.enums.InvoiceTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.MailTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.dao.BnplOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.InstallmentOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCouponCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.domain.DealerOrderVO;
import com.digiwin.dap.middleware.omc.domain.DeviceCloudExpiredNoticeDTO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.OrderAuthManualMessage;
import com.digiwin.dap.middleware.omc.domain.OrderCloudDeviceBatchMessage;
import com.digiwin.dap.middleware.omc.domain.OrderCloudDeviceMessage;
import com.digiwin.dap.middleware.omc.domain.PackOrderVO;
import com.digiwin.dap.middleware.omc.domain.ShoppingCartMessage;
import com.digiwin.dap.middleware.omc.domain.ShoppingCartOrderVO;
import com.digiwin.dap.middleware.omc.domain.bill.dto.BillOverdueNoticeDTO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderMailVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.dto.NoticeBnplEntrustOrderDTO;
import com.digiwin.dap.middleware.omc.domain.mail.BorrowNoticeVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.remote.FinanceTossOrderInfo;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsOrderMessage;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsToEnableMessageVO;
import com.digiwin.dap.middleware.omc.domain.remote.MailDealerOrder;
import com.digiwin.dap.middleware.omc.domain.remote.MailFinance;
import com.digiwin.dap.middleware.omc.domain.remote.MailGoodsDetail;
import com.digiwin.dap.middleware.omc.domain.remote.MailOrder;
import com.digiwin.dap.middleware.omc.domain.remote.TenantContactInfoVO;
import com.digiwin.dap.middleware.omc.domain.remote.UserContactsVO;
import com.digiwin.dap.middleware.omc.domain.request.DeviceExpiringVO;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderCallbackVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceDbMessageVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderPromotionMixVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.request.ResendMailVO;
import com.digiwin.dap.middleware.omc.domain.response.OrderDetailResult;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ServicerOrderDetailVO;
import com.digiwin.dap.middleware.omc.entity.BnplOrder;
import com.digiwin.dap.middleware.omc.entity.InstallmentOrder;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.entity.OrderCoupon;
import com.digiwin.dap.middleware.omc.entity.OrderDetail;
import com.digiwin.dap.middleware.omc.entity.PreOrderDetail;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.MailDataMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderSyncMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.repository.PreOrderDetailRepository;
import com.digiwin.dap.middleware.omc.repository.PreOrderRepository;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.schedule.PreOrderContext;
import com.digiwin.dap.middleware.omc.support.schedule.PreOrderParameters;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MailServiceImpl
implements MailService {
    private static final Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrderSyncMapper orderSyncMapper;
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private OrderCouponCrudService orderCouponCrudService;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private MailDataMapper mailDataMapper;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private PreOrderService preOrderService;
    @Autowired
    private PreOrderRepository preOrderRepository;
    @Autowired
    private PreOrderDetailRepository preOrderDetailRepository;
    @Autowired
    private InstallmentOrderCrudService installmentOrderCrudService;
    @Autowired
    private BnplOrderCrudService bnplOrderCrudService;
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void sendEmailSubmitOrder(long orderSid) {
        this.sendEmail(orderSid, MailTypeEnum.OMC_ORDER_SUBMIT);
    }

    public void sendEmailPaySuccess(long orderSid) {
        this.sendEmail(orderSid, MailTypeEnum.OMC_ORDER_PAY_SUCCESS);
    }

    public void sendEmailSubmitShoppingCartOrder(long orderSid) {
        this.sendShoppingCartEmail(orderSid, MailTypeEnum.OMC_SHOPPING_CART_SUBMIT);
    }

    public void sendEmailSubmitPackOrderToPM(long orderSid) {
        this.sendShoppingCartEmail(orderSid, MailTypeEnum.OMC_PACK_ORDER_SUBMIT_PM);
    }

    public void sendEmailShoppingCartPaySuccess(long orderSid) {
        this.sendShoppingCartEmail(orderSid, MailTypeEnum.OMC_SHOPPING_CART_ORDER_PAY);
    }

    public void sendEmailPackOrderPaySuccessToPM(long orderSid) {
        this.sendShoppingCartEmail(orderSid, MailTypeEnum.OMC_PACK_ORDER_PAY_PM);
    }

    public void sendEmailSubmitShoppingCartOrderToPm(long orderSid) {
        this.sendEmail(orderSid, MailTypeEnum.OMC_SHOPPING_CART_SUBMIT_PM);
    }

    public void sendEmailShoppingCartPaySuccessToPm(long orderSid) {
        this.sendEmail(orderSid, MailTypeEnum.OMC_SHOPPING_CART_ORDER_PAY_PM);
    }

    public void mailResend(ResendMailVO resendMailVO) {
        Order order = (Order)this.orderCrudService.findBySid(resendMailVO.getSid().longValue());
        if (order == null) {
            throw new BusinessException(String.format("\u8ba2\u5355[%s]\u4e0d\u5b58\u5728", resendMailVO.getSid()));
        }
        if (resendMailVO.getMailTypeEnum().equals((Object)MailTypeEnum.OMC_SHOPPING_CART_SUBMIT)) {
            this.sendEmailSubmitShoppingCartOrder(order.getSid());
            List sids = this.orderRepository.getOrderSidsByCartCode(order.getCartCode());
            for (Long sid : sids) {
                this.sendEmailSubmitShoppingCartOrderToPm(sid.longValue());
            }
        } else if (resendMailVO.getMailTypeEnum().equals((Object)MailTypeEnum.OMC_SHOPPING_CART_ORDER_PAY)) {
            this.sendEmailShoppingCartPaySuccess(order.getSid());
            List sids = this.orderRepository.getOrderSidsByCartCode(order.getCartCode());
            for (Long sid : sids) {
                this.sendEmailShoppingCartPaySuccessToPm(sid.longValue());
            }
        } else {
            this.sendEmail(order.getSid(), resendMailVO.getMailTypeEnum());
        }
    }

    public void sendEmailAuthFail(long orderSid, String errMsg) {
        this.sendEmail(orderSid, MailTypeEnum.OMC_ORDER_AUTH_FAIL, errMsg);
    }

    public void sendEmailInitFail(long orderSid, String errMsg) {
        this.sendEmail(orderSid, MailTypeEnum.OMC_ORDER_INIT_FAIL, errMsg);
    }

    public void sendTossSuccess(long orderSid) {
        this.sendTossOrder(orderSid, MailTypeEnum.OMC_ORDER_TOSS_SUCCESS);
    }

    public void sendTossFail(Order order, String errorMsg) {
        try {
            HashMap<String, String> tossFailInfo = new HashMap<String, String>();
            if (StrUtils.isNotEmpty((String)order.getGoodsCode())) {
                tossFailInfo.put("code", order.getGoodsCode());
            }
            tossFailInfo.put("orderCode", order.getOrderCode());
            tossFailInfo.put("errorMsg", errorMsg);
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(MailTypeEnum.OMC_ORDER_TOSS_FAIL.name());
            orderMessage.setData(tossFailInfo);
            this.producerService.msg(orderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u8ba2\u5355sid[%s]", order.getSid()), (Throwable)e);
        }
    }

    public void sendTossOverPeriod(LocalDateTime startTime, LocalDateTime endTime) {
        try {
            List orderInfoList = this.getOrdersOverPeriod(startTime, endTime);
            if (orderInfoList.size() > 0) {
                HashMap<String, List> orderInfoMap = new HashMap<String, List>(1);
                orderInfoMap.put("orderList", orderInfoList);
                MessageBody orderMessage = new MessageBody();
                orderMessage.setOpType(MailTypeEnum.OMC_ORDER_LIST_TOSS_SUCCESS.name());
                orderMessage.setData(orderInfoMap);
                this.producerService.msg(orderMessage);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001[%s]\u5230[%s]\u65f6\u6bb5\u5185\u7684\u8ba2\u5355\u4fe1\u606f\u90ae\u4ef6\u5931\u8d25!", startTime, endTime), (Throwable)e);
        }
    }

    public void sendGoodsToEnableEmail(LocalDate searchTime) {
        try {
            List goodsToEnableMessageVOS = this.orderMapper.getGoodsToEnableMessageVO(searchTime);
            if (goodsToEnableMessageVOS.size() > 0) {
                for (GoodsToEnableMessageVO goodsToEnableMessageVO : goodsToEnableMessageVOS) {
                    AuthorizationVO authorizationVos;
                    TenantContactInfoVO tenantContactInfoVO = this.iamService.getTenantContactInfoVO(goodsToEnableMessageVO.getTenantId());
                    if (tenantContactInfoVO != null) {
                        BeanUtils.copyProperties((Object)tenantContactInfoVO, (Object)goodsToEnableMessageVO);
                    }
                    if ((authorizationVos = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(goodsToEnableMessageVO.getTenantId(), goodsToEnableMessageVO.getCode())) != null) {
                        BeanUtils.copyProperties((Object)authorizationVos, (Object)goodsToEnableMessageVO);
                    }
                    MessageBody orderMessage = new MessageBody();
                    orderMessage.setOpType(MailTypeEnum.OMC_GOODS_TO_ENABLE.name());
                    orderMessage.setData((Object)goodsToEnableMessageVO);
                    this.producerService.msg(orderMessage);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("[%s]\u53d1\u9001\u4ea7\u54c1\u5f00\u901a\u65e5\u901a\u77e5\u90ae\u4ef6\u5931\u8d25", LocalDateTime.now()), (Throwable)e);
        }
    }

    public void sendGoodsByOrderSidToEnableEmail(long orderSid) {
        try {
            LocalDate searchTime = LocalDate.now();
            GoodsToEnableMessageVO goodsToEnableMessageVO = this.orderMapper.getGoodsToEnableMessageVOByOrderCode(orderSid, searchTime);
            if (goodsToEnableMessageVO != null) {
                AuthorizationVO authorizationVos;
                TenantContactInfoVO tenantContactInfoVO = this.iamService.getTenantContactInfoVO(goodsToEnableMessageVO.getTenantId());
                if (tenantContactInfoVO != null) {
                    BeanUtils.copyProperties((Object)tenantContactInfoVO, (Object)goodsToEnableMessageVO);
                }
                if ((authorizationVos = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(goodsToEnableMessageVO.getTenantId(), goodsToEnableMessageVO.getCode())) != null) {
                    BeanUtils.copyProperties((Object)authorizationVos, (Object)goodsToEnableMessageVO);
                }
                MessageBody orderMessage = new MessageBody();
                orderMessage.setOpType(MailTypeEnum.OMC_GOODS_TO_ENABLE.name());
                orderMessage.setData((Object)goodsToEnableMessageVO);
                this.producerService.msg(orderMessage);
            }
        }
        catch (Exception e) {
            logger.error(String.format("[%s]\u53d1\u9001\u4ea7\u54c1\u5f00\u901a\u65e5\u901a\u77e5\u90ae\u4ef6\u5931\u8d25", LocalDateTime.now()), (Throwable)e);
        }
    }

    private void sendEmail(long orderSid, MailTypeEnum opType) {
        this.sendEmail(orderSid, opType, null);
    }

    private void sendShoppingCartEmail(long orderSid, MailTypeEnum opType) {
        try {
            ShoppingCartMessage shoppingCartMessage = this.orderSyncMapper.findShoppingCartMailOrder(orderSid);
            if (shoppingCartMessage != null) {
                List shoppingCartOrderVos = this.orderSyncMapper.findShoppingCartOrders(shoppingCartMessage.getCartCode());
                for (ShoppingCartOrderVO shoppingCartOrderVO : shoppingCartOrderVos) {
                    List orderCoupons = this.orderCouponCrudService.findByOrderSid(shoppingCartOrderVO.getSid().longValue());
                    if (!orderCoupons.isEmpty()) {
                        shoppingCartOrderVO.setCoupon((OrderCoupon)orderCoupons.get(0));
                    }
                    OrderPromotionMixVO orderPromotionMixVO = this.orderDetailMapper.findOrderPromotionMix(shoppingCartOrderVO.getSid().longValue());
                    shoppingCartOrderVO.setOrderPromotionMixVO(orderPromotionMixVO);
                }
                BnplOrder bnplOrder = this.bnplOrderCrudService.findByOrderSid(((ShoppingCartOrderVO)shoppingCartOrderVos.get(0)).getSid());
                if (bnplOrder != null) {
                    shoppingCartMessage.setBnpl(Boolean.valueOf(true));
                    shoppingCartMessage.setUnpaidCount(Integer.valueOf(bnplOrder.getTotalCount() - bnplOrder.getPaidCount()));
                    if (bnplOrder.getNextBillDate() != null) {
                        shoppingCartMessage.setBillDay(Integer.valueOf(bnplOrder.getNextBillDate().getDayOfMonth()));
                    }
                    shoppingCartMessage.setAmount(bnplOrder.getAmount());
                }
                shoppingCartMessage.setShoppingCartOrder(shoppingCartOrderVos);
                MessageBody orderMessage = new MessageBody();
                orderMessage.setOpType(opType.name());
                orderMessage.setData((Object)shoppingCartMessage);
                this.producerService.msg(orderMessage);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u8ba2\u5355sid[%s]", orderSid), (Throwable)e);
        }
    }

    private void sendEmail(long orderSid, MailTypeEnum opType, String errMsg) {
        try {
            MailOrder data = this.getMailOrder(orderSid);
            if (null != errMsg) {
                data.setRemark(errMsg);
            }
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(opType.name());
            orderMessage.setData((Object)data);
            this.producerService.msg(orderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u8ba2\u5355sid[%s]", orderSid), (Throwable)e);
        }
    }

    private void sendTossOrder(long orderSid, MailTypeEnum opType) {
        try {
            MailFinance mailFinance = this.getTossOrder(orderSid);
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(opType.name());
            orderMessage.setData((Object)mailFinance);
            this.producerService.msg(orderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u8ba2\u5355sid[%s]", orderSid), (Throwable)e);
        }
    }

    private MailFinance getTossOrder(long orderSid) {
        MailFinance mailFinance = this.orderSyncMapper.findUnTossedOrderByOrderSid(orderSid);
        mailFinance.setInvoiceType(InvoiceTypeEnum.getName((String)mailFinance.getInvoiceType()));
        List mailFinanceDetails = this.orderSyncMapper.findUnTossedOrderDetailByOrderSid(orderSid);
        mailFinanceDetails.forEach(o -> {
            double unitPrice;
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
                unitPrice = o.getNoTaxPrice() / (double)o.getQuantity().intValue();
                o.setTotalPrice(o.getNoTaxPrice());
            } else {
                unitPrice = o.getTotalPrice() / (double)o.getQuantity().intValue();
                o.setTotalPrice(o.getTotalPrice());
            }
            BigDecimal bg = BigDecimal.valueOf(unitPrice);
            unitPrice = bg.setScale(2, 6).doubleValue();
            o.setUnitPrice(unitPrice);
        });
        mailFinance.setItemDetails(mailFinanceDetails);
        return mailFinance;
    }

    public MailOrder getMailOrder(long orderSid) {
        InstallmentOrder originalOrder;
        OrderPromotionMixVO orderPromotionMixVO;
        List orderCoupons;
        MailOrder mailOrder = this.orderSyncMapper.findMailOrder(orderSid);
        List orderDetails = this.orderDetailCrudService.findByOrderSid(orderSid);
        if (!orderDetails.isEmpty()) {
            OrderDetail orderDetail = (OrderDetail)orderDetails.get(0);
            mailOrder.setGoodsSid(orderDetail.getGoodsSid());
            mailOrder.setGoodsCode(orderDetail.getGoodsCode());
            mailOrder.setCode(orderDetail.getGoodsCode());
            mailOrder.setGoodsName(orderDetail.getGoodsName());
            mailOrder.setPayRemark(orderDetail.getPayRemark());
            GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(orderDetail.getStrategySid().longValue());
            if (null != strategy) {
                mailOrder.setStrategySid(strategy.getId());
                mailOrder.setStrategyName(strategy.getName());
            }
            mailOrder.setQuantity(orderDetail.getQuantity());
            mailOrder.setUnitPrice(orderDetail.getUnitPrice());
        }
        if (!(orderCoupons = this.orderCouponCrudService.findByOrderSid(orderSid)).isEmpty()) {
            mailOrder.setCoupon((OrderCoupon)orderCoupons.get(0));
        }
        if ((orderPromotionMixVO = this.orderDetailMapper.findOrderPromotionMix(orderSid)) != null) {
            mailOrder.setOrderPromotionMixVO(orderPromotionMixVO);
        }
        if (!Objects.isNull(originalOrder = this.installmentOrderCrudService.findByOrderSid(mailOrder.getOrderSid()))) {
            mailOrder.setPeriodOriginalOrder(Boolean.valueOf(true));
            mailOrder.setPeriodBaseOrderCode(originalOrder.getOrderCode());
            mailOrder.setPeriodTotalTimes(originalOrder.getTotalPeriods());
            mailOrder.setPeriodAlreadyTimes(Integer.valueOf(1));
        } else if (StringUtils.hasText((String)mailOrder.getPeriodNo())) {
            InstallmentOrder installmentOrder = this.installmentOrderCrudService.findByPeriodNo(mailOrder.getPeriodNo());
            Optional.ofNullable(installmentOrder).ifPresent(o -> {
                if (!Objects.equals(o.getOrderSid(), orderSid)) {
                    mailOrder.setPeriodSubOrder(Boolean.valueOf(true));
                    mailOrder.setPeriodBaseOrderCode(installmentOrder.getOrderCode());
                    mailOrder.setPeriodTotalTimes(installmentOrder.getTotalPeriods());
                    mailOrder.setPeriodAlreadyTimes(installmentOrder.getPaidPeriods());
                }
            });
        }
        BnplOrder bnplOrder = this.bnplOrderCrudService.findByOrderSid(mailOrder.getOrderSid());
        if (bnplOrder != null) {
            mailOrder.setBnpl(Boolean.valueOf(true));
            mailOrder.setUnpaidCount(Integer.valueOf(bnplOrder.getTotalCount() - bnplOrder.getPaidCount()));
            if (bnplOrder.getNextBillDate() != null) {
                mailOrder.setBillDay(Integer.valueOf(bnplOrder.getNextBillDate().getDayOfMonth()));
            }
            mailOrder.setAmount(bnplOrder.getAmount().setScale(2, RoundingMode.HALF_UP).toString());
        }
        return mailOrder;
    }

    private List<FinanceTossOrderInfo> getOrdersOverPeriod(LocalDateTime startTime, LocalDateTime endTime) {
        String startTimeStr = dateTimeFormatter.format(startTime);
        String endTimeStr = dateTimeFormatter.format(endTime);
        List orderInfoList = this.orderSyncMapper.findTossOrdersOverPeriod(startTimeStr, endTimeStr);
        orderInfoList.forEach(o -> {
            double unitPrice;
            o.setInvoiceType(InvoiceTypeEnum.getName((String)o.getInvoiceType()));
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
                unitPrice = o.getNoTaxPrice() / (double)o.getQuantity().intValue();
                o.setTotalPrice(o.getNoTaxPrice());
            } else {
                unitPrice = o.getTotalPrice() / (double)o.getQuantity().intValue();
                o.setTotalPrice(o.getTotalPrice());
            }
            BigDecimal bg = BigDecimal.valueOf(unitPrice);
            unitPrice = bg.setScale(2, 6).doubleValue();
            o.setUnitPrice(unitPrice);
        });
        return orderInfoList;
    }

    public void sendEmailDealerOrderSuccess(DealerOrderVO dealerOrderVO) {
        try {
            MailDealerOrder mailDealerOrder = new MailDealerOrder();
            mailDealerOrder.setAuthCode(dealerOrderVO.getAuthCode());
            mailDealerOrder.setBeginDate(dateFormatter.format(dealerOrderVO.getAuthData().getBeginDate()));
            mailDealerOrder.setEndDate(dateFormatter.format(dealerOrderVO.getAuthData().getEndDate()));
            mailDealerOrder.setTenantEmail(dealerOrderVO.getOrder().getEmail());
            mailDealerOrder.setEmail(dealerOrderVO.getAuthEmail());
            mailDealerOrder.setTelephone(dealerOrderVO.getOrder().getTelephone());
            mailDealerOrder.setTenantId(dealerOrderVO.getOrder().getTenantId());
            mailDealerOrder.setTenantName(dealerOrderVO.getOrder().getTenantName());
            mailDealerOrder.setUserId(dealerOrderVO.getOrder().getUserId());
            mailDealerOrder.setUserName(dealerOrderVO.getOrder().getUserName());
            mailDealerOrder.setOrderDetailVOList(dealerOrderVO.getOrderDetails());
            MessageBody mailDealerOrderOrderMessage = new MessageBody();
            mailDealerOrderOrderMessage.setOpType(MailTypeEnum.OMC_DEALER_SUCCESS.name());
            mailDealerOrderOrderMessage.setData((Object)mailDealerOrder);
            this.producerService.msg(mailDealerOrderOrderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u6388\u6743\u7801[%s]", dealerOrderVO.getAuthCode()), (Throwable)e);
        }
    }

    public void sendEmailDealerOrderFail(DealerOrderVO dealerOrderVO, String errMsg) {
        try {
            MailDealerOrder mailDealerOrder = new MailDealerOrder();
            if (null != errMsg) {
                mailDealerOrder.setErrMsg(errMsg);
            }
            mailDealerOrder.setAuthCode(dealerOrderVO.getAuthCode());
            mailDealerOrder.setBeginDate(dateFormatter.format(dealerOrderVO.getAuthData().getBeginDate()));
            mailDealerOrder.setEndDate(dateFormatter.format(dealerOrderVO.getAuthData().getEndDate()));
            mailDealerOrder.setTenantEmail(dealerOrderVO.getOrder().getEmail());
            mailDealerOrder.setEmail(dealerOrderVO.getAuthEmail());
            mailDealerOrder.setTelephone(dealerOrderVO.getOrder().getTelephone());
            mailDealerOrder.setTenantId(dealerOrderVO.getOrder().getTenantId());
            mailDealerOrder.setTenantName(dealerOrderVO.getOrder().getTenantName());
            mailDealerOrder.setUserId(dealerOrderVO.getOrder().getUserId());
            mailDealerOrder.setUserName(dealerOrderVO.getOrder().getUserName());
            mailDealerOrder.setOrderDetailVOList(dealerOrderVO.getOrderDetails());
            MessageBody mailDealerOrderOrderMessage = new MessageBody();
            mailDealerOrderOrderMessage.setOpType(MailTypeEnum.OMC_DEALER_FAIL.name());
            mailDealerOrderOrderMessage.setData((Object)mailDealerOrder);
            this.producerService.msg(mailDealerOrderOrderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u6388\u6743\u7801[%s]", dealerOrderVO.getAuthCode()), (Throwable)e);
        }
    }

    public void sendEmailDealerOrderSuccessToPm(DealerOrderVO dealerOrderVO) {
        try {
            for (OrderDetailVO orderDetailVO : dealerOrderVO.getOrderDetails()) {
                MailDealerOrder mailDealerOrder = new MailDealerOrder();
                mailDealerOrder.setCode(orderDetailVO.getGoodsCode());
                mailDealerOrder.setAuthCode(dealerOrderVO.getAuthCode());
                mailDealerOrder.setBeginDate(dateFormatter.format(dealerOrderVO.getAuthData().getBeginDate()));
                mailDealerOrder.setEndDate(dateFormatter.format(dealerOrderVO.getAuthData().getEndDate()));
                mailDealerOrder.setTenantEmail(dealerOrderVO.getOrder().getEmail());
                mailDealerOrder.setEmail(dealerOrderVO.getAuthEmail());
                mailDealerOrder.setTelephone(dealerOrderVO.getOrder().getTelephone());
                mailDealerOrder.setTenantId(dealerOrderVO.getOrder().getTenantId());
                mailDealerOrder.setTenantName(dealerOrderVO.getOrder().getTenantName());
                mailDealerOrder.setUserId(dealerOrderVO.getOrder().getUserId());
                mailDealerOrder.setUserName(dealerOrderVO.getOrder().getUserName());
                ArrayList<OrderDetailVO> orderDetailVOList = new ArrayList<OrderDetailVO>();
                orderDetailVOList.add(orderDetailVO);
                mailDealerOrder.setOrderDetailVOList(orderDetailVOList);
                MessageBody mailDealerOrderOrderMessage = new MessageBody();
                mailDealerOrderOrderMessage.setOpType(MailTypeEnum.OMC_DEALER_SUCCESS_PM.name());
                mailDealerOrderOrderMessage.setData((Object)mailDealerOrder);
                this.producerService.msg(mailDealerOrderOrderMessage);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u6388\u6743\u7801[%s]", dealerOrderVO.getAuthCode()), (Throwable)e);
        }
    }

    public void sendEmailDealerOrderFailToPm(DealerOrderVO dealerOrderVO, OrderDetailVO orderDetailVO, String errMsg) {
        try {
            MailDealerOrder mailDealerOrder = new MailDealerOrder();
            if (null != errMsg) {
                mailDealerOrder.setErrMsg(errMsg);
            }
            mailDealerOrder.setCode(orderDetailVO.getGoodsCode());
            mailDealerOrder.setAuthCode(dealerOrderVO.getAuthCode());
            mailDealerOrder.setBeginDate(dateFormatter.format(dealerOrderVO.getAuthData().getBeginDate()));
            mailDealerOrder.setEndDate(dateFormatter.format(dealerOrderVO.getAuthData().getEndDate()));
            mailDealerOrder.setTenantEmail(dealerOrderVO.getOrder().getEmail());
            mailDealerOrder.setEmail(dealerOrderVO.getAuthEmail());
            mailDealerOrder.setTelephone(dealerOrderVO.getOrder().getTelephone());
            mailDealerOrder.setTenantId(dealerOrderVO.getOrder().getTenantId());
            mailDealerOrder.setTenantName(dealerOrderVO.getOrder().getTenantName());
            mailDealerOrder.setUserId(dealerOrderVO.getOrder().getUserId());
            mailDealerOrder.setUserName(dealerOrderVO.getOrder().getUserName());
            ArrayList<OrderDetailVO> orderDetailVOList = new ArrayList<OrderDetailVO>();
            orderDetailVOList.add(orderDetailVO);
            mailDealerOrder.setOrderDetailVOList(orderDetailVOList);
            MessageBody mailDealerOrderOrderMessage = new MessageBody();
            mailDealerOrderOrderMessage.setOpType(MailTypeEnum.OMC_DEALER_FAIL_PM.name());
            mailDealerOrderOrderMessage.setData((Object)mailDealerOrder);
            this.producerService.msg(mailDealerOrderOrderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u6388\u6743\u7801[%s]", dealerOrderVO.getAuthCode()), (Throwable)e);
        }
    }

    public void sendEmailCancelOrder(MailOrder mailOrder) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_ORDER_CANCEL.name());
        orderMessage.setData((Object)mailOrder);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailCancelOrder4Customer(MailOrder mailOrder) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_ORDER_CANCEL_CUSTOMER.name());
        orderMessage.setData((Object)mailOrder);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailReduceU(Map<String, Object> map) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_REDUCE_U_COUNT_PM.name());
        orderMessage.setData(map);
        this.producerService.msg(orderMessage);
    }

    public void sendGoodsToEnableEmail(PreOrderVO preOrderVO) {
        try {
            Goods goods;
            PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
            GoodsToEnableMessageVO vo = new GoodsToEnableMessageVO();
            TenantContactInfoVO tenantContactInfoVO = this.iamService.getTenantContactInfoVO(preOrderVO.getTenantId());
            if (tenantContactInfoVO != null) {
                BeanUtils.copyProperties((Object)tenantContactInfoVO, (Object)vo);
            }
            boolean outUserCount = false;
            AuthorizationVO authorizationVos = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(preOrderVO.getTenantId(), dtl.getGoodsCode());
            if (authorizationVos != null) {
                BeanUtils.copyProperties((Object)authorizationVos, (Object)vo);
                boolean bl = outUserCount = authorizationVos.getPaymentType() == GoodsPaymentEnum.PersonMonth.ordinal() && authorizationVos.getUserCount() > authorizationVos.getTotalUserCount();
            }
            if ((goods = this.goodsMapper.findGoodsByCode(dtl.getGoodsCode())) != null) {
                vo.setPayRemark(goods.getPayRemark());
            }
            vo.setOrderCode(preOrderVO.getOrderCode());
            vo.setTenantId(preOrderVO.getTenantId());
            vo.setComment(outUserCount ? preOrderVO.getComment() + "  " + I18nCode.CODE_10017.getMessage() : preOrderVO.getComment());
            vo.setRemark(preOrderVO.getRemark());
            vo.setAuthorizationDate(dtl.getEffectiveDateTime());
            vo.setCode(dtl.getGoodsCode());
            vo.setGoodsName(dtl.getGoodsName());
            vo.setQuantity(dtl.getTotalUsageBound());
            vo.setStrategyName(dtl.getStrategyName());
            vo.setTenantName(preOrderVO.getTenantName());
            vo.setEmail(preOrderVO.getEmails());
            vo.setOrderSource(OrderSourceEnum.BossManualAuthorization.name());
            vo.setList(vo.generateList(vo));
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(MailTypeEnum.OMC_GOODS_TO_ENABLE.name());
            orderMessage.setData((Object)vo);
            boolean mergeMail = Optional.ofNullable(PreOrderContext.get()).map(PreOrderParameters::isMergeMail).orElse(false);
            if (mergeMail) {
                PreOrderContext.get().addMail(vo);
            } else {
                this.producerService.msg(orderMessage);
            }
        }
        catch (Exception e) {
            logger.error(String.format("[%s]\u53d1\u9001\u4ea7\u54c1\u5f00\u901a\u65e5\u901a\u77e5\u90ae\u4ef6\u5931\u8d25", LocalDateTime.now()), (Throwable)e);
        }
    }

    public void sendGoodsToEnableEmailMerged(List<GoodsToEnableMessageVO> mails) {
        if (CollectionUtils.isEmpty(mails)) {
            return;
        }
        GoodsToEnableMessageVO main = mails.get(0);
        main.setEmail(mails.stream().map(GoodsToEnableMessageVO::getEmail).filter(StringUtils::hasLength).distinct().collect(Collectors.joining(";")));
        main.setOrderCode(mails.stream().map(GoodsToEnableMessageVO::getOrderCode).filter(StringUtils::hasLength).distinct().collect(Collectors.joining(";")));
        main.setPayRemark(mails.stream().map(GoodsToEnableMessageVO::getPayRemark).filter(StringUtils::hasLength).distinct().collect(Collectors.joining(";")));
        main.setComment(mails.stream().map(GoodsToEnableMessageVO::getComment).filter(StringUtils::hasLength).distinct().collect(Collectors.joining(";")));
        main.setRemark(mails.stream().map(GoodsToEnableMessageVO::getRemark).filter(StringUtils::hasLength).distinct().collect(Collectors.joining(";")));
        main.setList(mails.stream().flatMap(a -> a.getList().stream()).collect(Collectors.toList()));
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_GOODS_TO_ENABLE.name());
        orderMessage.setData((Object)main);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailAuthFail(PreOrderVO preOrderVO, String errMsg) {
        this.sendEmail(preOrderVO, MailTypeEnum.OMC_ORDER_AUTH_FAIL, errMsg);
    }

    public void sendEmailPreOrderInitFail(long preOrderSid, String errMsg) {
        PreOrderVO preOrderVO = this.preOrderService.findPreOrderAndDtlBySid(Long.valueOf(preOrderSid));
        this.sendEmail(preOrderVO, MailTypeEnum.OMC_ORDER_INIT_FAIL, errMsg);
    }

    public void sendEmailAuthUserCount(PreOrderVO preOrderVO) {
        try {
            PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
            GoodsToEnableMessageVO vo = new GoodsToEnableMessageVO();
            vo.setTenantId(preOrderVO.getTenantId());
            vo.setTenantName(preOrderVO.getTenantName());
            vo.setCode(dtl.getGoodsCode());
            vo.setGoodsName(dtl.getGoodsName());
            vo.setEffectiveTime(dtl.getEffectiveDateTime());
            vo.setTotalUserCount(dtl.getTotalUsageBound().intValue());
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(MailTypeEnum.OMC_AUTH_USER_COUNT.name());
            orderMessage.setData((Object)vo);
            this.producerService.msg(orderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("[%s]\u53d1\u9001\u6388\u6743\u8c03\u964d\u4f7f\u7528\u4eba\u6570\u5f02\u52a8\u901a\u77e5\u90ae\u4ef6\u5931\u8d25", LocalDateTime.now()), (Throwable)e);
        }
    }

    public void sendEmailActivateCloudDevice(OrderCloudDeviceVO orderCloudDeviceVO, boolean batch) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_CLOUD_APPLICATION.name());
        OrderCloudDeviceMessage messageData = OrderCloudDeviceMessage.generate((OrderCloudDeviceVO)orderCloudDeviceVO);
        messageData.setApplicantId(orderCloudDeviceVO.getApplicantId());
        messageData.setApplicantName(orderCloudDeviceVO.getApplicantName());
        orderMessage.setData((Object)messageData);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailCompleteCloudDevice(OrderCloudDeviceVO orderCloudDeviceVO) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_CLOUD_COMPLETED.name());
        OrderCloudDeviceMessage messageData = OrderCloudDeviceMessage.generate((OrderCloudDeviceVO)orderCloudDeviceVO);
        orderMessage.setData((Object)messageData);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailExpiredCloudDevice(DeviceCloudExpiredNoticeDTO dto) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_CLOUD_EXPIRED.name());
        orderMessage.setData((Object)dto);
        this.producerService.msg(orderMessage);
    }

    public void sendStopSyncImageEmail(OrderCloudDeviceVO orderCloudDeviceVO) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_CLOUD_EXPIRED_AZURE.name());
        OrderCloudDeviceMessage messageDate = OrderCloudDeviceMessage.generate((OrderCloudDeviceVO)orderCloudDeviceVO);
        orderMessage.setData((Object)messageDate);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailAuthManual(long orderSid) {
        OrderAuthManualMessage data = this.mailDataMapper.get1(orderSid);
        Object expiredDateTime = this.cacService.calculateExpiredDateTime(Long.valueOf(orderSid));
        data.setExpiredTime(expiredDateTime);
        if (data.getEffectiveTime().isBefore(LocalDateTime.now())) {
            data.setExpiredDays(Long.valueOf(Duration.between(data.getEffectiveTime(), LocalDateTime.now()).toDays()));
        }
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_GOODS_AUTH_MANUAL.name());
        orderMessage.setData((Object)data);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailServicerOrderCheck(Long orderSid) {
        boolean canSendSms;
        OrderVO orderVO = this.orderQueryService.getOrderBySid(orderSid.longValue());
        String expireDate = Optional.ofNullable(orderVO.getFirstOrderDetail()).map(OrderDetailVO::getServicerOrderDetail).map(ServicerOrderDetailVO::getModifyDate).map(modifyDate -> modifyDate.plusDays(14L).format(dateFormatter)).orElse(null);
        orderVO.setTossFail(expireDate);
        MessageBody orderMessage = new MessageBody();
        String opType = MailTypeEnum.ISV_ORDER_CHECK_EMAIL.name();
        UserContactsVO userContactsVO = this.iamService.getUserContactsById(orderVO.getUserId());
        boolean bl = canSendSms = userContactsVO != null && StrUtils.isEmpty((String)userContactsVO.getEmail()) && StrUtils.isNotEmpty((String)userContactsVO.getTelephone()) && Locale.SIMPLIFIED_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry());
        if (canSendSms) {
            opType = MailTypeEnum.ISV_ORDER_CHECK_SMS.name();
            orderVO.setAccount(userContactsVO.getTelephone());
        }
        orderMessage.setOpType(opType);
        orderMessage.setData((Object)orderVO);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailServicerOrderHandleResult(Long orderSid, String mailType, String remark, boolean userHandling) {
        OrderVO orderVO = this.orderQueryService.getOrderBySid(orderSid.longValue());
        orderVO.setCode(orderVO.getGoodsCode());
        ServicerOrderDetailVO detailVO = orderVO.getFirstOrderDetail().getServicerOrderDetail();
        detailVO.setRemark(remark);
        MessageBody orderMessage = new MessageBody();
        if (MailTypeEnum.ISV_ORDER_TENANT_REJECTED_EMAIL.name().equals(mailType)) {
            UserContactsVO userContactsVO = this.iamService.getUserContactsById(UserUtils.getUserId());
            String telephone = "";
            if (userContactsVO != null) {
                telephone = userContactsVO.getTelephone();
            }
            detailVO.setCreateById(telephone);
        } else if (MailTypeEnum.ISV_ORDER_TENANT_CONFIRMED_EMAIL.name().equals(mailType) && !userHandling) {
            UserContactsVO userContactsVO = this.iamService.getUserContactsById(orderVO.getUserId());
            String userEmail = null;
            if (userContactsVO != null) {
                if (StrUtils.isNotEmpty((String)userContactsVO.getEmail())) {
                    userEmail = userContactsVO.getEmail();
                } else if (StrUtils.isNotEmpty((String)userContactsVO.getTelephone()) && Locale.SIMPLIFIED_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
                    orderMessage.setOpType(MailTypeEnum.ISV_ORDER_TENANT_CONFIRMED_SMS.name());
                    orderVO.setAccount(userContactsVO.getTelephone());
                    orderMessage.setData((Object)orderVO);
                    this.producerService.msg(orderMessage);
                }
            }
            orderVO.setAccount(userEmail);
        }
        orderMessage.setOpType(mailType);
        orderMessage.setData((Object)orderVO);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailServicerOrderDeliverRemind(Map<String, List<OrderVO>> orderVOMap) {
        for (Map.Entry<String, List<OrderVO>> entry : orderVOMap.entrySet()) {
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(MailTypeEnum.ISV_ORDER_DELIVER_REMIND_EMAIL.name());
            HashMap<String, Object> mapData = new HashMap<String, Object>();
            mapData.put("code", entry.getKey());
            mapData.put("orderVOList", entry.getValue());
            orderMessage.setData(mapData);
            this.producerService.msg(orderMessage);
        }
    }

    public void sendEmailAutoShipmentResult(List<PreOrderDTO> list, boolean success) {
        list.forEach(x -> {
            if (StrUtils.isEmpty((String)x.getErrorMsg())) {
                x.setErrorMsg("\u6210\u529f");
            }
        });
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_AUTO_SHIPMENT_RESULT.name());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", this.getLocaleResult(success));
        map.put("list", list);
        orderMessage.setData(map);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailCancelAutoShipmentResult(List<PreOrderDetailVO> list, boolean success) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_AUTO_SHIPMENT_CANCEL_RESULT.name());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", this.getLocaleResult(success));
        map.put("list", list);
        orderMessage.setData(map);
        this.producerService.msg(orderMessage);
    }

    public void sendEmailPeriodAuthFailed(OrderVO orderVO, InstallmentOrderCallbackVO callbackVO) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_PERIOD_AUTH_FAILED_EMAIL.name());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", orderVO.getTenantId());
        map.put("tenantName", orderVO.getTenantName());
        map.put("goodsName", orderVO.getFirstOrderDetail().getGoodsName());
        map.put("goodsCode", orderVO.getGoodsCode());
        map.put("orderCode", callbackVO.getOrderNo());
        map.put("authDate", callbackVO.getAuthDate());
        map.put("alreadyTimes", callbackVO.getAlreadyTimes());
        map.put("periodAmount", callbackVO.getPeriodAmount());
        orderMessage.setData(map);
        this.producerService.msg(orderMessage);
    }

    private String getLocaleResult(boolean success) {
        String result = success ? "\u6210\u529f" : (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? "\u5931\u6557" : "\u5931\u8d25");
        return result;
    }

    private void sendEmail(PreOrderVO preOrderVO, MailTypeEnum opType, String errMsg) {
        try {
            PreOrderDetailVO dtl = preOrderVO.getFirstOrderDetail();
            MailOrder data = new MailOrder();
            data.setOrderSid(preOrderVO.getSid());
            data.setOrderCode(preOrderVO.getOrderCode());
            data.setCreateDate(preOrderVO.getCreateDate());
            data.setTenantId(preOrderVO.getTenantId());
            data.setTenantName(preOrderVO.getTenantName());
            data.setUserId(preOrderVO.getTenantId());
            data.setUserName(preOrderVO.getTenantName());
            data.setGoodsSid(dtl.getGoodsSid());
            data.setGoodsCode(dtl.getGoodsCode());
            data.setCode(dtl.getGoodsCode());
            data.setGoodsName(dtl.getGoodsName());
            GoodsStrategy strategy = null;
            if (dtl.getStrategySid() != null) {
                strategy = this.goodsMapper.findStrategyBySid(dtl.getStrategySid().longValue());
            }
            if (null != strategy) {
                data.setStrategySid(strategy.getId());
                data.setStrategyName(strategy.getName());
            }
            data.setQuantity(dtl.getTotalUsageBound());
            if (null != errMsg) {
                data.setRemark(String.format("[%s] %s", PreOrderTypeEnum.getName((Integer)preOrderVO.getOrderType()), errMsg));
            }
            MessageBody orderMessage = new MessageBody();
            orderMessage.setOpType(opType.name());
            orderMessage.setData((Object)data);
            this.producerService.msg(orderMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u9884\u552e\u8ba2\u5355sid[%s]", preOrderVO.getSid()), (Throwable)e);
        }
    }

    public void sendChangeDeviceDbPassword(OrderCloudDevice entity) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_DB_CHANGE_PASSWORD.name());
        OrderCloudDeviceDbMessageVO data = new OrderCloudDeviceDbMessageVO();
        List pre = this.preOrderDetailRepository.findByOrderSid(entity.getOrderSid());
        if (!pre.isEmpty()) {
            data.setGoodsName((String)pre.stream().filter(a -> Boolean.TRUE.equals(a.getMainStrategy())).findFirst().map(PreOrderDetail::getGoodsName).orElse(null));
        } else {
            data.setGoodsName((String)this.orderDetailCrudService.findByOrderSid(entity.getOrderSid().longValue()).stream().findAny().map(OrderDetail::getGoodsName).orElse(null));
        }
        data.setCode(entity.getCode());
        data.setDbUrl(entity.getDbUrl());
        data.setDbName(entity.getDbName());
        data.setDbUsername(entity.getDbUsername());
        data.setDbPassword(AES.decrypt((String)entity.getDbPassword(), (String)KeyConstant.WECHAT_UNION_ID));
        data.setUserId(entity.getApplicantId());
        orderMessage.setData((Object)data);
        this.producerService.msg(orderMessage);
    }

    public void sendBorrowNotice(BorrowNoticeVO emailVO, String type) {
        MessageBody message = new MessageBody();
        message.setOpType(type);
        message.setData((Object)emailVO);
        this.producerService.msg(message);
    }

    public void sendEmailActivateCloudDeviceMerged(List<OrderCloudDeviceVO> mails) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_CLOUD_APPLICATION.name());
        OrderCloudDeviceBatchMessage messageData = OrderCloudDeviceBatchMessage.generate(mails);
        orderMessage.setData((Object)messageData);
        this.producerService.msg(orderMessage);
    }

    public void sendReleaseDeviceEmails(List<OrderCloudDeviceVO> deviceClouds) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_RELEASE_REMINDER.name());
        HashMap<String, List<OrderCloudDeviceVO>> data = new HashMap<String, List<OrderCloudDeviceVO>>();
        data.put("list", deviceClouds);
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendCloudDeviceExpireEmails(List<OrderCloudDeviceVO> deviceClouds) {
        if (CollectionUtils.isEmpty(deviceClouds)) {
            return;
        }
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_EXPIRE_REMINDER.name());
        HashMap<String, List<OrderCloudDeviceVO>> data = new HashMap<String, List<OrderCloudDeviceVO>>();
        data.put("list", deviceClouds);
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendDeviceExpireEmails(Integer expireDays, List<DeviceExpiringVO> values) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_EXPIRING.name());
        HashMap<String, Object> data = new HashMap<String, Object>();
        DeviceExpiringVO first = values.get(0);
        data.put("tenantId", first.getTenantId());
        data.put("tenantName", first.getTenantName());
        data.put("expired", first.getExpiredDays());
        data.put("expiredTime", first.getExpireDate());
        data.put("list", values);
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendDeviceExpireEmailsPM(Integer expireDays, List<DeviceExpiringVO> values) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_DEVICE_EXPIRING_PM.name());
        HashMap<String, Object> data = new HashMap<String, Object>();
        DeviceExpiringVO first = values.get(0);
        data.put("expired", first.getExpiredDays());
        data.put("code", first.getGoodsCode());
        data.put("list", values);
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendSubmitBnplOrder(Object data) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_BNPL_ORDER_SUBMIT.name());
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendTerminateBnplOrder(BnplOrder bnplOrder) {
        BnplOrderMailVO data = this.getBnplOrderMailVO(bnplOrder);
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_BNPL_ORDER_TERMINATE.name());
        orderMessage.setData((Object)data);
        this.producerService.msg(orderMessage);
    }

    public void sendTerminateBnplOrderPM(BnplOrder bnplOrder) {
        BnplOrderMailVO data = this.getBnplOrderMailVO(bnplOrder);
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_BNPL_ORDER_TERMINATE_PM.name());
        orderMessage.setData((Object)data);
        this.producerService.msg(orderMessage);
    }

    public void sendOverdueBill(BillOverdueNoticeDTO dto) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_BILL_ORDER_OVERDUE_PM.name());
        orderMessage.setData((Object)dto);
        this.producerService.msg(orderMessage);
    }

    private BnplOrderMailVO getBnplOrderMailVO(BnplOrder bnplOrder) {
        BnplOrderMailVO data = new BnplOrderMailVO();
        data.doBackward((Object)bnplOrder);
        data.setCode(data.getGoodsCode());
        data.setUnPaidCount(Integer.valueOf(data.getBilledCount() - data.getPaidCount()));
        data.setUnPaidAmount(data.getAmount().multiply(BigDecimal.valueOf(data.getUnPaidCount().intValue())));
        return data;
    }

    public void sendCloudDeviceTerminateNotice(List<OrderCloudDeviceVO> orderCloudDeviceVOS) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_ClOUD_DEVICE_TERMINATE_NOTICE.name());
        HashMap<String, List<OrderCloudDeviceVO>> data = new HashMap<String, List<OrderCloudDeviceVO>>();
        data.put("list", orderCloudDeviceVOS);
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendApiGoodsSuccess(OrderVO orderVO) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_ORDER_API_PAY_SUCCESS.name());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tenantId", orderVO.getTenantId());
        data.put("tenantName", orderVO.getTenantName());
        data.put("goodsCode", orderVO.getFirstOrderDetail().getGoodsCode());
        data.put("goodsName", orderVO.getFirstOrderDetail().getGoodsName());
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }

    public void sendNoticeBnplEntrustOrder(List<OrderVO> orderVOList, PackOrderVO packOrderVO) {
        NoticeBnplEntrustOrderDTO dto = new NoticeBnplEntrustOrderDTO();
        boolean isPack = Objects.nonNull(packOrderVO);
        OrderVO orderVO = isPack ? (OrderVO)orderVOList.stream().filter(x -> Objects.equals(x.getShopping(), OrderShoppingEnum.PACK.getCode())).collect(Collectors.toList()).get(0) : orderVOList.get(0);
        Goods goods = this.goodsMapper.findGoodsByCode(orderVO.getGoodsCode());
        BnplOrder bnplOrder = this.bnplOrderCrudService.findByOrderSid(orderVO.getSid());
        if (Objects.isNull(bnplOrder) || Objects.isNull(goods)) {
            return;
        }
        dto.setTenantId(orderVO.getTenantId());
        dto.setTenantName(orderVO.getTenantName());
        dto.setUserId(orderVO.getUserId());
        dto.setUserName(orderVO.getUserName());
        dto.setTelephone(orderVO.getTelephone());
        dto.setEmail(orderVO.getEmail());
        dto.setBnplCode(bnplOrder.getBnplCode());
        dto.setCreateDateTime(bnplOrder.getCreateDate());
        dto.setTotalAmount(orderVO.getPayPrice().multiply(new BigDecimal(bnplOrder.getTotalCount())).setScale(2, RoundingMode.HALF_UP).toString());
        dto.setTotalCount(bnplOrder.getTotalCount());
        if (bnplOrder.getTotalCount() == 1) {
            dto.setNextBillDate(bnplOrder.getNextBillDate() == null ? LocalDate.now() : bnplOrder.getNextBillDate());
        } else {
            dto.setNextBillDate(Objects.equals(1, bnplOrder.getBilledCount()) ? bnplOrder.getNextBillDate().minusMonths(1L) : bnplOrder.getNextBillDate());
        }
        dto.setAmount(bnplOrder.getAmount().setScale(2, RoundingMode.HALF_UP).toString());
        dto.setOrderCode(orderVO.getOrderCode());
        dto.setPackCode(orderVO.getPackCode());
        dto.setPackGoodsName(isPack ? packOrderVO.getGoodsName() : "");
        dto.setPack(Boolean.valueOf(isPack));
        dto.setPayType("\u5148\u8ba2\u540e\u4ed8");
        dto.setRemark(orderVO.getRemark());
        dto.setComment(orderVO.getComment());
        ArrayList mailGoodsDetailList = new ArrayList();
        List orderSidList = orderVOList.stream().filter(x -> Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode())).map(OrderVO::getSid).collect(Collectors.toList());
        List orderDetailVOList = this.orderDetailMapper.findOrderDetails(orderSidList);
        orderDetailVOList.forEach(orderDetailVO -> {
            MailGoodsDetail mailGoodsDetail = new MailGoodsDetail();
            mailGoodsDetail.setGoodsName(orderDetailVO.getGoodsName());
            mailGoodsDetail.setStrategyName(orderDetailVO.getStrategyName());
            mailGoodsDetail.setQuantity(orderDetailVO.getQuantity());
            mailGoodsDetail.setRemark(orderDetailVO.getRemark());
            mailGoodsDetail.setCategoryName(orderDetailVO.getCategoryName());
            mailGoodsDetailList.add(mailGoodsDetail);
        });
        dto.setGoodsList(mailGoodsDetailList);
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.NOTICE_BNPL_ENTRUST_ORDER.name());
        orderMessage.setData((Object)dto);
        this.producerService.msg(orderMessage);
    }

    public void sendUnTossOrderNotification(List<OrderDetailResult> orderDetails) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_ORDER_UN_TOSS_NOTIFICATION.name());
        Map<String, List<OrderDetailResult>> orderMap = orderDetails.stream().collect(Collectors.groupingBy(OrderDetailResult::getGoodsCode));
        for (Map.Entry<String, List<OrderDetailResult>> orderMapItem : orderMap.entrySet()) {
            GoodsOrderMessage goodsOrderMessage = new GoodsOrderMessage();
            goodsOrderMessage.setCode(orderMapItem.getKey());
            goodsOrderMessage.setOrders(orderMapItem.getValue());
            orderMessage.setData((Object)goodsOrderMessage);
            this.producerService.msg(orderMessage);
        }
    }

    public void sendTossFailedOrderNotification(List<OrderDetailResult> orderDetails) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(MailTypeEnum.OMC_ORDER_TOSS_FAIL_PM.name());
        Map<String, List<OrderDetailResult>> orderMap = orderDetails.stream().collect(Collectors.groupingBy(OrderDetailResult::getGoodsCode));
        for (Map.Entry<String, List<OrderDetailResult>> orderMapItem : orderMap.entrySet()) {
            GoodsOrderMessage goodsOrderMessage = new GoodsOrderMessage();
            goodsOrderMessage.setCode(orderMapItem.getKey());
            goodsOrderMessage.setOrders(orderMapItem.getValue());
            orderMessage.setData((Object)goodsOrderMessage);
            this.producerService.msg(orderMessage);
        }
    }

    public void sendEmail(MailTypeEnum mailTypeEnum, Object data) {
        MessageBody orderMessage = new MessageBody();
        orderMessage.setOpType(mailTypeEnum.name());
        orderMessage.setData(data);
        this.producerService.msg(orderMessage);
    }
}

