/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.remote.Awsp920RequestVO;
import com.digiwin.dap.middleware.omc.domain.remote.Awsp920ResponseVO;
import com.digiwin.dap.middleware.omc.domain.remote.CustomerShippingVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.support.remote.MiswsService;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class MiswsServiceImpl
implements MiswsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiswsServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate2;
    private static final String GET_CUST_SERVICE_DATA_URL = "/api/GetCustServiceData";
    private static final String CASE_URL = "/api/GetCust";
    private static final String APP_KEY_CLOUD_MARKET = "CloudMarket";
    private static final String ESP_CROSS_URL = "/CROSS/RESTful";

    public CustomerShippingVO getCustServiceData(PreOrderDTO dto) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appkey", APP_KEY_CLOUD_MARKET);
        params.put("appsecret", this.getAppSecret(APP_KEY_CLOUD_MARKET));
        params.put("CmpId", dto.getCompanyId());
        params.put("SdNo", dto.getSourceBillCode());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getMiswsUri() + GET_CUST_SERVICE_DATA_URL;
        LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599 params {}", params);
        try {
            ResponseEntity responseEntity = this.restTemplate2.postForEntity(url, (Object)requestEntity, CustomerShippingVO.class, new Object[0]);
            CustomerShippingVO vo = (CustomerShippingVO)Optional.ofNullable(responseEntity.getBody()).orElse(new CustomerShippingVO());
            LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599\u56de\u53c2 = {}", (Object)JsonUtils.objToJson((Object)vo));
            return vo;
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599\u5931\u8d25", (String)url, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
            throw new BusinessException("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599\u5931\u8d25");
        }
    }

    public CustomerShippingVO getCustCase(PreOrderDTO dto) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appkey", APP_KEY_CLOUD_MARKET);
        params.put("appsecret", this.getAppSecret(APP_KEY_CLOUD_MARKET));
        params.put("CustNo", dto.getPotentialCustomerId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getMiswsUri() + CASE_URL;
        LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u8d44\u6599 params {}", params);
        try {
            ResponseEntity responseEntity = this.restTemplate2.postForEntity(url, (Object)requestEntity, CustomerShippingVO.class, new Object[0]);
            CustomerShippingVO vo = (CustomerShippingVO)Optional.ofNullable(responseEntity.getBody()).orElse(new CustomerShippingVO());
            LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u8d44\u6599\u56de\u53c2 = {}", (Object)JsonUtils.objToJson((Object)vo));
            return vo;
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u8d44\u6599\u5931\u8d25", (String)url, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
            throw new BusinessException("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u5ba2\u6237\u8d44\u6599\u5931\u8d25");
        }
    }

    private String getAppSecret(String appKey) {
        String appSecret = appKey + DateUtils.formatDatePure((TemporalAccessor)LocalDate.now());
        return DigestUtils.md5DigestAsHex((byte[])appSecret.getBytes(StandardCharsets.UTF_8)).toUpperCase();
    }

    public void checkItem(List<String> items, String area) {
        String uri = String.format("%s%s", this.envProperties.getEspUri(), ESP_CROSS_URL);
        HttpHeaders headers = Awsp920RequestVO.buildHeader((String)this.envProperties.getOmcUri());
        Awsp920RequestVO requestVO = new Awsp920RequestVO(items, area);
        HttpEntity requestEntity = new HttpEntity((Object)requestVO, (MultiValueMap)headers);
        List<String> errorItemCodes = items;
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, requestEntity, Awsp920ResponseVO.class, new Object[0]);
            if (null == response || null == response.getBody()) {
                LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u54cd\u5e94\u5bf9\u8c61\u4e3a\u7a7a", (Object)errorItemCodes.stream().collect(Collectors.joining(",")));
                throw new BusinessException("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u54cd\u5e94\u5bf9\u8c61\u4e3a\u7a7a");
            }
            if (StringUtils.hasText((String)((Awsp920ResponseVO)response.getBody()).getErrorCode())) {
                LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)response.getBody()));
                throw new BusinessException(String.format("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:%s", ((Awsp920ResponseVO)response.getBody()).getErrorMessage()));
            }
            if (null == ((Awsp920ResponseVO)response.getBody()).getStd_data() || null == ((Awsp920ResponseVO)response.getBody()).getStd_data().getParameter() || null == ((Awsp920ResponseVO)response.getBody()).getStd_data().getParameter().getSuccess_return()) {
                LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)response.getBody()));
                throw new BusinessException(String.format("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:%s", ((Awsp920ResponseVO)response.getBody()).getErrorMessage()));
            }
            List successReturn = ((Awsp920ResponseVO)response.getBody()).getStd_data().getParameter().getSuccess_return();
            successReturn.forEach(s -> {
                if (StringUtils.hasText((String)s.getImaa001())) {
                    errorItemCodes.remove(s.getImaa001());
                }
            });
            if (!CollectionUtils.isEmpty(errorItemCodes)) {
                LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)response.getBody()));
                throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848\u7684\u54c1\u53f7${%s}\u4e0d\u5b58\u5728\uff0c", errorItemCodes.stream().collect(Collectors.joining(",")), JsonUtils.objToJson((Object)((Awsp920ResponseVO)response.getBody()).getStd_data().getParameter())));
            }
        }
        catch (Exception ex) {
            LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)ex.getMessage()));
            throw ex;
        }
    }
}

