/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.support.remote.OmcService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OmcServiceImpl
implements OmcService {
    @Autowired
    private RestTemplate restTemplate;

    public List<PreOrderVO> getSynchronousPurchaseGoods(String area, String uri, String token) {
        List<Object> purchaseGoodVOList = new ArrayList<PreOrderVO>();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, token);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = String.format("%s/api/omc/v2/pre/synchronous/goods", uri);
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, request, StdData.class, new HashMap());
            StdData resultBody = (StdData)result.getBody();
            if (HttpStatus.OK == result.getStatusCode() && resultBody != null) {
                ObjectMapper objectMapper = JsonUtils.createObjectMapper();
                objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
                purchaseGoodVOList = (List)objectMapper.readValue(objectMapper.writeValueAsString(resultBody.getData()), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PreOrderVO.class));
            }
        }
        catch (Exception e) {
            throw new BusinessException(String.format("\u83b7\u53d6\u4e91\u7aef%s\u9700\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25", uri), (Throwable)e);
        }
        return purchaseGoodVOList;
    }

    public void batchUpdateSynchronousState(String uri, String userToken, List<Long> purchaseSids) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            String url = String.format("%s/api/omc/v2/pre/synchronous/state/update", uri);
            HttpEntity request = new HttpEntity(purchaseSids, (MultiValueMap)headers);
            this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            throw new BusinessException(String.format("\u6279\u91cf\u66f4\u65b0\u4e91\u7aef%s\u51fa\u8d27\u5546\u54c1%s\u540c\u6b65\u72b6\u6001", uri, JsonUtils.writeValue(purchaseSids)), (Throwable)e);
        }
    }
}

