/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.remote.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderSourceEnum;
import com.digiwin.dap.middleware.omc.domain.gmc.PackNoticeItemVO;
import com.digiwin.dap.middleware.omc.domain.gmc.PackNoticeVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDetailDTO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.support.remote.SysNoticeService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysNoticeServiceImpl
implements SysNoticeService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private ProducerService producerService;

    public void pushPackOrder(List<OrderVO> orders) {
        Optional<OrderVO> packOrder = orders.stream().filter(o -> o.getShopping() == 2).findFirst();
        packOrder.ifPresent(pack -> {
            MessageBody messageBody = new MessageBody();
            messageBody.setOpType(SysNoticeEnum.APP_PACK_NEW.name());
            messageBody.setSysId(pack.getGoodsCode());
            Goods goods = this.goodsMapper.findGoodsByCode(pack.getGoodsCode());
            PackNoticeVO packNoticeVO = new PackNoticeVO();
            packNoticeVO.setTenantSid(pack.getTenantSid());
            packNoticeVO.setTenantId(pack.getTenantId());
            packNoticeVO.setTenantName(pack.getTenantName());
            packNoticeVO.setPackCode(goods.getCode());
            packNoticeVO.setPackName(goods.getDisplayName());
            packNoticeVO.setOrderDate(pack.getCreateDate());
            List items = orders.stream().filter(o -> o.getShopping() == 0).map(o -> new PackNoticeItemVO(o.getFirstOrderDetail().getGoodsCode(), o.getFirstOrderDetail().getGoodsName())).collect(Collectors.toList());
            packNoticeVO.setGoods(items);
            messageBody.setData((Object)packNoticeVO);
            this.producerService.sys(messageBody);
        });
    }

    public void pushPackPreOrder(List<PreOrderDTO> orders) {
        Optional<PreOrderDTO> preOrderDTO = orders.stream().filter(o -> PreOrderSourceEnum.BossMultiGoods.name().equals(o.getOrderSource())).findFirst();
        if (preOrderDTO.isPresent()) {
            PreOrderDTO preOrder = preOrderDTO.get();
            PreOrderDetailDTO preOrderDetail = (PreOrderDetailDTO)preOrder.getDetails().get(0);
            MessageBody messageBody = new MessageBody();
            messageBody.setOpType(SysNoticeEnum.APP_PACK_NEW.name());
            messageBody.setSysId(preOrderDetail.getPackCode());
            PackNoticeVO packNoticeVO = new PackNoticeVO();
            packNoticeVO.setTenantSid(preOrder.getTenantSid());
            packNoticeVO.setTenantId(preOrder.getTenantId());
            packNoticeVO.setTenantName(preOrder.getTenantName());
            packNoticeVO.setPackCode(preOrderDetail.getPackCode());
            packNoticeVO.setPackName(preOrderDetail.getPackName());
            packNoticeVO.setOrderDate(LocalDateTime.now());
            List items = orders.stream().map(o -> new PackNoticeItemVO(((PreOrderDetailDTO)o.getDetails().get(0)).getGoodsCode(), ((PreOrderDetailDTO)o.getDetails().get(0)).getGoodsName())).collect(Collectors.toList());
            packNoticeVO.setGoods(items);
            messageBody.setData((Object)packNoticeVO);
            this.producerService.sys(messageBody);
        }
    }
}

