/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.schedule.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.BnplOrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceStateEnum;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.MailTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.ServiceStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.ShippingTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderDetailAuthorizationEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.dao.BnplOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.ServicerOrderDetailCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.bill.dto.BillOverdueDTO;
import com.digiwin.dap.middleware.omc.domain.bill.dto.BillOverdueNoticeDTO;
import com.digiwin.dap.middleware.omc.domain.changelog.ModifiedInfoDTO;
import com.digiwin.dap.middleware.omc.domain.mail.BorrowNoticeListVO;
import com.digiwin.dap.middleware.omc.domain.mail.BorrowNoticeVO;
import com.digiwin.dap.middleware.omc.domain.order.dto.OrderDetailSimpleDTO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.ProductTypeVO;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.DeviceExpiringVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PaymentVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.response.AuthorizationModuleVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ServicerOrderDetailVO;
import com.digiwin.dap.middleware.omc.entity.BnplOrder;
import com.digiwin.dap.middleware.omc.entity.ServicerOrderDetail;
import com.digiwin.dap.middleware.omc.mapper.DeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderService;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.cache.RedisService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.LmcService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.remote.OmcService;
import com.digiwin.dap.middleware.omc.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.omc.support.stream.PutawayMessageService;
import com.digiwin.dap.middleware.omc.util.MailUtil;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.support.EnvSupport;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SqlServerJdbcUtils;
import java.io.File;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ScheduleTaskServiceImpl
implements ScheduleTaskService {
    public static final Integer SLEEP_SECONDS = 30000;
    public static final String PROFILES_ACTIVE = "test";
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskServiceImpl.class);
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private MailService mailService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private PreOrderService preOrderService;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private LmcService lmcService;
    @Autowired
    private ServicerOrderDetailCrudService servicerOrderDetailCrudService;
    @Autowired
    private EnvSupport envSupport;
    @Autowired
    private DapHttpService dapHttpService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private BnplOrderCrudService bnplOrderCrudService;
    @Autowired
    private BnplOrderService bnplOrderService;
    @Autowired
    private DMC dmcClient;
    @Autowired
    private IamService iamService;
    @Autowired
    private PutawayMessageService putawayMessageService;
    @Autowired
    private OrderDetailMapper orderDetailMapper;

    @CacheLock(prefix="omc-schedule-task-01", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 1 * * ?")
    public void configureTasks1() {
        try {
            logger.info("\u6267\u884c[\u53d1\u9001\u5df2\u629b\u7816\u8ba2\u5355\u5217\u8868\u90ae\u4ef6]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            LocalDate endTime = LocalDate.now();
            LocalDate startTime = endTime.minusDays(1L);
            this.mailService.sendTossOverPeriod(startTime.atStartOfDay(), endTime.atStartOfDay());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u53d1\u9001\u5df2\u629b\u7816\u8ba2\u5355\u5217\u8868\u90ae\u4ef6]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-02", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 1/1 * ?")
    public void configureTasks2() {
        try {
            logger.info("\u6267\u884c[\u66f4\u65b0\u672a\u652f\u4ed8\u8ba2\u5355\u8fc7\u671f\u72b6\u6001]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            this.orderUpdateMapper.updateOrderValidByExpireDate();
            this.orderUpdateMapper.updateOrderValid();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u53d1\u9001\u5df2\u629b\u7816\u8ba2\u5355\u5217\u8868\u90ae\u4ef6]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-16", expired=30L, autoDelete=false)
    @Scheduled(cron="0 5 0 1/1 * ?")
    @Async
    public void orderPaymentExpiration() {
        try {
            logger.info("\u6267\u884c[\u8ba2\u5355\u652f\u4ed8\u5373\u5c06\u5931\u6548\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            OrderConditionVO cond = new OrderConditionVO();
            cond.setValid(Boolean.TRUE);
            cond.setOrderStatus(Integer.valueOf(OrderStatusEnum.Unpaid.getValue()));
            cond.setPayType("VACC");
            cond.setContainBill(Boolean.FALSE);
            cond.setPayRemainingDays(Integer.valueOf(3));
            cond.setInclude(Integer.valueOf(1));
            cond.removePage();
            cond.setShopping(Integer.valueOf(OrderShoppingEnum.PACK.getCode()));
            List packList = this.orderQueryService.findOrdersWithoutPolicy(cond);
            cond.setShopping(null);
            cond.setSingleShopping(Integer.valueOf(OrderShoppingEnum.SHOPPING_CART.getCode()));
            List cartList = this.orderQueryService.findOrdersWithoutPolicy(cond);
            cond.setSingleShopping(Integer.valueOf(OrderShoppingEnum.COMMON.getCode()));
            List commonList = this.orderQueryService.findOrdersWithoutPolicy(cond);
            ArrayList allList = new ArrayList();
            allList.addAll(packList);
            allList.addAll(cartList);
            allList.addAll(commonList);
            if (allList.isEmpty()) {
                logger.info("\u67e5\u8be2[\u8ba2\u5355\u652f\u4ed8\u5373\u5c06\u5931\u6548\u901a\u77e5]\u8ba2\u5355\u6570\u91cf\u4e3a0\uff0c\u4e0d\u901a\u77e5\uff0c\u9000\u51fa\u3002");
                return;
            }
            List orderSids = allList.stream().map(OrderVO::getSid).collect(Collectors.toList());
            List orderPayments = this.orderDetailMapper.findOrderPayments(orderSids, null);
            Map<Long, PaymentVO> orderPaymentMap = orderPayments.stream().collect(Collectors.toMap(PaymentVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(PaymentVO::getSid))));
            allList.forEach(x -> x.setPayment((PaymentVO)orderPaymentMap.get(x.getSid())));
            Map<String, List<OrderVO>> userOrderListMap = allList.stream().collect(Collectors.groupingBy(OrderVO::getUserId));
            for (Map.Entry<String, List<OrderVO>> entry : userOrderListMap.entrySet()) {
                this.mailService.sendEmail(MailTypeEnum.OMC_ORDER_PAYMENT_EXPIRATION, entry.getValue());
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u8ba2\u5355\u652f\u4ed8\u5373\u5c06\u5931\u6548\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-03", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 1/1 * ?")
    public void sendGoodsExpire() {
        try {
            LocalDate searchTime = LocalDate.now();
            this.mailService.sendGoodsToEnableEmail(searchTime);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u53d1\u9001\u5546\u54c1\u5f00\u901a\u901a\u77e5\u90ae\u4ef6]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-04", expired=30L, autoDelete=false)
    @Scheduled(cron="0 50 23 * * ?")
    public void manualAuthorization() {
        try {
            logger.info("-->>\u6267\u884c[\u4eba\u5de5\u6388\u6743\u5f00\u901a]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            this.preOrderService.manualAuthorization();
            logger.info("<<--\u5b8c\u6210[\u4eba\u5de5\u6388\u6743\u5f00\u901a]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u4eba\u5de5\u6388\u6743\u5f00\u901a]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-05", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void sendReduceUEmail() {
        try {
            List authorizationResultVOS = this.cacService.queryAuthorization();
            if (authorizationResultVOS.size() > 0) {
                ArrayList authorizationResultVOList = new ArrayList();
                authorizationResultVOS.forEach(o -> {
                    if (o.getPaymentType().equals(1) && o.getUserCount() > o.getTotalUserCount() && o.getExpiredTime().isAfter(LocalDateTime.now())) {
                        AuthorizationResultVO authorizationResultVO = new AuthorizationResultVO();
                        BeanUtils.mergeObject((Object)o, (Object)authorizationResultVO);
                        authorizationResultVOList.add(authorizationResultVO);
                    }
                });
                Map<String, List<AuthorizationResultVO>> map = authorizationResultVOList.stream().collect(Collectors.groupingBy(AuthorizationResultVO::getCode));
                map.forEach((k, v) -> {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("code", k);
                    map1.put("authorizations", v);
                    this.mailService.sendEmailReduceU(map1);
                });
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u53d1\u9001\u964dU\u901a\u77e5\u90ae\u4ef6\u81f3\u4ea7\u54c1\u7ecf\u7406]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-06", expired=30L, autoDelete=false)
    @Scheduled(cron="0 30 0 * * ?")
    public void sendCloudDeviceExpireEmail() {
        try {
            logger.info("-->>\u6267\u884c[\u4e91\u8d44\u6e90\u5230\u671f\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            this.orderCloudDeviceService.checkExpiredCloudDevice();
            logger.info("<<--\u5b8c\u6210[\u4e91\u8d44\u6e90\u5230\u671f\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            logger.info("-->>\u6267\u884c[\u68c0\u67e5\u4e91\u8d44\u6e90\u5230\u671f\u8d44\u6e90\u5e76\u66f4\u65b0\u72b6\u6001]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4:{}--", (Object)LocalDateTime.now());
            this.orderCloudDeviceMapper.batchExpiredDevices();
            logger.info("-->>\u5b8c\u6210[\u68c0\u67e5\u4e91\u8d44\u6e90\u5230\u671f\u8d44\u6e90\u5e76\u66f4\u65b0\u72b6\u6001]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4:{}--", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u4eba\u5de5\u6388\u6743\u5f00\u901a]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-07", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void sendStopSyncImageEmail() {
        try {
            this.orderCloudDeviceService.sendStopSyncImageEmail();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u5fae\u8f6f\u4e91\u8d44\u6e90\u5230\u671f\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-08", expired=30L, autoDelete=false)
    @Async
    @Scheduled(cron="0 0 21 * * ?")
    public void handleServicerOrderDetail() {
        try {
            logger.info("-->>\u6267\u884c[\u529e\u7406\u670d\u52a1\u76d1\u7ba1]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            OrderConditionVO orderCondition = new OrderConditionVO();
            orderCondition.setServicer(Boolean.TRUE);
            orderCondition.setServiceStatusArr(Arrays.asList(0, 1, 2, 3));
            List orders = this.orderQueryService.getTenantOrders(orderCondition, 1, Integer.MAX_VALUE, "create_date desc");
            if (CollectionUtils.isEmpty((Collection)orders)) {
                return;
            }
            HashMap<String, List> orderVOMap = new HashMap<String, List>(16);
            for (OrderVO orderVO : orders) {
                int days;
                OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
                ServicerOrderDetailVO detailVO = orderDetailVO.getServicerOrderDetail();
                if (ServiceStatusEnum.WAITING_CONFIRMED.getValue().equals(detailVO.getServiceStatus())) {
                    days = (int)Duration.between(detailVO.getModifyDate().with(LocalTime.MIN), LocalDateTime.now().with(LocalTime.MIN)).toDays();
                    if (days == 7) {
                        this.mailService.sendEmailServicerOrderCheck(orderVO.getSid());
                    }
                    if (days < 14) continue;
                    String reason = I18nCode.CODE_SERVICER_ORDER_OVER_TIME_CONFIRM.getMessage();
                    ServicerOrderDetail detail = (ServicerOrderDetail)this.servicerOrderDetailCrudService.findBySid(detailVO.getSid().longValue());
                    if (GoodsCategoryEnum.PACKAGE.name().equalsIgnoreCase(orderDetailVO.getCategoryId())) {
                        detail.setServiceStatus(ServiceStatusEnum.COMPLETED.getValue());
                    } else if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(orderDetailVO.getCategoryId()) || GoodsCategoryEnum.APP.name().equalsIgnoreCase(orderDetailVO.getCategoryId())) {
                        if (Boolean.TRUE.equals(detail.getServiceComplete())) {
                            detail.setServiceStatus(ServiceStatusEnum.COMPLETED.getValue());
                        } else {
                            detail.setServiceStatus(ServiceStatusEnum.SERVICEING.getValue());
                        }
                    }
                    this.servicerOrderDetailCrudService.update((BaseEntity)detail);
                    if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(orderDetailVO.getCategoryId()) && ServiceStatusEnum.COMPLETED.getValue().equals(detail.getServiceStatus())) {
                        this.cacService.updateExpiredDateTime(new ProductTypeVO(orderVO.getTenantId(), orderVO.getOrderCode(), reason));
                    }
                    this.savaHandleOpLog(orderVO, detailVO, reason, detail);
                    this.mailService.sendEmailServicerOrderHandleResult(orderVO.getSid(), MailTypeEnum.ISV_ORDER_TENANT_CONFIRMED_EMAIL.name(), reason, Boolean.FALSE.booleanValue());
                    continue;
                }
                if (!ServiceStatusEnum.UNDELIVERED.getValue().equals(detailVO.getServiceStatus()) && !ServiceStatusEnum.REJECTED.getValue().equals(detailVO.getServiceStatus()) || (days = (int)Duration.between(detailVO.getCreateDate().with(LocalTime.MIN), LocalDateTime.now().with(LocalTime.MIN)).toDays()) != 7) continue;
                orderVOMap.computeIfAbsent(orderVO.getGoodsCode(), key -> new ArrayList()).add(orderVO);
            }
            if (!orderVOMap.isEmpty()) {
                this.mailService.sendEmailServicerOrderDeliverRemind(orderVOMap);
            }
            logger.info("<<--\u5b8c\u6210[\u529e\u7406\u670d\u52a1\u76d1\u7ba1]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u529e\u7406\u670d\u52a1\u76d1\u7ba1]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-09", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 1 * * ?")
    public void synchronousPurchaseDate() {
        try {
            if (StrUtils.isNotEmpty((String)this.envProperties.getSynchronousAreas()) && StrUtils.isNotEmpty((String)this.envProperties.getDeployArea()) && DeployAreaEnum.DevelopDev.equals((Object)DeployAreaEnum.valueOf((String)this.envProperties.getDeployArea()))) {
                String[] cloudAreas;
                SqlServerJdbcUtils sqlServerJdbcUtil = SqlServerJdbcUtils.create((String)this.envProperties.getSqlServerDbUrl(), (String)this.envProperties.getSqlServerDbUserName(), (String)this.envProperties.getSqlServerDbPassword());
                for (String area : cloudAreas = this.envProperties.getSynchronousAreas().split(";")) {
                    String uri = this.envSupport.getLocalUri(CommonCode.OMC, DeployAreaEnum.valueOf((String)area));
                    try {
                        String userToken = this.dapHttpService.getUserToken("99990000", this.envSupport.getLocalUri(CommonCode.IAM, DeployAreaEnum.valueOf((String)area)));
                        List purchaseVOList = this.omcService.getSynchronousPurchaseGoods(area, uri, userToken);
                        this.synchronousPurchaseGoods(purchaseVOList, sqlServerJdbcUtil, uri, userToken);
                    }
                    catch (Exception ex) {
                        logger.error("\u540c\u6b65{}\u51fa\u8d27\u4fe1\u606f\u5931\u8d25", (Object)uri, (Object)ex);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65{}\u51fa\u8d27\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void synchronousPurchaseGoods(List<PreOrderVO> purchaseVOList, SqlServerJdbcUtils sqlServerJdbcUtil, String cloudUri, String userToken) {
        block14: {
            try {
                DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyyMMdd");
                StringBuilder insertLicaSql = new StringBuilder();
                StringBuilder insertLicbSql = new StringBuilder();
                ArrayList<Long> purchaseSids = new ArrayList<Long>();
                for (PreOrderVO purchaseVO : purchaseVOList) {
                    if (StrUtils.isEmpty((String)purchaseVO.getPotentialCustomerId())) {
                        logger.error("\u51fa\u8d27\u4fe1\u606f{}\u7684\u6f5c\u5ba2\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object)JsonUtils.writeValue((Object)purchaseVO));
                        continue;
                    }
                    String remark = "";
                    if (ShippingTypeEnum.SHIPMENT.getValue().equals(purchaseVO.getShippingType())) {
                        remark = "Saas\u51fa\u8d27-\u51fa\u8d27";
                    } else if (ShippingTypeEnum.OTHER.getValue().equals(purchaseVO.getShippingType())) {
                        remark = "Saas\u51fa\u8d27-\u5176\u4ed6";
                    }
                    for (PreOrderDetailVO purchaseGoodVO : purchaseVO.getDetails()) {
                        String redisKey = String.format("omc:tenant:goods:number:%s::%s", purchaseVO.getPotentialCustomerId(), purchaseGoodVO.getGoodsProductCode());
                        Integer sequence = (Integer)RedisUtils.get((Object)redisKey, Integer.class);
                        if (sequence == null || sequence == 0) {
                            sequence = 1;
                            RedisUtils.set((String)redisKey, (Object)sequence);
                        } else {
                            Integer n = sequence;
                            Integer n2 = sequence = Integer.valueOf(sequence + 1);
                            RedisUtils.set((String)redisKey, (Object)sequence);
                        }
                        remark = String.format("%s%sU", remark, purchaseGoodVO.getTotalUsageBound());
                        String insertSql = String.format("insert into LICA(CA001,CA002,CA003,CA004,CA005,CA006,CA007,CA008,CA009,CA010,CA011,CA012,CA013,CA014,CA015,CA016,CA017,CA018,CA019,CA020,CA021,CA022,CA023,CA024,CA025,CA026,CA027,CA028,CA029,CA030,CA031,CA032,CA033,CA034,CA035,CA036,CA037,CA038,CA039,CA040) values(N'%s',N'%s',N'%s',N'0',N'1',N'%s',N'%s',N'%s',N'%s',N'%s','07',null,null,null,null,null,null,null,null,null,null,null,null,N'%s',N'%s',null,null,null,null,null,null,null,N'%s',N'%s',null,N'%s',null,null,1,N'%s');", purchaseVO.getPotentialCustomerId(), String.format("%04d", sequence), purchaseGoodVO.getGoodsProductCode(), purchaseGoodVO.getVersion(), purchaseGoodVO.getTotalUsageBound(), sdf.format(purchaseGoodVO.getEffectiveDateTime()), sdf.format(purchaseGoodVO.getEffectiveDateTime()), sdf.format(purchaseGoodVO.getEffectiveDateTime()), purchaseVO.getCustomerId(), purchaseVO.getTenantName(), purchaseVO.getCreateDate() == null ? null : sdf.format(purchaseVO.getCreateDate()), purchaseVO.getCreateById(), purchaseVO.getSourceBillCode(), remark);
                        insertLicaSql.append(insertSql);
                        logger.info(String.format("LICA\u540c\u6b65,%s", insertSql));
                        int sequeceNumber = 1;
                        for (AuthorizationModuleVO module : purchaseGoodVO.getModules()) {
                            insertSql = String.format("insert into LICB(CB001,CB002,CB003,CB004,CB005,CB006,CB007,CB008) values(N'%s',N'%s',N'%s',N'%s',N'%s',N'%s',null,%s);", purchaseVO.getPotentialCustomerId(), "0001", sequeceNumber, module.getId(), module.getName(), purchaseGoodVO.getGoodsProductCode(), purchaseGoodVO.getTotalUsageBound());
                            insertLicbSql.append(insertSql);
                            ++sequeceNumber;
                            logger.info(String.format("LICB\u540c\u6b65,%s", insertSql));
                        }
                    }
                    purchaseSids.add(purchaseVO.getSid());
                }
                if (insertLicaSql.length() <= 0) break block14;
                try {
                    sqlServerJdbcUtil.updateByPreparedStatement(insertLicaSql.toString(), null);
                    sqlServerJdbcUtil.updateByPreparedStatement(insertLicbSql.toString(), null);
                }
                catch (Exception ex) {
                    logger.error(String.format("\u540c\u6b65\u5931\u8d25,\u51fa\u8d27\u4e3b\u952e\uff1a{%s}\uff0cLICA\u8bed\u53e5\uff1a{%s},LICB:{%s},", purchaseSids.stream().map(Object::toString).collect(Collectors.joining(", ")), insertLicaSql, insertLicbSql), (Throwable)ex);
                }
                if (purchaseSids.size() > 0) {
                    this.omcService.batchUpdateSynchronousState(cloudUri, userToken, purchaseSids);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void savaHandleOpLog(OrderVO orderVO, ServicerOrderDetailVO detailVO, String reason, ServicerOrderDetail detail) {
        String fieldName = "fieldName";
        String displayName = "displayName";
        ModifiedInfoDTO dto = new ModifiedInfoDTO();
        dto.setActionId("openDeliver");
        dto.setEditPlace("console");
        dto.setEditUserId("admin");
        dto.setEditUserName("admin");
        dto.setTenantId(orderVO.getTenantId());
        dto.setTenantName(orderVO.getTenantName());
        ArrayList logFieldList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(fieldName, "date");
        map.put(displayName, "date");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "serviceStatus");
        map.put(displayName, "serviceStatus");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "fileList");
        map.put(displayName, "fileList");
        logFieldList.add(map);
        dto.setLogFieldList(logFieldList);
        HashMap<String, Object> originJson = new HashMap<String, Object>();
        originJson.put("date", "");
        originJson.put("serviceStatus", detailVO.getServiceStatus());
        originJson.put("remark", "");
        originJson.put("fileList", "");
        dto.setOriginJson(originJson);
        HashMap<String, Object> modifyJson = new HashMap<String, Object>();
        modifyJson.put("date", dateTimeFormatter.format(LocalDateTime.now()));
        modifyJson.put("serviceStatus", detail.getServiceStatus());
        modifyJson.put("remark", reason);
        modifyJson.put("fileList", detail.getAttachments());
        dto.setModifyJson(modifyJson);
        dto.setPrimaryKey(orderVO.getSid() + "");
        dto.setPrimaryKeyList(Collections.emptyList());
        dto.setRemark(reason);
        dto.setSource("omc");
        dto.setTableName("servicerOrderDetail");
        this.lmcService.dataComparison(dto, null, orderVO.getTenantId(), "ISV");
    }

    @CacheLock(prefix="omc-schedule-task-10", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 1 * * ?")
    public void sendBorrowMail() {
        logger.info("sendBorrowMail start");
        PreOrderDTO condition = new PreOrderDTO();
        HashSet<Integer> sendDaysBefore = new HashSet<Integer>(Arrays.asList(1, 2, 3, 7));
        condition.setExpiredDateTimeStartDate(LocalDateTime.of(LocalDate.now().plusDays(1L), LocalTime.of(0, 0, 0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        condition.setExpiredDateTimeEndDate(LocalDateTime.of(LocalDate.now().plusDays(7L), LocalTime.of(23, 59, 59)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        condition.setShipmentScenarios(Collections.singletonList(ShipmentScenarioEnum.BORROWING.getValue()));
        List borrows = this.preOrderMapper.getPreOrdersNoDataPolicy(condition);
        borrows.removeIf(a -> StringUtils.hasLength((String)a.getBundleCode()));
        if (borrows.isEmpty()) {
            logger.info("sendBorrowMail end,\u6ca1\u6709\u9700\u8981\u53d1\u9001\u7684");
            return;
        }
        ArrayList<BorrowNoticeListVO> raw = new ArrayList<BorrowNoticeListVO>();
        for (PreOrderVO preOrderVO : borrows) {
            boolean shouldNotSend;
            PreOrderVO vo = this.preOrderService.findPreOrderAndDtlBySid(preOrderVO.getSid());
            PreOrderDetailVO detail = vo.getFirstOrderDetail();
            int expireDays = (int)LocalDateTime.now().until(detail.getExpiredDateTime(), ChronoUnit.DAYS);
            boolean hasPending = this.hasPendingPreOrder(vo);
            boolean skipToday = !sendDaysBefore.contains(expireDays);
            boolean bl = shouldNotSend = skipToday || hasPending;
            if (shouldNotSend) {
                logger.info("\u5355\u53f7\uff1a{}\uff0c\u4e0d\u5e94\u53d1\u9001\uff0cskipToday:{},hasPending:{}", new Object[]{preOrderVO.getOrderCode(), skipToday, hasPending});
                continue;
            }
            BorrowNoticeListVO element = new BorrowNoticeListVO();
            String goodsCode = detail.getGoodsCode();
            element.setExpireDays(expireDays);
            element.setTenantId(preOrderVO.getTenantId());
            element.setTenantName(preOrderVO.getTenantName());
            element.setGoodsCode(goodsCode);
            element.setGoodsName(detail.getGoodsName());
            element.setPaymentTypeName((String)Optional.ofNullable(this.goodsMapper.findGoodsByCode(goodsCode)).map(Goods::getPaymentTypeName).orElse(null));
            element.setEffectiveDate(detail.getEffectiveDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            element.setExpireDate(detail.getExpiredDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            element.setOperatorMail(preOrderVO.getOperatorMail());
            raw.add(element);
        }
        for (List list : raw.stream().filter(a -> StringUtils.hasLength((String)a.getOperatorMail())).collect(Collectors.groupingBy(BorrowNoticeListVO::getOperatorMail)).values()) {
            this.groupByExpireDays(list).forEach(a -> this.mailService.sendBorrowNotice(a, MailTypeEnum.OMC_BORROW_NOTICE_INTERNAL.name()));
        }
        for (List list : raw.stream().collect(Collectors.groupingBy(BorrowNoticeListVO::getTenantId)).values()) {
            this.groupByExpireDays(list).forEach(a -> this.mailService.sendBorrowNotice(a, MailTypeEnum.OMC_BORROW_NOTICE_TENANT.name()));
        }
        logger.info("sendBorrowMail end");
    }

    private boolean hasPendingPreOrder(PreOrderVO borrow) {
        PreOrderDetailVO detail = borrow.getFirstOrderDetail();
        PreOrderDTO condition = new PreOrderDTO();
        condition.setTenantId(borrow.getTenantId());
        condition.setGoodsSid(detail.getGoodsSid());
        condition.setAuthorization(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue());
        condition.setExpiredDateTimeStartDate(DateUtil.format((LocalDateTime)detail.getExpiredDateTime(), (String)"yyyy-MM-dd HH:mm"));
        List waiting = this.preOrderMapper.getPreOrdersNoDataPolicy(condition);
        return !CollectionUtils.isEmpty((Collection)waiting);
    }

    private List<BorrowNoticeVO> groupByExpireDays(List<BorrowNoticeListVO> bySomething) {
        ArrayList<BorrowNoticeVO> result = new ArrayList<BorrowNoticeVO>();
        Map<Integer, List<BorrowNoticeListVO>> byExpireDays = bySomething.stream().collect(Collectors.groupingBy(BorrowNoticeListVO::getExpireDays));
        for (Map.Entry<Integer, List<BorrowNoticeListVO>> entry : byExpireDays.entrySet()) {
            BorrowNoticeVO emailVO = new BorrowNoticeVO();
            BorrowNoticeListVO random = entry.getValue().get(0);
            emailVO.setExpireDays(entry.getKey().intValue());
            emailVO.setTenantId(random.getTenantId());
            emailVO.setTenantName(random.getTenantName());
            emailVO.setEmail(random.getOperatorMail());
            emailVO.setList(entry.getValue());
            result.add(emailVO);
        }
        return result;
    }

    @CacheLock(prefix="omc-schedule-task-11", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void cloudDeviceExpire() {
        logger.info("cloudDeviceExpire start");
        DictDataDTO dictCondition = new DictDataDTO();
        dictCondition.setDictId("cloudDeviceExpireExpireGoods");
        List dictData = this.dictDataService.selectDictDataList(dictCondition);
        List goodsIds = dictData.stream().map(DictData::getDictKey).collect(Collectors.toList());
        if (goodsIds.isEmpty()) {
            logger.info("cloudDeviceExpire no goods");
            return;
        }
        LocalDateTime expireDay = LocalDateTime.now().minusDays(1L);
        String expireDayStr = DateUtil.format((LocalDateTime)expireDay, (String)"yyyy-MM-dd HH:mm:ss");
        CloudDeviceConditionVO condition = new CloudDeviceConditionVO();
        condition.setExpireDeviceGoodsCode(goodsIds);
        condition.setStartDate(expireDayStr);
        condition.setExpireDate(expireDayStr);
        List deviceClouds = this.orderCloudDeviceMapper.getDeviceClouds(condition, 1, 999, null);
        this.mailService.sendCloudDeviceExpireEmails(deviceClouds);
        logger.info("cloudDeviceExpire end");
    }

    @CacheLock(prefix="omc-schedule-task-12", expired=30L, autoDelete=false)
    @Scheduled(cron="0 30 0 * * ?")
    public void sendDeviceExpireEmail() {
        try {
            List devices = this.deviceMapper.findExpiringDevices();
            devices.removeIf(a -> !MailUtil.shouldSendToday((Integer)a.getExpiredDays(), (int)a.getNotificationCycle()));
            if (devices.isEmpty()) {
                logger.info("\u6ca1\u6709\u5373\u5c06\u5230\u671f\u7684\u8d44\u6e90");
                return;
            }
            List tenantIds = devices.stream().map(DeviceExpiringVO::getTenantId).distinct().collect(Collectors.toList());
            List tenantSimples = this.iamService.getTenantSimples(tenantIds);
            Map<String, String> tenantLanguageMap = tenantSimples.stream().filter(a -> StringUtils.hasLength((String)a.getDefaultLanguage())).collect(Collectors.toMap(CommonVO::getId, CommonVO::getDefaultLanguage));
            Map<String, Integer> totalMap = this.deviceMapper.findTenantDeviceTotal(tenantIds).stream().collect(Collectors.toMap(vo -> vo.getTenantId() + vo.getGoodsCode(), DeviceExpiringVO::getTotalCount, (k1, k2) -> k1));
            devices.forEach(a -> {
                a.setTotalCount((Integer)totalMap.get(a.getTenantId() + a.getGoodsCode()));
                a.setExpiredCount(Integer.valueOf(1));
            });
            Map<Integer, List<DeviceExpiringVO>> byExpireDays = devices.stream().collect(Collectors.groupingBy(DeviceExpiringVO::getExpiredDays));
            for (Map.Entry<Integer, List<DeviceExpiringVO>> entry : byExpireDays.entrySet()) {
                ArrayList<DeviceExpiringVO> mergedEntry = new ArrayList<DeviceExpiringVO>(entry.getValue().stream().collect(Collectors.toMap(g -> Arrays.asList(g.getTenantId(), g.getGoodsCode()), g -> g, (g1, g2) -> {
                    g1.setExpiredCount(Integer.valueOf(g1.getExpiredCount() + g2.getExpiredCount()));
                    return g1;
                })).values());
                Integer expireDays = entry.getKey();
                Map<String, List<DeviceExpiringVO>> byAdmin = mergedEntry.stream().filter(a -> StringUtils.hasLength((String)a.getAdminEmails())).collect(Collectors.groupingBy(DeviceExpiringVO::getAdminEmails));
                byAdmin.values().forEach(a -> this.mailService.sendDeviceExpireEmailsPM(expireDays, a));
                Map<String, List<DeviceExpiringVO>> byTenant = mergedEntry.stream().collect(Collectors.groupingBy(DeviceExpiringVO::getTenantId));
                byTenant.values().forEach(list -> {
                    String language = (String)tenantLanguageMap.get(((DeviceExpiringVO)list.get(0)).getTenantId());
                    this.putawayMessageService.invokeWithLocale(language, () -> this.mailService.sendDeviceExpireEmails(expireDays, list));
                });
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u4eba\u5de5\u6388\u6743\u5f00\u901a]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="omc-schedule-task-13", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 5 * * ?")
    public void generateBillOrder() {
        List bnplOrders = this.bnplOrderCrudService.findByStatusInAndNextBillDate(Arrays.asList(BnplOrderStatusEnum.ACTIVE.getCode(), BnplOrderStatusEnum.APPLY_TERMINATION.getCode()), LocalDate.now());
        for (BnplOrder bnplOrder : bnplOrders) {
            try {
                this.bnplOrderService.generateBillOrder(Long.valueOf(bnplOrder.getSid()));
            }
            catch (Exception e) {
                logger.error("[{}]\u8d26\u5355\u751f\u6210\u5931\u8d25", (Object)bnplOrder.getBnplCode(), (Object)e);
            }
        }
    }

    @CacheLock(prefix="omc-schedule-task-14", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 10 * ?")
    public void overdueBillNotification() {
        List orders = this.orderQueryService.listOrderDetailSimpleByCondition(Integer.valueOf(OrderTypeEnum.BILL.getValue()), Arrays.asList(OrderStatusEnum.Unpaid.getValue(), OrderStatusEnum.WaitPay.getValue()));
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return;
        }
        List unPaidPackOrderList = orders.stream().filter(x -> Objects.equals(x.getShopping(), OrderShoppingEnum.PACK.getCode()) && Objects.equals(x.getCategoryId(), "pack")).collect(Collectors.toList());
        List unPaidCommonOrderList = orders.stream().filter(x -> Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode()) && !StringUtils.hasLength((String)x.getCartCode())).collect(Collectors.toList());
        List unPaidOrderList = Stream.concat(unPaidPackOrderList.stream(), unPaidCommonOrderList.stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(unPaidOrderList)) {
            return;
        }
        DictDataDTO dictDataDTO = new DictDataDTO();
        dictDataDTO.setDictKey("billNotice");
        dictDataDTO.setDictId("billNotice");
        DictData dictData = this.dictDataService.selectDictData(dictDataDTO);
        if (Objects.isNull(dictData) || !StringUtils.hasLength((String)dictData.getDictValue())) {
            return;
        }
        int threshold = Integer.parseInt(dictData.getDictValue());
        List<Object> billOverdueDTOList = new ArrayList();
        for (OrderDetailSimpleDTO orderDetailSimpleDTO : unPaidOrderList) {
            long daysToExpire;
            if (orderDetailSimpleDTO.getCreateDate() == null || (daysToExpire = ChronoUnit.DAYS.between(orderDetailSimpleDTO.getCreateDate(), LocalDateTime.now())) < (long)threshold) continue;
            BillOverdueDTO billOverdueDTO = new BillOverdueDTO();
            billOverdueDTO.setOrderCode(orderDetailSimpleDTO.getOrderCode());
            billOverdueDTO.setTenantName(orderDetailSimpleDTO.getTenantName());
            billOverdueDTO.setTenantId(orderDetailSimpleDTO.getTenantId());
            billOverdueDTO.setGoodsCode(orderDetailSimpleDTO.getGoodsCode());
            billOverdueDTO.setGoodsName(orderDetailSimpleDTO.getGoodsName());
            billOverdueDTO.setStrategyName(orderDetailSimpleDTO.getStrategyName());
            billOverdueDTO.setBillDate(DateUtil.format((LocalDateTime)orderDetailSimpleDTO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            billOverdueDTO.setPayPrice(orderDetailSimpleDTO.getPayPrice().toString());
            billOverdueDTO.setOverdueDays(String.valueOf(daysToExpire));
            billOverdueDTOList.add(billOverdueDTO);
        }
        if (!CollectionUtils.isEmpty(billOverdueDTOList)) {
            billOverdueDTOList = billOverdueDTOList.stream().sorted((b1, b2) -> Integer.compare(Integer.parseInt(b2.getOverdueDays()), Integer.parseInt(b1.getOverdueDays()))).collect(Collectors.toList());
            BillOverdueNoticeDTO billOverdueNoticeDTO = new BillOverdueNoticeDTO();
            try {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = "bill_overdue_" + localTime + ".xlsx";
                File file = new File(fileName);
                InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/bill_overdue_export_template_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/bill_overdue_export_template_TW.xlsx").getInputStream();
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                excelWriter.write(billOverdueDTOList, writeSheet);
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(file.getName());
                fileInfo.setDisplayName(file.getName());
                fileInfo.setExtension("xlsx");
                fileInfo.setTenantId("99990000");
                String dmcFileId = this.dmcClient.upload(file, fileInfo).getId();
                LocalDateTime currentDateTime = LocalDateTime.now();
                LocalDateTime newDateTime = currentDateTime.plusDays(7L);
                String shareFileId = this.dmcClient.share(dmcFileId, newDateTime).getUrl();
                billOverdueNoticeDTO.setShareFileId(shareFileId);
            }
            catch (Exception e) {
                logger.error("\u903e\u671f\u672a\u652f\u4ed8\u8d26\u5355\u6570\u636e\u4e0a\u4f20dmc\u5f02\u5e38", (Throwable)e);
            }
            List top20BillOverdue = billOverdueDTOList.stream().sorted((b1, b2) -> Integer.compare(Integer.parseInt(b2.getOverdueDays()), Integer.parseInt(b1.getOverdueDays()))).limit(20L).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(top20BillOverdue)) {
                billOverdueNoticeDTO.setBillOverdueList(top20BillOverdue);
                billOverdueNoticeDTO.setThreshold(Integer.valueOf(threshold));
                this.mailService.sendOverdueBill(billOverdueNoticeDTO);
            }
        }
    }

    @CacheLock(prefix="omc-schedule-task-15", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 10 * * 1")
    public void sendCloudDeviceExpire() {
        CloudDeviceConditionVO condition = new CloudDeviceConditionVO();
        condition.setState(CloudDeviceStateEnum.EXPIRED.getValue());
        condition.setDisabled(Boolean.valueOf(false));
        List orderCloudDeviceVOS = this.orderCloudDeviceMapper.getDeviceClouds(condition);
        this.orderCloudDeviceService.populateCustomAttributes(orderCloudDeviceVOS);
        this.mailService.sendCloudDeviceTerminateNotice(orderCloudDeviceVOS);
    }

    @CacheLock(prefix="omc-schedule-task-17", expired=30L, autoDelete=false)
    @Scheduled(cron="0 20 0 * * ?")
    public void sendUnTossOrderNotification() {
        List orderDetails = this.orderQueryService.getUnTossOrders();
        this.mailService.sendUnTossOrderNotification(orderDetails);
    }

    @CacheLock(prefix="omc-schedule-task-18", expired=30L, autoDelete=false)
    @Scheduled(cron="0 20 0 * * ?")
    public void sendTossFailedOrderNotification() {
        List orderDetails = this.orderQueryService.getTossFailedOrders();
        this.mailService.sendTossFailedOrderNotification(orderDetails);
    }
}

