/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.stream.impl;

import com.digiwin.dap.middle.stream.consumer.ConsumerService;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.omc.constant.enums.TenantChangeType;
import com.digiwin.dap.middleware.omc.domain.stream.TenantChangeInfoDTO;
import com.digiwin.dap.middleware.omc.service.tenant.TenantSyncService;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ConsumerServiceImpl
implements ConsumerService {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerServiceImpl.class);
    @Autowired
    private TenantSyncService tenantSyncService;
    @Autowired
    private DapHttpService dapHttpService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(target="InternalInput", condition="headers['tag']=='tenantInfoChange'")
    public void receiveDmcResourceGoodsPurchase(Message<String> message) {
        try {
            MessageBody messageBody = (MessageBody)JsonUtils.jsonToObj((String)((String)message.getPayload()), MessageBody.class);
            TenantChangeInfoDTO tenantChangeInfoDTO = (TenantChangeInfoDTO)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)messageBody.getData()), TenantChangeInfoDTO.class);
            logger.info("receive tenantInfoChange:{}", (Object)JsonUtils.objToJson((Object)tenantChangeInfoDTO));
            if (!Objects.equals(TenantChangeType.DELETE.getValue(), tenantChangeInfoDTO.getChangeType()) && StringUtils.hasText((String)tenantChangeInfoDTO.getTenantId())) {
                String userToken = this.dapHttpService.getUserToken(tenantChangeInfoDTO.getTenantId());
                AuthoredUser userInfo = this.dapHttpService.getUserInfo(userToken);
                AppAuthContextHolder.getContext().setAuthoredUser(userInfo);
            }
            this.tenantSyncService.syncTenantInfo(tenantChangeInfoDTO);
        }
        catch (Exception e) {
            logger.error("Consume finished with exception", (Throwable)e);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }
}

