/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.test.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.remote.PayQuery;
import com.digiwin.dap.middleware.omc.domain.request.QueryOrderParmVO;
import com.digiwin.dap.middleware.omc.domain.response.BaseResult;
import com.digiwin.dap.middleware.omc.domain.response.PayResult;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderSyncMapper;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.schedule.ScheduleTaskService;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TestController {
    @Autowired
    private IamService iamService;
    @Autowired
    private DwPayService payService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private OrderSyncMapper orderSyncMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;
    @Autowired
    private ScheduleTaskService scheduleTaskService;

    @RequestMapping(value={"/api/omc/v2/test"})
    public ResponseEntity<?> test(@RequestBody Map<String, String> data) {
        TenantVO tenantVO = this.iamService.getTenantSimple(data.get("tenantId"), 0L);
        return ResponseEntity.ok((Object)tenantVO);
    }

    @GetMapping(value={"/api/omc/v2/test/1"})
    public ResponseEntity<?> test1() {
        this.scheduleTaskService.manualAuthorization();
        return ResponseEntity.ok((Object)"ok");
    }

    @GetMapping(value={"/api/omc/v2/test/2"})
    public ResponseEntity<?> test2() {
        this.scheduleTaskService.sendBorrowMail();
        return ResponseEntity.ok((Object)"ok");
    }

    @GetMapping(value={"/api/omc/v2/test/3"})
    public ResponseEntity<?> test3() {
        this.scheduleTaskService.cloudDeviceExpire();
        return ResponseEntity.ok((Object)"ok");
    }

    @GetMapping(value={"/api/omc/v2/test/invoke/scheduleTask/{methodName}"})
    public ResponseEntity<?> invokeScheduleTask(@PathVariable String methodName) {
        try {
            Method method = this.scheduleTaskService.getClass().getMethod(methodName, new Class[0]);
            method.invoke((Object)this.scheduleTaskService, new Object[0]);
            return ResponseEntity.ok((Object)"ok");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("\u8c03\u7528\u5931\u8d25: " + e.getMessage()));
        }
    }

    @RequestMapping(value={"/api/omc/v2/env/mail/{orderCode}"})
    public ResponseEntity<?> mail(@PathVariable String orderCode) {
        Order order = this.orderCrudService.findByOrderCode(orderCode);
        if (null != order) {
            this.mailService.sendEmailSubmitOrder(order.getSid());
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/api/omc/v2/autotest/orders/{sid}/payment/success"}, method={RequestMethod.POST})
    public ResponseEntity<?> finishPay(@PathVariable(name="sid") Long sid) {
        Order order = (Order)this.orderCrudService.findBySid(sid.longValue());
        this.paymentService.createPayment(order.getSid(), order.getPayPrice(), PaymentTypeEnum.AutoTest);
        order.setOrderStatus(Integer.valueOf(1));
        order.setAuthorization(true);
        order.setInitialize(Integer.valueOf(1));
        this.orderCrudService.update((BaseEntity)order);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/api/omc/v2/orders/period/success"})
    public ResponseEntity<?> sendTossOverPeriod(@RequestBody QueryOrderParmVO body) {
        String startTimeStr = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(body.getStartTime());
        String endTimeStr = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(body.getEndTime());
        List orderInfoList = this.orderSyncMapper.findTossOrdersOverPeriod(startTimeStr, endTimeStr);
        return ResponseEntity.ok((Object)orderInfoList);
    }

    @PostMapping(value={"/api/omc/v2/orders/period/success/email"})
    public ResponseEntity<?> getTossOverPeriod(@RequestBody QueryOrderParmVO body) {
        this.mailService.sendTossOverPeriod(body.getStartTime(), body.getEndTime());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/api/sales/checkIsPurchaseCloudgoods"})
    public ResponseEntity<?> checkByGoodsSid(@RequestParam(name="cloudgoodsId") long goodsSid) {
        boolean exists = this.orderMapper.existsByGoodsSid(goodsSid);
        int check = exists ? 1 : 0;
        return ResponseEntity.ok((Object)new BaseResult("200", Integer.toString(check)));
    }

    @RequestMapping(value={"/api/sales/checkIsPurchaseSalesProgram"}, method={RequestMethod.GET})
    public ResponseEntity<?> checkByStrategySid(@RequestParam(name="salesProgramId") long strategySid) {
        int count = this.orderMapper.countByStrategySid(strategySid);
        int check = count > 0 ? 1 : 0;
        return ResponseEntity.ok((Object)new BaseResult("200", Integer.toString(check)));
    }

    @RequestMapping(value={"/api/sales/checkOrderIsPaySucceed"}, method={RequestMethod.GET})
    public ResponseEntity<?> checkOrderPaySuccess(@RequestParam(name="orderCode") String orderCode, @RequestParam(required=false, name="userId") String userId) {
        PayResult baseResult = this.checkOrderPay(orderCode);
        return ResponseEntity.ok((Object)baseResult);
    }

    @RequestMapping(value={"/api/omc/v2/env/mail/toenable"}, method={RequestMethod.POST})
    public ResponseEntity<?> checkOrderPaySuccess(@RequestParam(name="searchTime") String searchTime) {
        LocalDate beginDateTime = LocalDate.parse(searchTime, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        this.mailService.sendGoodsToEnableEmail(beginDateTime);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/api/sales/orderPayWithBackUrl"})
    public ResponseEntity<?> getPayUrl(@RequestParam(name="orderCode") String orderCode, @RequestParam(required=false) String backUrl) {
        BaseResult baseResult = this.getPayUri(orderCode, backUrl);
        return ResponseEntity.ok((Object)baseResult);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/api/sales/cancelOrder"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> cancelOrder(@NotNull @RequestParam(name="orderId") Long orderSid, @RequestParam(required=false, name="orderCode") String orderCode) {
        this.orderService.cancelOrder(orderSid.longValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    private PayResult checkOrderPay(String orderCode) {
        PayResult baseResult = new PayResult();
        TradeInfo entity = this.payService.queryPayInfo(orderCode);
        if (entity != null) {
            baseResult.setData("True");
            baseResult.setPayQuery(new PayQuery(entity.getTradeStatus(), entity.getPaymentType()));
        } else {
            baseResult.setData("False");
            baseResult.setErrMsg("\u83b7\u53d6\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        return baseResult;
    }

    private BaseResult getPayUri(String orderCode, String backUrl) {
        Order order = this.orderCrudService.findByOrderCode(orderCode);
        if (null != order) {
            boolean result = this.goodsMapper.existsOnSaleByGoodsCode(order.getGoodsCode());
            if (!result) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_50002);
            }
            StdData payReturnEntity = this.payService.tradePay(order.getOrderCode(), order.getPayPrice(), backUrl, Boolean.valueOf(false));
            return this.handlePayResult(payReturnEntity);
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{orderCode});
    }

    private BaseResult handlePayResult(StdData<String> entity) {
        BaseResult baseResult = new BaseResult();
        if (null != entity) {
            if (entity.getSuccess().booleanValue() && null != entity.getData()) {
                baseResult.setCode("200");
                baseResult.setData((String)entity.getData());
            } else {
                baseResult.setCode("500");
                baseResult.setErrMsg(entity.getMessage());
            }
        }
        return baseResult;
    }

    @GetMapping(value={"/api/omc/v2/test/sendEmailExpiredCloudDevice"})
    public StdData<?> sendEmailExpiredCloudDeviceTest() {
        this.orderCloudDeviceService.checkExpiredCloudDevice();
        return StdData.ok().build();
    }
}

