/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.tsign;

import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.support.tsign.service.OpenTreatyService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
public class TsignRetrofitConfig {
    @Autowired
    private EnvProperties envProperties;

    @Bean
    @ConditionalOnProperty(prefix="dap.middleware", name={"cloud"}, havingValue="0")
    public Retrofit tsignSdkApiRetrofit() {
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)JsonUtils.createObjectMapper())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.getOkHttpClient()).baseUrl(this.envProperties.getTsignUri()).build();
    }

    @Bean
    @ConditionalOnBean(value={Retrofit.class})
    public OpenTreatyService opentreatyService(Retrofit retrofit) {
        return (OpenTreatyService)retrofit.create(OpenTreatyService.class);
    }

    private OkHttpClient getOkHttpClient() {
        return new OkHttpClient().newBuilder().addInterceptor(chain -> {
            Request originalRequest = chain.request();
            Request.Builder builder = originalRequest.newBuilder().header("X-Tsign-Open-App-Id", this.envProperties.getTsignAppId()).header("X-Tsign-Open-App-Secret", this.envProperties.getTsignAppSecret());
            Request newRequest = builder.build();
            return chain.proceed(newRequest);
        }).build();
    }
}

