/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.tsign.api;

import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.entity.ContractFile;
import com.digiwin.dap.middleware.omc.repository.ContractFileRepository;
import com.digiwin.dap.middleware.omc.support.tsign.domain.BaseTsign;
import com.digiwin.dap.middleware.omc.support.tsign.domain.DocTemplateVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.DocUploadVO;
import com.digiwin.dap.middleware.omc.support.tsign.exception.TsignException;
import com.digiwin.dap.middleware.omc.support.tsign.service.OpenTreatyService;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.time.LocalDateTime;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/omc/v2/contract/file"})
public class ContractFileController {
    @Autowired(required=false)
    private OpenTreatyService openTreatyService;
    @Autowired
    private ContractFileRepository contractFileRepository;

    @GetMapping
    public ResponseEntity<?> findContractFile() {
        return ResponseEntity.ok((Object)this.contractFileRepository.findFirstOrderBySid());
    }

    @PostMapping
    public ResponseEntity<?> uploadTemplate(@RequestPart(value="file") MultipartFile file) {
        return ResponseEntity.ok((Object)this.uploadTsign(file));
    }

    private ContractFile uploadTsign(MultipartFile file) {
        DocUploadVO docUploadVO = new DocUploadVO();
        docUploadVO.setFileName(file.getOriginalFilename());
        try {
            docUploadVO.setContentMd5(DigestUtils.md5((byte[])file.getBytes()));
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_90006);
        }
        docUploadVO.setContentType(file.getContentType());
        docUploadVO.setFileSize(file.getSize());
        TsignException tsignException = new TsignException();
        ContractFile contractFile = new ContractFile();
        this.openTreatyService.createContractFile(docUploadVO).subscribe(docUpload -> {
            Object data = docUpload.getData();
            if (data != null) {
                contractFile.setFileKey(docUpload.getFileKey());
                contractFile.setUploadUrl(docUpload.getUploadUrl());
            }
        }, (Consumer)tsignException, () -> {
            contractFile.setFileName(docUploadVO.getFileName());
            contractFile.setContentMd5(docUploadVO.getContentMd5());
            contractFile.setContentType(docUploadVO.getContentType());
            RequestBody fileBytes = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])file.getBytes());
            this.openTreatyService.uploadContractFile(contractFile.getUploadUrl(), contractFile.getContentMd5(), contractFile.getContentType(), fileBytes).subscribe(BaseTsign::checkHasError, (Consumer)tsignException, () -> {
                contractFile.setIsUploadFile("1");
                contractFile.setUploadDate(LocalDateTime.now());
                DocTemplateVO docTemplateVO = new DocTemplateVO();
                docTemplateVO.setFileKey(contractFile.getFileKey());
                docTemplateVO.setTemplateName("digiwin_" + System.currentTimeMillis());
                this.openTreatyService.createContractFileTemplate(docTemplateVO).subscribe(docTemplate -> {
                    contractFile.setTemplateId(docTemplate.getTemplateId());
                    contractFile.setTemplateDate(LocalDateTime.now());
                }, (Consumer)tsignException, () -> {
                    ContractFile cfr_ignored_0 = (ContractFile)this.contractFileRepository.save((Object)contractFile);
                });
            });
        });
        tsignException.throwException();
        return contractFile;
    }
}

