/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.tsign.exception;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.support.tsign.exception.BaseExceptionResult;
import com.digiwin.dap.middleware.util.JsonUtils;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.util.Optional;
import retrofit2.HttpException;

public final class TsignException<T extends Throwable>
implements Consumer<T> {
    private boolean isPrintError;
    private BusinessException errorContent;

    public TsignException() {
        this.isPrintError = Boolean.FALSE;
    }

    public TsignException(boolean isPrintError) {
        this.isPrintError = isPrintError;
    }

    public BusinessException getErrorContent() {
        return this.errorContent;
    }

    public boolean isOccurError() {
        return Optional.ofNullable(this.errorContent).isPresent();
    }

    public void throwException() {
        Optional.ofNullable(this.errorContent).ifPresent(e -> {
            throw e;
        });
    }

    public void accept(T t) {
        if (t instanceof HttpException) {
            HttpException he = (HttpException)t;
            BaseExceptionResult errorResult = this.parserErrorJson(he);
            this.errorContent = new BusinessException(errorResult.getMessage());
        } else {
            this.errorContent = new BusinessException(t);
        }
        if (this.isPrintError) {
            this.errorContent.printStackTrace();
        }
    }

    private BaseExceptionResult parserErrorJson(HttpException he) {
        try {
            String errorJson = he.response().errorBody().string();
            return (BaseExceptionResult)JsonUtils.createObjectMapper().readValue(errorJson, BaseExceptionResult.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BaseExceptionResult();
        }
    }
}

