/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.tsign.service.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.entity.Contract;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.repository.ContractRepository;
import com.digiwin.dap.middleware.omc.support.tsign.domain.DmcUploadResult;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignFinishResult;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignFinishVO;
import com.digiwin.dap.middleware.omc.support.tsign.exception.TsignException;
import com.digiwin.dap.middleware.omc.support.tsign.service.DmcService;
import com.digiwin.dap.middleware.omc.support.tsign.service.OpenTreatyService;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import java.io.InputStream;
import okhttp3.ResponseBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DmcServiceImpl
implements DmcService {
    @Autowired(required=false)
    private DMC omcDmcClient;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired(required=false)
    private OpenTreatyService openTreatyService;

    public void uploadContract(long contractSid) {
        Contract contract = this.contractRepository.findById((Object)contractSid).orElseGet(() -> {
            throw new BusinessException("[UploadDmc]Not Found Contract");
        });
        SignFinishVO signFinishVO = new SignFinishVO();
        signFinishVO.setFlowId(contract.getFlowId());
        TsignException tsignException = new TsignException();
        this.openTreatyService.getSignContractUrl(signFinishVO).flatMap(signFinishResult -> Observable.fromArray((Object[])signFinishResult.getSignFinishInfos().toArray(new SignFinishResult.SignFinishInfo[0]))).flatMap(signFinishInfo -> {
            contract.setDocUrl(signFinishInfo.getDocUrl());
            return this.openTreatyService.downloadContractFile(signFinishInfo.getDocUrl());
        }).subscribe(response -> this.uploadContract((ResponseBody)response.body(), contract), (Consumer)tsignException, () -> {
            Contract cfr_ignored_0 = (Contract)this.contractRepository.save((Object)contract);
        });
        tsignException.throwException();
    }

    private void uploadContract(ResponseBody responseBody, Contract contract) {
        DmcUploadResult fileResult = this.uploadContract(contract.getOrderSid().longValue(), responseBody.byteStream());
        contract.setUploadFileId(fileResult.getFileId());
        contract.setUploadFileUrl(fileResult.getUrl());
    }

    public DmcUploadResult uploadContract(long orderSid, InputStream fileStream) {
        DmcUploadResult dmcUploadResult = new DmcUploadResult();
        try {
            Order order = (Order)this.orderCrudService.findBySid(orderSid);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName("\u9f0e\u6377\u4e91\u5e02\u573a\u8ba2\u8d2d\u5355.pdf");
            fileInfo.setExtension("pdf");
            fileInfo.setContentType("application/pdf");
            fileInfo.setTenantId(order == null ? GlobalConstants.HTTP_HEADER_TENANT_ID_KEY : order.getTenantId());
            FileInfo upload = this.omcDmcClient.upload(fileStream, fileInfo);
            ShareInfo shareInfo = this.omcDmcClient.share(upload.getId());
            dmcUploadResult.setFileId(shareInfo.getFileId());
            dmcUploadResult.setUrl(shareInfo.getUrl());
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230DMC\u5931\u8d25", (Throwable)e);
        }
        return dmcUploadResult;
    }
}

