/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.tsign.service.impl;

import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.order.ContractService;
import com.digiwin.dap.middleware.omc.support.tsign.domain.ContractInfoVO;
import com.digiwin.dap.middleware.omc.support.tsign.service.DmcService;
import com.digiwin.dap.middleware.omc.support.tsign.service.TsignService;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Primary
@Service
public class TsignContractServiceImpl
implements ContractService {
    private static final Logger logger = LoggerFactory.getLogger(TsignContractServiceImpl.class);
    @Autowired
    private DmcService dmcService;
    @Autowired
    private TsignService tsignService;
    @Autowired
    private EnvProperties envProperties;

    private static boolean checkAccountId(String accountId) {
        return accountId != null && !"".equals(accountId) && !"User Non Verified".equals(accountId);
    }

    @Async
    public void createContractAsync(OrderVO order, String userToken) {
        this.createContract(order, userToken);
    }

    public long createContract(OrderVO order, String userToken) {
        long contractSid = 0L;
        try {
            if (Locale.SIMPLIFIED_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
                ContractInfoVO contractInfo = this.tsignService.buildContractData(order, userToken);
                contractSid = this.tsignService.createContract(contractInfo);
                String accountId = contractInfo.getAccountId();
                this.tsignService.signFlow(contractSid);
                if (TsignContractServiceImpl.checkAccountId((String)accountId)) {
                    this.tsignService.signSilent(accountId);
                }
                this.tsignService.signCompany(contractSid);
                if (TsignContractServiceImpl.checkAccountId((String)accountId)) {
                    this.tsignService.signCustomer(contractSid, accountId);
                }
                this.tsignService.signArchive(contractSid);
                this.dmcService.uploadContract(contractSid);
            }
        }
        catch (Exception e) {
            logger.error("\u3010Tsign\u3011\u521b\u5efa\u5408\u540c\u5931\u8d25", (Throwable)e);
        }
        return contractSid;
    }
}

