/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.tsign.service.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Contract;
import com.digiwin.dap.middleware.omc.entity.ContractFile;
import com.digiwin.dap.middleware.omc.mapper.ContractMapper;
import com.digiwin.dap.middleware.omc.repository.ContractFileRepository;
import com.digiwin.dap.middleware.omc.repository.ContractRepository;
import com.digiwin.dap.middleware.omc.support.esign.domain.Meta;
import com.digiwin.dap.middleware.omc.support.esign.domain.Verification;
import com.digiwin.dap.middleware.omc.support.esign.service.VerifyService;
import com.digiwin.dap.middleware.omc.support.tsign.domain.ContractInfoVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.ContractTemplateVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignArchiveVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignCompanyVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignContractVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignCustomerVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignFlowVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignPosition;
import com.digiwin.dap.middleware.omc.support.tsign.domain.SignSilentVO;
import com.digiwin.dap.middleware.omc.support.tsign.domain.TsignConstant;
import com.digiwin.dap.middleware.omc.support.tsign.exception.TsignException;
import com.digiwin.dap.middleware.omc.support.tsign.service.OpenTreatyService;
import com.digiwin.dap.middleware.omc.support.tsign.service.TsignService;
import com.digiwin.dap.middleware.util.JsonUtils;
import io.reactivex.functions.Consumer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TsignServiceImpl
implements TsignService {
    @Autowired
    private VerifyService verifyService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired(required=false)
    private OpenTreatyService openTreatyService;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private ContractFileRepository contractFileRepository;

    public ContractInfoVO buildContractData(OrderVO order, String userToken) {
        Map<String, String> metas = this.contractMapper.findByType(Integer.valueOf(2)).stream().collect(Collectors.toMap(Meta::getId, Meta::getValue));
        ContractInfoVO contractInfo = new ContractInfoVO();
        contractInfo.setSeller(metas.get("seller"));
        contractInfo.setSellerAddress(metas.get("sellerAddress"));
        contractInfo.setSellerName(metas.get("sellerName"));
        contractInfo.setSellerTelephone(metas.get("sellerTelephone"));
        contractInfo.setAccountName(metas.get("accountName"));
        contractInfo.setBankName(metas.get("bankName"));
        contractInfo.setBankAccount(metas.get("bankAccount"));
        Verification verify = this.verifyService.getVerify(userToken);
        if (verify == null) {
            contractInfo.setBuyer(order.getTenantName());
            contractInfo.setBuyerAddress(order.getInvoice() == null ? null : order.getInvoice().getCompanyAddress());
            contractInfo.setBuyerName(order.getUserName());
            contractInfo.setBuyerTelephone(order.getTelephone());
        } else {
            contractInfo.setAccountId(verify.getAccount());
            contractInfo.setBuyer(verify.getAccountTenantName());
            contractInfo.setBuyerAddress(verify.getTenantAddress());
            contractInfo.setBuyerName(verify.getAccountName());
            contractInfo.setBuyerTelephone(verify.getAccountTelephone());
        }
        this.buildOrderData(order, contractInfo);
        return contractInfo;
    }

    private void buildOrderData(OrderVO order, ContractInfoVO contractInfoVO) {
        contractInfoVO.setOrderSid(order.getSid() + "");
        contractInfoVO.setOrderNo(order.getOrderCode());
        if (order.getOrderDetails().size() > TsignConstant.MAX_ITEM_NUM) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20001);
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        int i = 1;
        for (OrderDetailVO detail : order.getOrderDetails()) {
            for (OrderDetailItemVO item : detail.getItems()) {
                itemMap.put("num" + i, String.valueOf(i));
                itemMap.put("itemName" + i, item.getItemName());
                itemMap.put("quantity" + i, detail.getQuantity().toString());
                itemMap.put("unit" + i, item.getUnit());
                itemMap.put("price" + i, item.getUnitPrice().setScale(2, 6).toString());
                itemMap.put("payPrice" + i, item.getPayPrice().setScale(2, 6).toString());
                ++i;
            }
        }
        contractInfoVO.setBuyerDate(contractInfoVO.getAccountId() == null ? null : LocalDate.now());
        contractInfoVO.setSellerDate(LocalDate.now());
        contractInfoVO.getFormData().putAll(JsonUtils.objToMap((Object)contractInfoVO));
        contractInfoVO.getFormData().putAll(itemMap);
    }

    public long createContract(ContractInfoVO contractInfoVO) {
        ContractFile contractFile = this.contractFileRepository.findFirstOrderBySid();
        if (contractFile == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20003);
        }
        ContractTemplateVO req = new ContractTemplateVO();
        req.setTemplateId(contractFile.getTemplateId());
        req.setName("\u9f0e\u6377\u4e91\u5e02\u573a\u8ba2\u8d2d\u5355");
        req.setSimpleFormFields(contractInfoVO.getFormData());
        Contract contract = new Contract();
        SignContractVO result = new SignContractVO();
        TsignException tsignException = new TsignException();
        this.openTreatyService.createContractByTemplate(req).subscribe(contractTemplateRes -> {
            contract.setOrderSid(Long.valueOf(Long.parseLong(contractInfoVO.getOrderSid())));
            contract.setAccountId(contractInfoVO.getAccountId() == null ? "User Non Verified" : contractInfoVO.getAccountId());
            contract.setDocId(contractTemplateRes.getDocId());
            contract.setDocUrl(contractTemplateRes.getDocUrl());
            contract.setDocContent(JsonUtils.objToJson((Object)contractInfoVO.getFormData()));
            contract.setCreateDate(LocalDateTime.now());
            contract.setContractArea(this.envProperties.getCountry());
            long contractSid = ((Contract)this.contractRepository.save((Object)contract)).getSid();
            result.setContractSid(contractSid);
        }, (Consumer)tsignException);
        tsignException.throwException();
        return result.getContractSid();
    }

    public void signFlow(long contractSid) {
        Contract contract = this.contractRepository.findById((Object)contractSid).orElseGet(() -> {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20002, new Object[]{"CreateSign", contractSid});
        });
        SignFlowVO req = new SignFlowVO();
        req.setBusinessScene("\u9f0e\u6377\u4e91\u5e02\u573a\u8ba2\u8d2d\u5355");
        req.setDocId(contract.getDocId());
        req.setDocName("\u9f0e\u6377\u4e91\u5e02\u573a\u8ba2\u8d2d\u5355");
        TsignException tsignException = new TsignException();
        this.openTreatyService.signFlow(req).subscribe(signFlowRes -> {
            contract.setFlowId(signFlowRes.getFlowId());
            contract.setFlowCreateDate(LocalDateTime.now());
            this.contractRepository.save((Object)contract);
        }, (Consumer)tsignException);
        tsignException.throwException();
    }

    public void signSilent(String accountId) {
        SignSilentVO signSilentVO = new SignSilentVO();
        signSilentVO.setGrantAccountId(accountId);
        TsignException tsignException = new TsignException();
        this.openTreatyService.signSilent(signSilentVO).subscribe(signSilentRes -> signSilentRes.checkHasError(), (Consumer)tsignException);
        tsignException.throwException();
    }

    public void signCompany(long contractSid) {
        Contract contract = this.contractRepository.findById((Object)contractSid).orElseGet(() -> {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20002, new Object[]{"CompanySign", contractSid});
        });
        SignCompanyVO req = new SignCompanyVO();
        req.setFlowId(contract.getFlowId());
        req.getPosList().add(new SignPosition());
        ((SignPosition)req.getPosList().get(0)).setSignType(1);
        ((SignPosition)req.getPosList().get(0)).setKey("\u4f9b\u65b9\u76d6\u7ae0");
        TsignException tsignException = new TsignException();
        this.openTreatyService.signCompany(req).subscribe(signCompanyRes -> {
            contract.setCompanySignDate(LocalDateTime.now());
            this.contractRepository.save((Object)contract);
        }, (Consumer)tsignException);
        tsignException.throwException();
    }

    public void signCustomer(long contractSid, String accountId) {
        Contract contract = this.contractRepository.findById((Object)contractSid).orElseGet(() -> {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20002, new Object[]{"CustomerSign", contractSid});
        });
        SignCustomerVO req = new SignCustomerVO();
        req.setAccountId(accountId);
        req.setFlowId(contract.getFlowId());
        req.getPosList().add(new SignPosition());
        ((SignPosition)req.getPosList().get(0)).setSignType(1);
        ((SignPosition)req.getPosList().get(0)).setKey("\u9700\u65b9\u76d6\u7ae0");
        TsignException tsignException = new TsignException();
        this.openTreatyService.signCustomer(req).subscribe(signCustomerRes -> {
            contract.setCustomerSignDate(LocalDateTime.now());
            this.contractRepository.save((Object)contract);
        }, (Consumer)tsignException);
        tsignException.throwException();
    }

    public void signArchive(long contractSid) {
        Contract contract = this.contractRepository.findById((Object)contractSid).orElseGet(() -> {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20002, new Object[]{"ArchiveSign", contractSid});
        });
        SignArchiveVO req = new SignArchiveVO();
        req.setFlowId(contract.getFlowId());
        TsignException tsignException = new TsignException();
        this.openTreatyService.signArchive(req).subscribe(signArchiveRes -> signArchiveRes.checkHasError(), (Consumer)tsignException);
        tsignException.throwException();
    }
}

