/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.mapper.PreOrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.repository.OrderDeviceRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=43608)
public class UpgradeDatabaseV43607TV43608Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43607TV43608Service.class);
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private PreOrderDetailMapper preOrderDetailMapper;
    @Autowired
    private OrderDeviceRepository orderDeviceRepository;

    public String version() {
        return "4.36.8.0";
    }

    public void update() {
        LOGGER.info("436800\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.updateDeviceExpireTime();
        LOGGER.info("436800\uff0c\u5347\u7ea7\u7ed3\u675f --->>>");
    }

    private void updateDeviceExpireTime() {
        PreOrderDTO condition = new PreOrderDTO();
        condition.setGoodsCode("EDGE");
        List preOrders = this.preOrderMapper.getPreOrdersNoDataPolicy(condition);
        if (preOrders.isEmpty()) {
            return;
        }
        Map<Long, List<PreOrderDetailVO>> detailMap = this.preOrderDetailMapper.batchGetPreOrderDetails(preOrders.stream().map(PreOrderVO::getSid).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(PreOrderDetailVO::getOrderSid));
        preOrders.forEach(a -> a.setDetails((List)detailMap.get(a.getSid())));
        for (PreOrderVO preOrder : preOrders) {
            List devices = this.orderDeviceRepository.findByOrderSid(preOrder.getSid().longValue());
            if (devices.isEmpty()) continue;
            LocalDateTime expiredDateTime = preOrder.getFirstOrderDetail().getExpiredDateTime();
            devices.removeIf(a -> a.getExpireDate() != null);
            devices.forEach(a -> {
                a.setExpireDate(expiredDateTime);
                EntityUtils.setModifyFields((BaseEntity)a);
            });
            LOGGER.info("preOrder:{} device count:{},expireTime set to {}", new Object[]{preOrder.getOrderCode(), devices.size(), expiredDateTime});
            this.orderDeviceRepository.saveAll((Iterable)devices);
        }
    }
}

