/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceSourceEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCloudDeviceCrudService;
import com.digiwin.dap.middleware.omc.dao.PreOrderCrudService;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.entity.PreOrder;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43612)
@Service
public class UpgradeDatabaseV43611ToV43612Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43611ToV43612Service.class);
    @Autowired
    private OrderCloudDeviceCrudService orderCloudDeviceCrudService;
    @Autowired
    private PreOrderCrudService preOrderCrudService;

    public String version() {
        return "4.36.12.0";
    }

    public void update() {
        LOGGER.info("4361200\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        List all = this.orderCloudDeviceCrudService.findAll();
        for (OrderCloudDevice orderCloudDevice : all) {
            PreOrder bySid = (PreOrder)this.preOrderCrudService.findBySid(orderCloudDevice.getOrderSid().longValue());
            if (bySid == null || CloudDeviceSourceEnum.PRE.getValue().equals(orderCloudDevice.getSourceFlag())) continue;
            orderCloudDevice.setSourceFlag(CloudDeviceSourceEnum.PRE.getValue());
            this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
        }
        LOGGER.info("43612200\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }
}

