/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.omc.domain.DeviceAttributeVO;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=43703)
@Service
public class UpgradeDatabaseV43702ToV43703Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43702ToV43703Service.class);
    @Autowired
    private OrderCloudDeviceRepository cloudDeviceRepository;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;

    public String version() {
        return "4.37.3.0";
    }

    public void update() {
        this.populateKind();
    }

    private void populateKind() {
        List all = this.cloudDeviceRepository.findAll();
        ArrayList<OrderCloudDevice> changed = new ArrayList<OrderCloudDevice>();
        for (OrderCloudDevice orderCloudDevice : all) {
            DeviceAttributeVO attribute = this.orderCloudDeviceService.getStrategyAttributeByOrderSid(orderCloudDevice.getOrderSid());
            if (ObjectUtils.nullSafeEquals((Object)attribute.getKind(), (Object)orderCloudDevice.getKind())) continue;
            orderCloudDevice.setKind(attribute.getKind());
            changed.add(orderCloudDevice);
        }
        this.cloudDeviceRepository.saveAll(changed);
    }
}

