/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.omc.constant.enums.ResAcquireModeEnum;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=43704)
@Service
public class UpgradeDatabaseV43703ToV43704Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43703ToV43704Service.class);
    @Autowired
    private OrderCloudDeviceRepository cloudDeviceRepository;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private IamService iamService;

    public String version() {
        return "4.37.4.0";
    }

    public void update() {
        logger.info("\u6570\u636e\u5347\u7ea7\u5f00\u59cb...");
        this.upgradeCloudDevice();
        logger.info("\u6570\u636e\u5347\u7ea7\u5b8c\u6210...");
    }

    private void upgradeCloudDevice() {
        List list = this.orderCloudDeviceMapper.getDeviceClouds(new CloudDeviceConditionVO(), 1, 9999, null);
        logger.info("\u4e91\u8bbe\u5907\u6570\u636e\u5347\u7ea7\uff0c\u67e5\u8be2\u5230\u7684\u4e91\u8bbe\u5907\u6570\u91cf\u4e3a\uff1a{}", (Object)list.size());
        if (list.isEmpty()) {
            return;
        }
        Map listMap = list.stream().filter(x -> StringUtils.hasLength((String)x.getTenantId())).collect(Collectors.groupingBy(OrderCloudDeviceVO::getTenantId, Collectors.mapping(OrderCloudDeviceVO::getSid, Collectors.toList())));
        Set<String> tenantIdSet = listMap.keySet();
        logger.info("\u4e91\u8bbe\u5907\u6570\u636e\u5347\u7ea7\uff0c\u67e5\u8be2\u5230\u7684\u4e91\u8bbe\u5907\u79df\u6237\u6570\u91cf\u4e3a\uff1a{}", (Object)tenantIdSet.size());
        List tenantList = this.iamService.getTenantSimples(new ArrayList<String>(tenantIdSet));
        List tenantIdList = tenantList.stream().filter(vo -> Objects.equals(ResAcquireModeEnum.APPLY_TO_O_M.getValue(), vo.getResAcquireMode())).map(CommonVO::getId).collect(Collectors.toList());
        logger.info("\u4e91\u8bbe\u5907\u6570\u636e\u5347\u7ea7\uff0c\u8fc7\u6ee4\u3010{}\u3011\u7684\u79df\u6237\u6570\u91cf\u4e3a\uff1a{}", (Object)ResAcquireModeEnum.APPLY_TO_O_M.getName(), (Object)tenantIdList.size());
        if (tenantIdList.isEmpty()) {
            return;
        }
        List updateSidList = tenantIdList.stream().flatMap(tenantId -> listMap.getOrDefault(tenantId, Collections.emptyList()).stream()).collect(Collectors.toList());
        List orderCloudDeviceList = this.cloudDeviceRepository.findAllById(updateSidList);
        orderCloudDeviceList.removeIf(orderCloudDevice -> Objects.equals(ResAcquireModeEnum.APPLY_TO_O_M.getValue(), orderCloudDevice.getResAcquireMode()));
        orderCloudDeviceList.forEach(orderCloudDevice -> orderCloudDevice.setResAcquireMode(ResAcquireModeEnum.APPLY_TO_O_M.getValue()));
        logger.info("\u66f4\u65b0\u7684\u4e91\u8d44\u6e90\u6570\u91cf\u4e3a\uff1a{}", (Object)orderCloudDeviceList.size());
        this.cloudDeviceRepository.saveAll((Iterable)orderCloudDeviceList);
    }
}

