/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43705)
@Service
public class UpgradeDatabaseV43704ToV43705Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43704ToV43705Service.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;

    public String version() {
        return "4.37.5.0";
    }

    public void update() {
        logger.info("\u6570\u636e\u5347\u7ea7\u5f00\u59cb...");
        this.createOrderSourceDict();
        logger.info("\u6570\u636e\u5347\u7ea7\u5b8c\u6210...");
    }

    private void createOrderSourceDict() {
        Dict dict = this.dictService.selectDictById("orderSource");
        if (null == dict) {
            dict = new Dict();
            dict.setSid(SnowFlake.getInstance().newId());
            dict.setId("orderSource");
            dict.setName("\u8ba2\u5355\u6765\u6e90");
            this.dictService.insertDict(dict);
        }
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId("orderSource");
        List dictDataList = this.dictDataService.selectDictDataList(condition);
        this.insertDictData(dictDataList, OrderSourceEnum.DigiwinCloud.name(), "\u9f0e\u6377\u4e91", Integer.valueOf(0));
        this.insertDictData(dictDataList, OrderSourceEnum.BossOnline.name(), "\u5ba2\u5236\u7ebf\u4e0a", Integer.valueOf(1));
        this.insertDictData(dictDataList, OrderSourceEnum.BossOffline.name(), "\u5ba2\u5236\u7ebf\u4e0b", Integer.valueOf(2));
        this.insertDictData(dictDataList, OrderSourceEnum.FII.name(), "FII", Integer.valueOf(3));
        this.insertDictData(dictDataList, OrderSourceEnum.HUAWEI.name(), "HUAWEI", Integer.valueOf(4));
        this.insertDictData(dictDataList, OrderSourceEnum.BossManualAuthorization.name(), "\u4eba\u5de5\u6388\u6743", Integer.valueOf(5));
    }

    private void insertDictData(List<DictData> dictDataList, String dictKey, String dictValue, Integer sort) {
        if (!dictDataList.stream().anyMatch(d -> d.getDictKey().equals(dictKey))) {
            DictData data = new DictData();
            data.setDictId("orderSource");
            data.setDictKey(dictKey);
            data.setDictValue(dictValue);
            data.setDictSort(sort);
            this.dictDataService.insertDictData(data);
        }
    }
}

