/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.dao.TenantCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.entity.Tenant;
import com.digiwin.dap.middleware.omc.mapper.TenantMapper;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=43706)
@Service
public class UpgradeDatabaseV43705ToV43706Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43705ToV43706Service.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantMapper tenantMapper;

    public String version() {
        return "4.37.6.0";
    }

    public void update() {
        logger.info("\u6570\u636e\u5347\u7ea7\u5f00\u59cb...");
        this.syncTestTenantInfo();
        logger.info("\u6570\u636e\u5347\u7ea7\u5b8c\u6210...");
    }

    private void syncTestTenantInfo() {
        List needDeleteTenants;
        List testTenantInfos = this.iamService.getTestTenantInfos();
        if (CollectionUtils.isEmpty((Collection)testTenantInfos)) {
            return;
        }
        Set testTenantSids = testTenantInfos.stream().map(CommonVO::getSid).collect(Collectors.toSet());
        List existsTenants = this.tenantCrudService.findAll();
        Set existsTenantSids = existsTenants.stream().map(BaseEntity::getSid).collect(Collectors.toSet());
        List needInsertTenants = testTenantInfos.stream().filter(testTenantInfo -> !existsTenantSids.contains(testTenantInfo.getSid())).map(testTenantInfo -> {
            Tenant tenant = new Tenant();
            tenant.setSid(testTenantInfo.getSid().longValue());
            tenant.setId(testTenantInfo.getId());
            tenant.setName(testTenantInfo.getName());
            tenant.setTestTenant(true);
            EntityUtils.setCreateFields((BaseEntity)tenant);
            return tenant;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needInsertTenants)) {
            for (int i = 0; i < needInsertTenants.size(); i += 1000) {
                this.tenantMapper.batchInsert(needInsertTenants.subList(i, Math.min(i + 1000, needInsertTenants.size())));
            }
        }
        if (!CollectionUtils.isEmpty(needDeleteTenants = existsTenants.stream().map(BaseEntity::getSid).filter(sid -> !testTenantSids.contains(sid)).collect(Collectors.toList()))) {
            for (int i = 0; i < needDeleteTenants.size(); i += 1000) {
                this.tenantMapper.batchDelete(needDeleteTenants.subList(i, Math.min(i + 1000, needDeleteTenants.size())));
            }
        }
    }
}

