/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.upgrade;

import com.digiwin.dap.middleware.omc.domain.DeviceAttributeVO;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=43707)
@Service
public class UpgradeDatabaseV43706ToV43707Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43706ToV43707Service.class);
    @Autowired
    private OrderCloudDeviceRepository cloudDeviceRepository;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;

    public String version() {
        return "4.37.7.0";
    }

    public void update() {
        this.updateCloudDeviceArea();
    }

    private void updateCloudDeviceArea() {
        List all = this.cloudDeviceRepository.findAll();
        logger.info("\u5f00\u59cb\u66f4\u65b0\u4e91\u7aef\u8bbe\u5907\u533a\u57df\u4fe1\u606f\uff0call\u6570\u91cf\uff1a{}", (Object)all.size());
        ArrayList<OrderCloudDevice> changed = new ArrayList<OrderCloudDevice>();
        for (OrderCloudDevice orderCloudDevice : all) {
            DeviceAttributeVO attribute;
            if (orderCloudDevice.getArea() != null || ObjectUtils.nullSafeEquals((Object)(attribute = this.orderCloudDeviceService.getStrategyAttributeByOrderSid(orderCloudDevice.getOrderSid())).getArea(), (Object)orderCloudDevice.getArea())) continue;
            orderCloudDevice.setArea(attribute.getArea());
            changed.add(orderCloudDevice);
        }
        this.cloudDeviceRepository.saveAll(changed);
        logger.info("\u66f4\u65b0\u4e91\u7aef\u8bbe\u5907\u533a\u57df\u4fe1\u606f\u5b8c\u6210\uff0cchanged\u6570\u91cf\uff1a{}", (Object)changed.size());
    }
}

