/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.validate.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.ShippingTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderDetailAuthorizationEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDetailDTO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.entity.PreOrder;
import com.digiwin.dap.middleware.omc.repository.PreOrderRepository;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.validate.ParameterCheckService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ParameterCheckServiceImpl
implements ParameterCheckService {
    @Autowired
    private PreOrderRepository preOrderRepository;
    @Autowired
    private PreOrderService preOrderService;

    public void checkPreOrder(PreOrderDTO dto, boolean isCreate) {
        Integer orderType;
        Assert.notNull((Object)dto.getTenantSid(), (String)"\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getTenantName(), (String)"\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getRemark(), (String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        List details = dto.getDetails();
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)details) ? 1 : 0) != 0, (String)"\u9884\u552e\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        details.forEach(o -> o.setAuthorization(Optional.ofNullable(o.getAuthorization()).orElse(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue())));
        if (isCreate) {
            orderType = dto.getOrderType();
            Assert.notNull((Object)orderType, (String)"\u9884\u552e\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Assert.notNull((Object)dto.getSid(), (String)"\u9884\u552e\u8ba2\u5355sid\u4e0d\u80fd\u4e3a\u7a7a");
            PreOrder oldPreOrder = (PreOrder)this.preOrderRepository.findById((Object)dto.getSid()).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_10009, new Object[]{dto.getSid()}));
            orderType = oldPreOrder.getOrderType();
        }
        if (PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue().equals(orderType)) {
            Assert.hasText((String)dto.getSourceBillCode(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            if (PreOrderSourceEnum.SaaSShipmentAuthorization.name().equals(dto.getOrderSource()) || PreOrderSourceEnum.AutoShipment.name().equals(dto.getOrderSource())) {
                this.checkSaaSShipmentAuthorization(dto);
            }
            Assert.isTrue((details.stream().filter(o -> Boolean.TRUE.equals(o.getMainStrategy())).count() == 1L ? 1 : 0) != 0, (String)"\u4eba\u5de5\u6388\u6743\u8ba2\u5355\u6709\u4e14\u4ec5\u80fd\u6709\u4e00\u4e2a\u4e3b\u7ecf\u9500\u65b9\u6848\u660e\u7ec6");
            details.forEach(o -> {
                Assert.notNull((Object)o.getGoodsSid(), (String)"\u5546\u54c1sid\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)o.getGoodsCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)o.getGoodsName(), (String)String.format("\u5546\u54c1(%s)\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsCode()));
                Assert.notNull((Object)o.getStrategySid(), (String)String.format("[%s(%s)]\u9500\u552e\u65b9\u6848sid\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
                Assert.hasText((String)o.getStrategyCode(), (String)String.format("[%s(%s)]\u9500\u552e\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
                Assert.hasText((String)o.getStrategyName(), (String)String.format("[%s(%s)]\u9500\u552e\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
                if (Boolean.TRUE.equals(o.getMainStrategy())) {
                    Assert.hasText((String)o.getCategoryId(), (String)String.format("[%s(%s)]\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
                    Assert.isTrue((boolean)GoodsCategoryEnum.mainStrategies().contains(o.getCategoryId()), (String)String.format("[%s(%s)]\u53ea\u53ef\u6311\u9009\u5546\u54c1\u7c7b\u578b\u4e3asaas\u3001\u5e73\u53f0\u670d\u52a1\u3001\u8bbe\u5907\u8d44\u6e90\u3001Api\u7c7b\u7684\u5546\u54c1\u3001\u8ba1\u91cf\u5546\u54c1", o.getGoodsName(), o.getGoodsCode()));
                    Assert.notNull((Object)o.getEffectiveDateTime(), (String)String.format("[%s(%s)]\u6388\u6743\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
                }
            });
        } else if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(orderType)) {
            details.forEach(o -> {
                Assert.notNull((Object)o.getGoodsSid(), (String)"\u5546\u54c1sid\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)o.getGoodsCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)o.getGoodsName(), (String)String.format("\u5546\u54c1(%s)\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsCode()));
                Assert.hasText((String)o.getCategoryId(), (String)String.format("[%s(%s)]\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
                Assert.isTrue((boolean)GoodsCategoryEnum.isApp((String)o.getCategoryId()), (String)"\u53ea\u53ef\u6311\u9009\u5546\u54c1\u7c7b\u578b\u4e3asaas\uff0c\u5e73\u53f0\u670d\u52a1\u7c7b\u7684\u5546\u54c1");
                Assert.notNull((Object)o.getEffectiveDateTime(), (String)String.format("[%s(%s)]\u6388\u6743\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", o.getGoodsName(), o.getGoodsCode()));
            });
        } else {
            throw new BusinessException("\u672a\u77e5\u7684\u9884\u552e\u8ba2\u5355\u7c7b\u578b");
        }
        if (ShipmentScenarioEnum.BORROWING.getValue().equals(dto.getShipmentScenario()) && ObjectUtils.isEmpty((Object)dto.getOperatorMail())) {
            throw new BusinessException((ErrorHandler)I18nError.OMC_PRE_ORDER_BORROW_NO_EMAIL);
        }
    }

    private void checkSaaSShipmentAuthorization(PreOrderDTO dto) {
        Assert.notNull((Object)dto.getShippingType(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u51fa\u8d27\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.isTrue((boolean)ShippingTypeEnum.contains((Integer)dto.getShippingType()), (String)"\u65e0\u6548\u7684SaaS\u51fa\u8d27\u6388\u6743\u7684\u51fa\u8d27\u7c7b\u578b[0\u51fa\u8d27\uff1b1\u501f\u8d27\uff1b2\u5176\u4ed6]");
        Assert.hasText((String)dto.getCompanyId(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u516c\u53f8\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)dto.getPotentialCustomerId(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u6f5c\u5ba2\u4ee3\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)dto.getShippingPersonnelCode(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u51fa\u8d27\u4eba\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
    }

    private void checkPreOrderAuthorization(PreOrderDTO dto, PreOrderDetailDTO o, boolean isCreate) {
        PreOrderDTO paramsDTO = new PreOrderDTO();
        paramsDTO.setTenantSid(dto.getTenantSid());
        paramsDTO.setGoodsSid(o.getGoodsSid());
        paramsDTO.setAuthorization(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue());
        List orderVOList = this.preOrderService.getPreOrderListExcludeDataPolicy(paramsDTO);
        if (!isCreate) {
            orderVOList = orderVOList.stream().filter(vo -> !vo.getSid().equals(dto.getSid())).collect(Collectors.toList());
        }
        if (!orderVOList.isEmpty()) {
            List orderCodeList = orderVOList.stream().map(PreOrderVO::getOrderCode).collect(Collectors.toList());
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10011, new Object[]{dto.getTenantId(), o.getGoodsCode(), orderCodeList});
        }
    }

    public void checkAcpPreOrder(List<PreOrderDTO> list) {
        list.forEach(dto -> {
            Assert.notNull((Object)dto.getShippingType(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u51fa\u8d27\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.isTrue((boolean)ShippingTypeEnum.contains((Integer)dto.getShippingType()), (String)"\u65e0\u6548\u7684SaaS\u51fa\u8d27\u6388\u6743\u7684\u51fa\u8d27\u7c7b\u578b[0\u51fa\u8d27\uff1b1\u501f\u8d27\uff1b2\u5176\u4ed6]");
            Assert.hasText((String)dto.getOrderSource(), (String)"\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)PreOrderSourceEnum.AutoShipment.name().equals(dto.getOrderSource()), (String)"\u6279\u91cf\u65b0\u589e\u9884\u552e\u8ba2\u5355\u7684\u6765\u6e90\u4e0d\u5c5e\u4e8e[\u81ea\u52a8\u51fa\u8d27(AutoShipment)]");
            Assert.hasText((String)dto.getCompanyId(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u516c\u53f8\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getSourceBillCode(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getPotentialCustomerId(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u6f5c\u5ba2\u4ee3\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getCustomerId(), (String)"\u79df\u6237\u5ba2\u670d\u4ee3\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getTenantId(), (String)"\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getShippingPersonnelCode(), (String)"SaaS\u51fa\u8d27\u6388\u6743\u7684\u51fa\u8d27\u4eba\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)dto.getDetails()) ? 1 : 0) != 0, (String)"\u9884\u552e\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            dto.getDetails().forEach(x -> {
                Assert.hasText((String)x.getGoodsCode(), (String)"\u5546\u54c1\u7f16\u7801code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                Assert.notNull((Object)x.getEffectiveDateTime(), (String)"\u6388\u6743\u751f\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                Assert.notNull((Object)x.getExpiredDateTime(), (String)"\u6388\u6743\u8fc7\u671f\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                Assert.notNull((Object)x.getTotalUsageBound(), (String)"\u6388\u6743U\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            });
        });
    }
}

