/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.util;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.AsyncExecutionInterceptor;
import org.springframework.aop.support.AopUtils;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AopProxyUtils {
    private static Field JdkDynamicProxy_h_FIELD = ReflectionUtils.findField(Proxy.class, (String)"h");
    private static Class JdkDynamicAopProxy_CLASS;
    private static Field JdkDynamicAopProxy_advised_FIELD;
    private static Class CglibAopProxy_CLASS;
    private static Class CglibAopProxy$DynamicAdvisedInterceptor_CLASS;
    private static Field CglibAopProxy$DynamicAdvisedInterceptor_advised_FIELD;
    private static Class ProxyFactory_CLASS;
    private static Field ProxyFactory_targetSource_FIELD;

    public static boolean isMultipleProxy(Object proxy) {
        try {
            ProxyFactory proxyFactory = null;
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                proxyFactory = AopProxyUtils.findJdkDynamicProxyFactory((Object)proxy);
            }
            if (AopUtils.isCglibProxy((Object)proxy)) {
                proxyFactory = AopProxyUtils.findCglibProxyFactory((Object)proxy);
            }
            TargetSource targetSource = (TargetSource)ReflectionUtils.getField((Field)ProxyFactory_targetSource_FIELD, (Object)proxyFactory);
            return AopUtils.isAopProxy((Object)Objects.requireNonNull(targetSource).getTarget());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("proxy args maybe not proxy with cglib or jdk dynamic proxy. this method not support", e);
        }
    }

    public static boolean isTransactional(Object proxy) {
        return AopProxyUtils.hasAdvice((Object)proxy, TransactionInterceptor.class);
    }

    public static void removeTransactional(Object proxy) {
        AopProxyUtils.removeAdvisor((Object)proxy, TransactionInterceptor.class);
    }

    public static boolean isAsync(Object proxy) {
        return AopProxyUtils.hasAdvice((Object)proxy, AsyncExecutionInterceptor.class);
    }

    public static void removeAsync(Object proxy) {
        AopProxyUtils.removeAdvisor((Object)proxy, AsyncExecutionInterceptor.class);
    }

    private static void removeAdvisor(Object proxy, Class<? extends Advice> adviceClass) {
        Advisor[] advisors;
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return;
        }
        ProxyFactory proxyFactory = null;
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            proxyFactory = AopProxyUtils.findJdkDynamicProxyFactory((Object)proxy);
        }
        if (AopUtils.isCglibProxy((Object)proxy)) {
            proxyFactory = AopProxyUtils.findCglibProxyFactory((Object)proxy);
        }
        if ((advisors = Objects.requireNonNull(proxyFactory).getAdvisors()) == null || advisors.length == 0) {
            return;
        }
        for (Advisor advisor : advisors) {
            if (!adviceClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            proxyFactory.removeAdvisor(advisor);
            break;
        }
    }

    private static boolean hasAdvice(Object proxy, Class<? extends Advice> adviceClass) {
        Advisor[] advisors;
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return false;
        }
        ProxyFactory proxyFactory = null;
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            proxyFactory = AopProxyUtils.findJdkDynamicProxyFactory((Object)proxy);
        }
        if (AopUtils.isCglibProxy((Object)proxy)) {
            proxyFactory = AopProxyUtils.findCglibProxyFactory((Object)proxy);
        }
        if ((advisors = Objects.requireNonNull(proxyFactory).getAdvisors()) == null || advisors.length == 0) {
            return false;
        }
        for (Advisor advisor : advisors) {
            if (!adviceClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            return true;
        }
        return false;
    }

    private static ProxyFactory findJdkDynamicProxyFactory(Object proxy) {
        Object jdkDynamicAopProxy = ReflectionUtils.getField((Field)JdkDynamicProxy_h_FIELD, (Object)proxy);
        return (ProxyFactory)ReflectionUtils.getField((Field)JdkDynamicAopProxy_advised_FIELD, (Object)jdkDynamicAopProxy);
    }

    private static ProxyFactory findCglibProxyFactory(Object proxy) {
        Field field = ReflectionUtils.findField(proxy.getClass(), (String)"CGLIB$CALLBACK_0");
        ReflectionUtils.makeAccessible((Field)field);
        Object CGLIB$CALLBACK_0 = ReflectionUtils.getField((Field)field, (Object)proxy);
        return (ProxyFactory)ReflectionUtils.getField((Field)CglibAopProxy$DynamicAdvisedInterceptor_advised_FIELD, (Object)CGLIB$CALLBACK_0);
    }

    static {
        ReflectionUtils.makeAccessible((Field)JdkDynamicProxy_h_FIELD);
        try {
            JdkDynamicAopProxy_CLASS = Class.forName("org.springframework.aop.framework.JdkDynamicAopProxy");
            JdkDynamicAopProxy_advised_FIELD = ReflectionUtils.findField((Class)JdkDynamicAopProxy_CLASS, (String)"advised");
            ReflectionUtils.makeAccessible((Field)JdkDynamicAopProxy_advised_FIELD);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            CglibAopProxy_CLASS = Class.forName("org.springframework.aop.framework.CglibAopProxy");
            CglibAopProxy$DynamicAdvisedInterceptor_CLASS = Class.forName("org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor");
            CglibAopProxy$DynamicAdvisedInterceptor_advised_FIELD = ReflectionUtils.findField((Class)CglibAopProxy$DynamicAdvisedInterceptor_CLASS, (String)"advised");
            ReflectionUtils.makeAccessible((Field)CglibAopProxy$DynamicAdvisedInterceptor_advised_FIELD);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        ProxyFactory_CLASS = ProxyFactory.class;
        ProxyFactory_targetSource_FIELD = ReflectionUtils.findField((Class)ProxyFactory_CLASS, (String)"targetSource");
        ReflectionUtils.makeAccessible((Field)ProxyFactory_targetSource_FIELD);
    }
}

