/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.util;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy/MM/dd";
    public static final String YYYY_MM_DD_2 = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_3 = "yyyy-MM";

    public static String getDateStr() {
        return DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateStr(String formatter) {
        return DateUtil.getDateStr((LocalDateTime)LocalDateTime.now(), (String)formatter);
    }

    public static String getDateStr(LocalDateTime date, String formatter) {
        Assert.notNull((Object)date, (String)"\u683c\u5f0f\u5316\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(formatter);
        return dtf.format(date);
    }

    public static String getDateStr(LocalDateTime date) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dtf.format(date);
    }

    public static long toEndDayMillis() {
        return DateUtil.toEndDay().toMillis();
    }

    public static long toEndMonthMillis() {
        return DateUtil.toEndMonth().toMillis();
    }

    public static Duration toEndDay() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dayEnd = LocalDateTime.of(now.plusDays(1L).toLocalDate(), LocalTime.MIN);
        return Duration.between(now, dayEnd);
    }

    public static Duration toEndMonth() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime lastDayOfMonth = now.with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime dayEnd = LocalDateTime.of(lastDayOfMonth.plusDays(1L).toLocalDate(), LocalTime.MIN);
        return Duration.between(now, dayEnd);
    }
}

