/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.component.snowflake;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeIdConfig;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdConfig;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdHandler;
import com.jugg.agile.framework.meta.exception.JaException;

public class JaSnowflakeClusterAdapter {
    private static WorkerIdHandler clusterWorkerIdHandler;
    private static Long workerId;

    private JaSnowflakeClusterAdapter() {
    }

    public static WorkerIdHandler getClusterWorkerIdHandler() {
        return clusterWorkerIdHandler;
    }

    public static void setClusterWorkerIdHandler(WorkerIdHandler clusterWorkerIdHandler) {
        JaSnowflakeClusterAdapter.clusterWorkerIdHandler = clusterWorkerIdHandler;
    }

    public static Long getWorkerId() {
        return workerId;
    }

    public static void setWorkerId(Long workerId) {
        JaSnowflakeClusterAdapter.workerId = workerId;
    }

    public static void initClusterWorkerIdHandler() {
        Long workerIdBit = JaProperty.getLong((String)"ja.id.snowflake.workerIdBit", (Long)3L);
        long maxWorkerId = (1L << (int)workerIdBit.longValue()) - 1L;
        if (workerId > maxWorkerId) {
            throw new JaException(String.format("workerId %d exceeds max limit %d (workerIdBit=%d)", workerId, maxWorkerId, workerIdBit), new Object[0]);
        }
        clusterWorkerIdHandler = () -> WorkerIdConfig.builder().workerId(workerId.longValue()).workerIdBit(JaProperty.getLong((String)"ja.id.snowflake.workerIdBit", (Long)3L).longValue()).build();
    }

    public static JaSnowflakeId createDefault() {
        JaSnowflakeIdConfig orderIdConfig = new JaSnowflakeIdConfig();
        orderIdConfig.setBeginTimeStr("2025-11-07 20:43:30");
        orderIdConfig.setSequenceNumberBit(6L);
        orderIdConfig.setTimeUnit(500L);
        return JaSnowflakeId.newInstance((JaSnowflakeIdConfig)orderIdConfig, (WorkerIdHandler)clusterWorkerIdHandler);
    }
}

