/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.component.snowflake;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jugg.agile.component.snowflake.JaSnowflakeClusterAdapter;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLockAdapter;
import com.jugg.agile.framework.core.lock.distributed.JaDistributedLockEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.algorithm.JaMathUtil;
import com.jugg.agile.framework.meta.exception.JaException;
import com.jugg.agile.middleware.nacos.discovery.JaNacosDiscoveryPropertiesProcessor;
import com.jugg.agile.middleware.nacos.discovery.JaNamingService;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;

@Configuration
public class JaSnowflakeConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        if (Boolean.TRUE.equals(JaProperty.getBoolean((String)"ja.id.snowflake.cluster.enabled", (Boolean)false))) {
            JaDistributedLockEntity lockEntity = JaDistributedLockEntity.builder().lockKey(String.format("ja.snowflake.clusterWorkId.init:%s", JaEnvProperty.getApplicationName())).spinTime(JaProperty.getLong((String)"ja.snowflake.clusterWorkId.init.spinTime", (Long)2L).longValue()).spinNum(JaProperty.getLong((String)"ja.snowflake.clusterWorkId.init.spinNum", (Long)3L).longValue()).build();
            JaSnowflakeClusterAdapter.setWorkerId((Long)JaDistributedLockAdapter.lock((JaDistributedLockEntity)lockEntity, () -> {
                Instance currentInstance = JaNamingService.getCurrentInstanceWithRetry();
                if (currentInstance == null) {
                    throw new JaException("snowflake cluster workId init error, currentInstance is empty", new Object[0]);
                }
                SortedSet<Long> idSet = this.collectUsedWorkerIds();
                Long availableId = JaMathUtil.findMinAvailableId(idSet);
                currentInstance.getMetadata().put("ja.nacos.clusterId", availableId.toString());
                JaNamingService.getNamingService().registerInstance(JaNacosDiscoveryPropertiesProcessor.getNacosDiscoveryProperties().getService(), JaNacosDiscoveryPropertiesProcessor.getNacosDiscoveryProperties().getGroup(), currentInstance);
                return availableId;
            }));
            JaSnowflakeClusterAdapter.initClusterWorkerIdHandler();
            JaLog.info((String)"snowflake cluster workId init : {}", (Object[])new Object[]{JaSnowflakeClusterAdapter.getWorkerId()});
        }
    }

    private SortedSet<Long> collectUsedWorkerIds() {
        List currentInstanceList = JaNamingService.getCurrentInstanceList();
        TreeSet<Long> idSet = new TreeSet<Long>();
        for (Instance instance : currentInstanceList) {
            Long clusterId;
            if (!instance.isHealthy()) {
                JaLog.warn((String)"skip unhealthy instance: {}", (Object[])new Object[]{instance.getInstanceId()});
                continue;
            }
            String clusterIdStr = (String)instance.getMetadata().get("ja.nacos.clusterId");
            if (JaStringUtil.isEmpty((String)clusterIdStr) || idSet.add(clusterId = Long.valueOf(Long.parseLong(clusterIdStr)))) continue;
            throw new JaException(String.format("snowflake cluster workId init error: duplicate id=%d in instance=%s", clusterId, instance.getInstanceId()), new Object[0]);
        }
        JaLog.info((String)"snowflake workerId init: totalInstances={}, usedIds={}", (Object[])new Object[]{currentInstanceList.size(), idSet});
        return idSet;
    }
}

