package com.digiwin.dap.nest.component.snowflake;

import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.util.algorithm.id.snowflake.JaSnowflakeId;
import com.digiwin.dap.nest.kernel.core.util.algorithm.id.snowflake.JaSnowflakeIdConfig;
import com.digiwin.dap.nest.kernel.core.util.algorithm.id.snowflake.WorkerIdConfig;
import com.digiwin.dap.nest.kernel.core.util.algorithm.id.snowflake.WorkerIdHandler;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;

/**
 * Athena工作节点ID处理器
 * 负责提供雪花算法的工作节点配置
 *
 * @author wzq
 */
public class JaSnowflakeClusterAdapter {

    private JaSnowflakeClusterAdapter() {
    }

    /**
     * 给个默认值
     * 防止workId没有初始化完成，mq消息已经进行消费了
     */
    private static WorkerIdHandler clusterWorkerIdHandler;

    private static Long workerId;

    public static WorkerIdHandler getClusterWorkerIdHandler() {
        return clusterWorkerIdHandler;
    }

    public static void setClusterWorkerIdHandler(WorkerIdHandler clusterWorkerIdHandler) {
        JaSnowflakeClusterAdapter.clusterWorkerIdHandler = clusterWorkerIdHandler;
    }

    public static Long getWorkerId() {
        return workerId;
    }

    public static void setWorkerId(Long workerId) {
        JaSnowflakeClusterAdapter.workerId = workerId;
    }

    public static void initClusterWorkerIdHandler() {
        Long workerIdBit = DwProperty.getLong(WorkerIdHandler.KeyBit, 3L);
        long maxWorkerId = (1L << workerIdBit) - 1;
        if (workerId > maxWorkerId) {
            throw new DwException(String.format(
                    "workerId %d exceeds max limit %d (workerIdBit=%d)",
                    workerId, maxWorkerId, workerIdBit));
        }
        clusterWorkerIdHandler = () -> WorkerIdConfig.builder()
                .workerId(workerId)
                .workerIdBit(DwProperty.getLong(WorkerIdHandler.KeyBit, 3L))
                .build();
    }

    public static JaSnowflakeId createDefault() {
        JaSnowflakeIdConfig orderIdConfig = new JaSnowflakeIdConfig();
        orderIdConfig.setBeginTimeStr("2025-11-07 20:43:30");
        orderIdConfig.setSequenceNumberBit(6);
        orderIdConfig.setTimeUnit(500);
        return JaSnowflakeId.newInstance(orderIdConfig, clusterWorkerIdHandler);
    }
}
