/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.component.snowflake;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.dap.nest.component.snowflake.JaSnowflakeClusterAdapter;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery.JaNacosDiscoveryPropertiesProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery.JaNamingService;
import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.JaEnvProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.lock.distributed.JaDistributedLockAdapter;
import com.digiwin.dap.nest.kernel.core.lock.distributed.JaDistributedLockEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.algorithm.JaMathUtil;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;

@Configuration
public class JaSnowflakeConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        if (Boolean.TRUE.equals(DwConfig.getBoolean((String)"id.snowflake.cluster.enabled", (Boolean)false))) {
            JaDistributedLockEntity lockEntity = JaDistributedLockEntity.builder().lockKey(String.format("dw.id.snowflake.clusterWorkId.init:%s", JaEnvProperty.getApplicationName())).spinTime(DwProperty.getLong((String)"dw.id.snowflake.clusterWorkId.init.spinTime", (Long)2L).longValue()).spinNum(DwProperty.getLong((String)"dw.id.snowflake.clusterWorkId.init.spinNum", (Long)3L).longValue()).build();
            JaSnowflakeClusterAdapter.setWorkerId((Long)JaDistributedLockAdapter.lock((JaDistributedLockEntity)lockEntity, () -> {
                Instance currentInstance = JaNamingService.getCurrentInstanceWithRetry();
                if (currentInstance == null) {
                    throw new DwException("snowflake cluster workId init error, currentInstance is empty", new Object[0]);
                }
                SortedSet<Long> idSet = this.collectUsedWorkerIds();
                Long availableId = JaMathUtil.findMinAvailableId(idSet);
                currentInstance.getMetadata().put("dw.nacos.clusterId", availableId.toString());
                JaNamingService.getNamingService().registerInstance(JaNacosDiscoveryPropertiesProcessor.getNacosDiscoveryProperties().getService(), JaNacosDiscoveryPropertiesProcessor.getNacosDiscoveryProperties().getGroup(), currentInstance);
                return availableId;
            }));
            JaSnowflakeClusterAdapter.initClusterWorkerIdHandler();
            JaLog.info((String)"snowflake cluster workId init : {}", (Object[])new Object[]{JaSnowflakeClusterAdapter.getWorkerId()});
        }
    }

    private SortedSet<Long> collectUsedWorkerIds() {
        List currentInstanceList = JaNamingService.getCurrentInstanceList();
        TreeSet<Long> idSet = new TreeSet<Long>();
        for (Instance instance : currentInstanceList) {
            Long clusterId;
            if (!instance.isHealthy()) {
                JaLog.warn((String)"skip unhealthy instance: {}", (Object[])new Object[]{instance.getInstanceId()});
                continue;
            }
            String clusterIdStr = (String)instance.getMetadata().get("dw.nacos.clusterId");
            if (DwStringUtil.isEmpty((String)clusterIdStr) || idSet.add(clusterId = Long.valueOf(Long.parseLong(clusterIdStr)))) continue;
            throw new DwException(String.format("snowflake cluster workId init error: duplicate id=%d in instance=%s", clusterId, instance.getInstanceId()), new Object[0]);
        }
        JaLog.info((String)"snowflake workerId init: totalInstances={}, usedIds={}", (Object[])new Object[]{currentInstanceList.size(), idSet});
        return idSet;
    }
}

