/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.component.snowflake;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.dap.nest.component.snowflake.DwSnowflakeClusterAdapter;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery.DwNacosDiscoveryPropertiesProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery.DwNamingService;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringCloudFix;
import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLockAdapter;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLockEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.algorithm.JaMathUtil;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;

@Order(value=0)
@Configuration
public class DwSnowflakeClusterConfiguration
implements ApplicationListener<InstanceRegisteredEvent<?>> {
    public void onApplicationEvent(@NonNull InstanceRegisteredEvent event) {
        if (!DwSpringCloudFix.isCloudContainer() && Boolean.TRUE.equals(DwConfig.getBoolean((String)"id.snowflake.cluster.enabled", (Boolean)false))) {
            DwDistributedLockEntity lockEntity = DwDistributedLockEntity.builder().lockKey(String.format("dw.id.snowflake.clusterWorkId.init:%s", DwEnvProperty.getApplicationName())).spinTime(DwProperty.getLong((String)"dw.id.snowflake.clusterWorkId.init.spinTime", (Long)2L).longValue()).spinNum(DwProperty.getLong((String)"dw.id.snowflake.clusterWorkId.init.spinNum", (Long)3L).longValue()).build();
            DwSnowflakeClusterAdapter.setWorkerId((Long)DwDistributedLockAdapter.lock((DwDistributedLockEntity)lockEntity, () -> {
                Instance currentInstance = DwNamingService.getCurrentInstanceWithRetry();
                if (currentInstance == null) {
                    throw new DwException("snowflake cluster workId init error, currentInstance is empty", new Object[0]);
                }
                SortedSet<Long> idSet = this.collectUsedWorkerIds();
                Long availableId = JaMathUtil.findMinAvailableId(idSet);
                currentInstance.getMetadata().put("dw.nacos.clusterId", availableId.toString());
                DwNamingService.getNamingService().registerInstance(DwNacosDiscoveryPropertiesProcessor.getNacosDiscoveryProperties().getService(), DwNacosDiscoveryPropertiesProcessor.getNacosDiscoveryProperties().getGroup(), currentInstance);
                return availableId;
            }));
            DwSnowflakeClusterAdapter.initClusterWorkerIdHandler();
            DwLog.info((String)"snowflake cluster workId init : {}", (Object[])new Object[]{DwSnowflakeClusterAdapter.getWorkerId()});
        }
    }

    private SortedSet<Long> collectUsedWorkerIds() {
        List currentInstanceList = DwNamingService.getCurrentInstanceList();
        TreeSet<Long> idSet = new TreeSet<Long>();
        for (Instance instance : currentInstanceList) {
            Long clusterId;
            if (!instance.isHealthy()) {
                DwLog.warn((String)"skip unhealthy instance: {}", (Object[])new Object[]{instance.getInstanceId()});
                continue;
            }
            String clusterIdStr = (String)instance.getMetadata().get("dw.nacos.clusterId");
            if (DwStringUtil.isEmpty((String)clusterIdStr) || idSet.add(clusterId = Long.valueOf(Long.parseLong(clusterIdStr)))) continue;
            throw new DwException(String.format("snowflake cluster workId init error: duplicate id=%d in instance=%s", clusterId, instance.getInstanceId()), new Object[0]);
        }
        DwLog.info((String)"snowflake workerId init: totalInstances={}, usedIds={}", (Object[])new Object[]{currentInstanceList.size(), idSet});
        return idSet;
    }
}

