package com.digiwin.dap.nest.infrastructure.middleware.kafka.producer;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.processor.JaYamlProcessor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.StringSerializer;

import java.util.Map;
import java.util.Properties;

public class JaKafkaProducerProcessor {
    private JaKafkaProducerProcessor() {
    }

    /**
     * 补全kafka消费者默认配置
     *
     * @author chenjian
     * @since 2025年08月28日 10:14:08
     */
    public static Properties wrapProperties(Properties kafkaProperties) {
        kafkaProperties.putIfAbsent("key.serializer", StringSerializer.class.getName());
        kafkaProperties.putIfAbsent("value.serializer", StringSerializer.class.getName());
        kafkaProperties.put("acks", kafkaProperties.get("acks") + "");
        return kafkaProperties;
    }

    /**
     * 获取所有消费者对应配置
     * key 消费者名, value kafka消费者配置
     */
    public static Map<String, Properties> getPropertiesMap() {
        String prefix = DwConfig.KeyPrefix + "kafka.producer";
        Map<String, Properties> propertiesMap = JaYamlProcessor.getProperties(JaYamlProcessor.getMap(DwProperty.getPropertyMap(), prefix), prefix);
        propertiesMap.forEach((k, v) -> wrapProperties(v));
        return propertiesMap;
    }

    public static Producer<String, String> createProducer(Properties properties) {
        return new KafkaProducer<>(wrapProperties(properties));
    }


}
