package com.digiwin.dap.nest.infrastructure.middleware.kafka.test;

import com.alibaba.fastjson.JSON;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class TestKafkaProducer {
    public static void main(String[] args) throws ExecutionException, InterruptedException {
        Properties props = new Properties();
        props.put("bootstrap.servers", "10.176.187.18:9092,10.176.187.17:9092,10.176.187.16:9092");
        // 关键字的序列化类，实现以下接口： org.apache.kafka.common.serialization.Serializer 接口
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        // 0 : 无论是否成功, 1 : 单节点磁盘持久化成功, all : 所有磁盘持久化
        props.put("acks", "all");
        // Producer 用来缓冲等待被发送到服务器的记录的总字节数。如果记录发送的速度比发送到服务器的速度快， Producer 就会阻塞，如果阻塞的时间超过 max.block.ms 配置的时长，则会抛出一个异常。
        // 32MB
        props.put("buffer.memory", 33554432);
        // Producer 生成数据时可使用的压缩类型。默认值是none(即不压缩)
        // 可配置的压缩类型包括：none, gzip, snappy, 或者 lz4
        // 压缩是针对批处理的所有数据，所以批处理的效果也会影响压缩比(更多的批处理意味着更好的压缩)。
        props.put("compression.type", "none");
        // 队列字节大小
        // 当多个消息要发送到相同分区的时，生产者尝试将消息批量打包在一起，以减少请求交互。这样有助于客户端和服务端的性能提升
        props.put("batch.size", 6144);
        props.put("linger.ms", 10);
//        props.put("client.id", jae.getApplication() + "-" + DrpPropertySystem.getLocalIP());


        // 同一个key的message可以保证只发送到同一个partition
        // 重试
        props.put("retries", 3);
        // 保证重试有序
        // 在发生阻塞之前，客户端的一个连接上允许出现未确认请求的最大数量。注意，如果这个设置大于1，
        // 并且有失败的发送，则消息可能会由于重试而导致重新排序(如果重试是启用的话)
        props.put("max.in.flight.requests.per.connection", 1);
        // 可以解决顺序性问题，并且允许max.in.flight.requests.per.connection设置大于1
        props.put("enable.idempotence", true);


        Producer<String, String> producer = new KafkaProducer<>(props);
        ProducerRecord<String, String> producerRecord = new ProducerRecord<>("testTopic", "key", "value");
        Callback callback = new Callback() {
            @Override
            public void onCompletion(RecordMetadata metadata, Exception exception) {
                System.out.println("metadata" + JSON.toJSONString(metadata));
                System.out.println("metadata -> " + metadata.partition());
                System.out.println("exception" + JSON.toJSONString(exception));
            }
        };
        Future<RecordMetadata> testTopic = producer.send(producerRecord, callback);
        System.out.println(JSON.toJSONString(testTopic));
        System.out.println(JSON.toJSONString(testTopic.get()));

        producer.close();
    }

}
