package com.digiwin.dap.nest.infrastructure.middleware.kafka.producer;

import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.DwJson;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.util.Properties;
import java.util.concurrent.Future;

/**
 * 默认 KafkaProducer<String, String>
 *
 * @author chenjian
 * @since 2025年09月08日 15:14:24
 */
public class DwKafkaProducer extends KafkaProducer<String, String> {
    public DwKafkaProducer(Properties properties) {
        super(properties);
    }

    public <T> Future<RecordMetadata> send(String topic, String key, T message) {
        return this.send(new ProducerRecord<>(topic, key, DwJson.toString(message)));
    }
}
