/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.kafka.producer;

import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.processor.DwYamlProcessor;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.StringSerializer;

public class DwKafkaProducerProcessor {
    private DwKafkaProducerProcessor() {
    }

    public static Properties wrapProperties(Properties kafkaProperties) {
        kafkaProperties.putIfAbsent("key.serializer", StringSerializer.class.getName());
        kafkaProperties.putIfAbsent("value.serializer", StringSerializer.class.getName());
        kafkaProperties.put("acks", String.valueOf(kafkaProperties.get("acks")));
        return kafkaProperties;
    }

    public static Map<String, Properties> getPropertiesMap() {
        String prefix = "dw.kafka.producer";
        Map propertiesMap = DwYamlProcessor.getProperties((Map)DwYamlProcessor.getMap((Map)DwProperty.getPropertyMap(), (String)prefix), (String)prefix);
        propertiesMap.forEach((k, v) -> DwKafkaProducerProcessor.wrapProperties(v));
        return propertiesMap;
    }

    public static Producer<String, String> createProducer(Properties properties) {
        return new KafkaProducer(DwKafkaProducerProcessor.wrapProperties(properties));
    }
}

