package com.jugg.agile.middleware.mongodb.spring;

import com.jugg.agile.framework.core.util.JaValidateUtil;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * MongoTemplate处理器
 *
 * @author chenjian
 * @since 2024年09月25日 17:41:20
 */
public class JaMongoTemplateProcessor {

    /**
     * 简单创建
     */
    public static MongoTemplate createSimple(String database, String uri) {
        JaValidateUtil.notNull(database, () -> "create MongoTemplate error : database is null");
        JaValidateUtil.notNull(uri, () -> "create MongoTemplate error : uri is null");

        // 使用 MongoClients 工厂方法创建客户端
        MongoClient client = MongoClients.create(
                MongoClientSettings.builder()
                        .retryWrites(false)
                        .applyConnectionString(new ConnectionString(uri))
                        .build()
        );

        return new MongoTemplate(client, database);
    }

}
