package com.digiwin.dap.nest.infrastructure.middleware.mongodb.test;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import org.bson.Document;
import org.bson.conversions.Bson;

/**
 * https://www.mongodb.com/zh-cn/docs/drivers/java/sync/current/usage-examples/findOne/
 * https://www.mongodb.com/zh-cn/docs/drivers/java/sync/v4.3/quick-start/#working-with-pojos--optional-
 * https://www.mongodb.com/zh-cn/docs/drivers/java/sync/v4.3/
 * <p>
 * https://www.mongodb.com/zh-cn/docs/drivers/java/sync/current/upgrade/
 * <p>
 * https://docs.spring.io/spring-data/data-mongodb/reference/migration-guide/migration-guide-3.x-to-4.x.html
 *
 * @author chenjian
 * @since 2024年09月04日 13:08:57
 */
public class TestConnect {
    public static void main(String[] args) {
        // Replace the placeholder with your Atlas connection string
        // mongodb+srv://<db_username>:<db_password>@<clusterName>.mongodb.net/?retryWrites=true&w=majority
        // Replace the placeholder with your MongoDB deployment's connection string
        String uri = "mongodb://ThemeMap:ThemeMap!QAZ2wsx@47.102.215.110:22696";
        try (MongoClient mongoClient = MongoClients.create(uri)) {
            MongoDatabase database = mongoClient.getDatabase("uibot_tag");
            String name = database.getName();


            MongoCollection<Document> collection = database.getCollection("tag-definition");

            System.out.println();

            // Creates instructions to project two document fields
            Bson projectionFields = Projections.fields(
                    Projections.include("title", "imdb"),
                    Projections.excludeId());
            // Retrieves the first matching document, applying a projection and a descending sort to the results
            Document doc = collection.find(Filters.eq("title", "The Room"))
                    .projection(projectionFields)
                    .sort(Sorts.descending("imdb.rating"))
                    .first();
            // Prints a message if there are no result documents, or prints the result document as JSON
            if (doc == null) {
                System.out.println("No results found.");
            } else {
                System.out.println(doc.toJson());
            }
        }

    }
}
