package com.digiwin.dap.nest.infrastructure.middleware.mongodb.dapper;

import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAopUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(name = {DwNodeSpanMongoTemplate.ProxyClassName})
public class DwNodeSpanMongoTemplate implements JaNodeSpanResolver, JaDapperAspectPointcut {

    public static final String ProxyClassName = "org.springframework.data.mongodb.core.MongoTemplate";

    private static final NodeKind mongoTemplateNodeKind = new NodeKind("mongodb")
            .buildNodeIdHandler(JaAopUtil::getSimpleName);

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (invocation instanceof ReflectiveMethodInvocation) {
            Object proxy = ((ReflectiveMethodInvocation) invocation).getProxy();
            if (proxy.toString().startsWith(ProxyClassName)) {
                return get(mongoTemplateNodeKind);
            }
        }
        return null;
    }

    @Override
    public String getExpression() {
        return "execution(* org.springframework.data.mongodb.core.MongoOperations.*(..))";
    }

}
